/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.silence.util;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.silence.entity.SilenceTaskRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskFileParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TaskFileParser.class);
    private static final String WORKPATHEXP = "//workPath";
    private static final String LANGUAGEEXP = "//language";
    private static final String DEVICEEXP = "//device";
    private static final String PARAMEXP = "//param";
    private static final int DEFAULT_PORT = 22;
    private SilenceTaskRequest taskInfo = new SilenceTaskRequest();

    public SilenceTaskRequest parse(String taskFilePath) throws ToolException {
        File taskFile = FilePathUtils.checkFile((File)new File(taskFilePath));
        if (!taskFile.exists()) {
            LOGGER.error("Task file : '" + taskFilePath + "' is not exists! task failed");
            throw new ToolException("silence.taskfile.notexist");
        }
        try {
            Document doc = XmlUtils.parseDocument((InputStream)new FileInputStream(taskFile));
            NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)WORKPATHEXP);
            String workPath = TaskFileParser.getFirstTextContent(nodeList);
            this.taskInfo.setWorkPath(workPath);
            nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)LANGUAGEEXP);
            String language = TaskFileParser.getFirstTextContent(nodeList);
            ApplicationContext.getInstance().setCurrentLanguage("en".equals(language) ? Locale.ENGLISH : Locale.SIMPLIFIED_CHINESE);
            nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)DEVICEEXP);
            List<DevNode> devNodes = this.parseNodeInfo(nodeList);
            this.taskInfo.setDevs(devNodes);
            nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)PARAMEXP);
            Map<String, String> params = TaskFileParser.parseParamList(nodeList);
            this.taskInfo.setParams(params);
        }
        catch (Exception e) {
            LOGGER.error("Task file parse error.", (Throwable)e);
            throw new ToolException("silence.taskfile.parseError");
        }
        finally {
            boolean delete = taskFile.delete();
            LOGGER.info("delete taskFile result : {}", (Object)delete);
        }
        return this.taskInfo;
    }

    private static String getFirstTextContent(NodeList nodeList) {
        if (nodeList == null) {
            return "";
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            return e.getTextContent();
        }
        LOGGER.info("Can not find text content.");
        return "";
    }

    private List<DevNode> parseNodeInfo(NodeList nodeList) {
        if (null == nodeList) {
            return null;
        }
        ArrayList<DevNode> devList = new ArrayList<DevNode>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e;
            DevNode devNode;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || null == (devNode = this.buildDevNode(e = (Element)node))) continue;
            devList.add(devNode);
        }
        return devList;
    }

    private DevNode buildDevNode(Element element) {
        String innerIps;
        DevNode devNode = new DevNode();
        int port = 22;
        String portStr = element.getAttribute("port");
        if (!StringUtils.isNULLStr((String)portStr)) {
            port = Integer.valueOf(portStr);
            devNode.setPort(port);
        }
        devNode.setIp(TaskFileParser.resetDevIp(element.getAttribute("devIP"), port));
        devNode.setProductVersion(element.getAttribute("devVersion"));
        devNode.setDeveloperPwd(AESEncrypt.decrypt((String)element.getAttribute("developerPwd")));
        devNode.setDeviceName(element.getAttribute("deviceName"));
        devNode.setDeviceSerialNumber(element.getAttribute("serialNo"));
        devNode.setDeviceType(DeviceType.valueOf(element.getAttribute("deviceType")));
        String userName = element.getAttribute("username");
        String password = element.getAttribute("password");
        devNode.setSshHostKey(AESEncrypt.decrypt((String)element.getAttribute("sshHostKey")));
        devNode.setVerifySshHostKey(Boolean.valueOf(AESEncrypt.decrypt((String)element.getAttribute("isVerifySshHostKey"))));
        User user = new User(AESEncrypt.decrypt((String)userName), AESEncrypt.decrypt((String)password));
        devNode.setLoginUser(user);
        devNode.setVerifyCertificate(Boolean.parseBoolean(AESEncrypt.decrypt((String)element.getAttribute("isVerifyCert"))));
        String publicKeyPath = element.getAttribute("publicKeyPath");
        if (!StringUtils.isNULLStr((String)publicKeyPath)) {
            LOGGER.info("Parse publicKeyPath : {}", (Object)publicKeyPath);
            PriKeyInfo priKey = new PriKeyInfo();
            priKey.setKeyPath(AESEncrypt.decrypt((String)publicKeyPath));
            priKey.setKeyPwd(AESEncrypt.decrypt((String)element.getAttribute("publicKeyPwd")));
            devNode.setPriKey(priKey);
        }
        if (!StringUtils.isNULLStr((String)(innerIps = element.getAttribute("devInnerIP")))) {
            String[] innerIpArr;
            devNode.setIpListAreInnerIp(true);
            for (String innerIp : innerIpArr = innerIps.split(";")) {
                devNode.addIp(innerIp);
            }
            LOGGER.info("Device {} set innerIp : {}", (Object)devNode.getIp(), devNode.getIpList());
        }
        if (StringUtils.isNULLStr((String)password)) {
            LOGGER.error("device password is empty.");
            return null;
        }
        return devNode;
    }

    private static String resetDevIp(String ipStr, int port) {
        if (StringUtils.isNULLStr((String)ipStr)) {
            return "";
        }
        String[] ips = ipStr.split(";");
        if (ips.length > 1) {
            for (String ip : ips) {
                if (!NetUtil.isHostConnectable(ip, port)) continue;
                return ip;
            }
        }
        return ipStr;
    }

    private static Map<String, String> parseParamList(NodeList nodeList) {
        if (null == nodeList) {
            return null;
        }
        HashMap<String, String> patchInfo = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            String deviceSN = e.getAttribute("key");
            String patchPath = e.getAttribute("value");
            LOGGER.info("Parse mapping info : {} patch path : {}", (Object)deviceSN, (Object)patchPath);
            patchInfo.put(deviceSN, patchPath);
        }
        return patchInfo;
    }
}

