/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.silence.util;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.silence.entity.DeviceResultInfo;
import com.huawei.ism.tool.silence.entity.SilenceTaskResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class TaskProgressFileWirter {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TaskProgressFileWirter.class);
    private static final String SERIALNO = "serialNo";
    private static final String RESULT = "result";
    private static final String UPDATE_TIME = "updateTime";
    private static final String PROGRESS = "progress";
    private static final String DEVICE = "device";
    private static final String STATUS = "status";
    private static final String ERR_MSG = "errMsg";
    private static final String BIZSTATUS = "bizStatus";
    private static final String OPERATION = "operation";
    private static final String PROGRESS_XML = "Progress.xml";
    private org.w3c.dom.Document document = null;
    private String workpath = "";

    public TaskProgressFileWirter(String workpath) throws ToolException {
        this.workpath = workpath;
        File file = new File(workpath, PROGRESS_XML);
        if (file.exists()) {
            FileUtils.deleteFile((File)file);
        }
        this.initProgressXml(file);
    }

    private void initProgressXml(File file) throws ToolException {
        try {
            file.createNewFile();
            this.document = XmlUtils.newDocumentBuilder().newDocument();
            Element element = this.document.createElement(PROGRESS);
            this.document.appendChild(element);
            Transformer transformer = XmlUtils.newTransformer();
            transformer.setOutputProperty("indent", "YES");
            transformer.setOutputProperty("method", "XML");
            TaskProgressFileWirter.transformDOMToStream(file, this.document, transformer);
        }
        catch (Exception e) {
            LOGGER.error("create progress file failed", (Throwable)e);
            throw new ToolException("silence.result.file.initError");
        }
    }

    public void write(SilenceTaskResponse rsp) throws ToolException {
        File file = new File(this.workpath, PROGRESS_XML);
        try {
            Document doc = XmlUtils.getSaxReader().read(file);
            org.dom4j.Element rootElement = doc.getRootElement();
            this.writeProgressNode(rootElement, rsp);
            for (Map.Entry<String, DeviceResultInfo> entry : rsp.getDevRsps().entrySet()) {
                org.dom4j.Element deviceElement = this.getDeviceElement(rootElement, entry.getKey());
                this.writeDeviceNode(deviceElement, entry.getValue());
            }
            TaskProgressFileWirter.writeDataToXml(file, doc);
        }
        catch (Exception e) {
            LOGGER.error("write task response error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformDOMToStream(File file, org.w3c.dom.Document document, Transformer transform) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            transform.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Exception e) {
            LOGGER.error("outputStream is error..." + e);
        }
        finally {
            StreamUtils.closeStream((OutputStream)outputStream, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDataToXml(File file, Document document) {
        FileOutputStream fos = null;
        XMLWriter xw = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            fos = new FileOutputStream(file);
            xw = new XMLWriter((OutputStream)fos, format);
            xw.write(document);
        }
        catch (Exception e) {
            LOGGER.error("document is error..." + e);
        }
        finally {
            try {
                if (null != xw) {
                    xw.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("close xw error...", (Throwable)e);
            }
            StreamUtils.closeStream((OutputStream)fos, null);
        }
    }

    private void writeProgressNode(org.dom4j.Element element, SilenceTaskResponse rsp) {
        element.addAttribute(STATUS, rsp.getStatus());
        element.addAttribute(PROGRESS, rsp.getProgress().toString());
        element.addAttribute(UPDATE_TIME, TaskProgressFileWirter.getCurrentTime());
        element.addAttribute(RESULT, rsp.getResult());
        element.addAttribute(ERR_MSG, rsp.getErrMsg());
        Map<String, String> extras = rsp.getExtras();
        for (Map.Entry<String, String> entry : extras.entrySet()) {
            element.addAttribute(entry.getKey(), entry.getValue());
        }
    }

    private void writeDeviceNode(org.dom4j.Element element, DeviceResultInfo resultInfo) {
        element.addAttribute(SERIALNO, resultInfo.getSn());
        element.addAttribute(STATUS, resultInfo.getStatus());
        element.addAttribute(PROGRESS, resultInfo.getProgress().toString());
        element.addAttribute(UPDATE_TIME, TaskProgressFileWirter.getCurrentTime());
        element.addAttribute(RESULT, resultInfo.getResult());
        element.addAttribute(ERR_MSG, resultInfo.getErrMsg());
        element.addAttribute(BIZSTATUS, resultInfo.getBizStatus());
        element.addAttribute(OPERATION, resultInfo.getOperation());
        Map<String, String> extras = resultInfo.getExtras();
        for (Map.Entry<String, String> entry : extras.entrySet()) {
            element.addAttribute(entry.getKey(), entry.getValue());
        }
    }

    private org.dom4j.Element getDeviceElement(org.dom4j.Element rootElement, String sn) {
        List elements = rootElement.elements();
        for (org.dom4j.Element element : elements) {
            if (!sn.equals(element.attributeValue(SERIALNO))) continue;
            return element;
        }
        return rootElement.addElement(DEVICE);
    }

    private static String getCurrentTime() {
        return String.valueOf(System.currentTimeMillis());
    }
}

