/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.engine;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.tool.pyengine.engine.InstanceLocator;
import com.huawei.ism.tool.pyengine.engine.JythonExecuterLocator;
import com.huawei.ism.tool.pyengine.service.zip.PYZip;
import com.huawei.ism.tool.pyengine.utils.ErrorCodeUtils;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.python.antlr.ast.AstModule;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyJavaType;
import org.python.core.PyObject;
import org.python.core.PyObjectDerived;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;

public class JythonExecuter {
    private static final Logger LOGGER = ToolLoggerFactory.getLoggerInStandAlone("PY_LOGGER");
    private PythonInterpreter pythonInterpreter;
    private List<File> classPaths = null;

    public JythonExecuter() {
        this(new ArrayList<File>(0), null);
    }

    public JythonExecuter(PythonInterpreter interpreter) {
        this.pythonInterpreter = interpreter;
        this.setDebugMode(true);
    }

    public JythonExecuter(List<File> classPathDirs, PySystemState sys) {
        this.classPaths = classPathDirs;
        PySystemState state = sys;
        if (null == state) {
            state = new PySystemState();
            state.setClassLoader(Py.defaultSystemState.getClassLoader());
        }
        this.pythonInterpreter = new PythonInterpreter(null, state);
        state.setdefaultencoding("utf8");
        this.pythonInterpreter.set("PY_LOGGER", (Object)LOGGER);
        this.addClassPaths(classPathDirs);
        LOGGER.error("=========current py sysstate:" + this.pythonInterpreter.getSystemState().path);
        this.setDebugMode(true);
    }

    public static synchronized InstanceLocator<JythonExecuter> getNewInstanceInAsyncWay() {
        JythonExecuterLocator<JythonExecuter> locator = new JythonExecuterLocator<JythonExecuter>();
        InitInstanceTask task = new InitInstanceTask(locator);
        new Thread(task).start();
        return locator;
    }

    public JythonExecuter(File classPathDir) {
        this(Arrays.asList(classPathDir), null);
    }

    public JythonExecuter(List<File> classPathDirs) {
        this(classPathDirs, null);
    }

    public void setDebugMode(boolean debugOpen) {
        try {
            PyBoolean open = new PyBoolean(debugOpen);
            this.pythonInterpreter.exec("import os");
            this.pythonInterpreter.exec("os.pyenginedebug=" + open.toString());
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(JythonExecuter.class).error("Init python environ error.", (Throwable)e);
        }
    }

    public final synchronized void addClassPaths(List<File> classPathDirs) {
        if (null == classPathDirs || classPathDirs.isEmpty()) {
            return;
        }
        PySystemState sys = this.pythonInterpreter.getSystemState();
        for (File dir : classPathDirs) {
            if (!dir.isDirectory()) continue;
            try {
                PyString classPath = new PyString(dir.getCanonicalPath());
                if (sys.path.contains((Object)classPath)) continue;
                sys.path.insert(1, (PyObject)classPath);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("add classPath for jython : " + classPath);
            }
            catch (IOException e) {
                LOGGER.error("get dir path failed");
            }
        }
    }

    public synchronized void compileScript(File scriptFile) throws SignException, FileNotFoundException {
        String scriptPath = "";
        try {
            scriptPath = scriptFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            LOGGER.error("get Script file error!" + scriptFile.getName(), (Throwable)ioe);
            throw new FileNotFoundException("get Script file error!");
        }
        PySystemState sys = this.pythonInterpreter.getSystemState();
        if (scriptFile.exists()) {
            List jythonEnPath = PyJavaUtils.convertPyList2Jlist(sys.path);
            boolean flag = false;
            try {
                flag = SHAAndRSAVerifyUtils.getInstance().verify(scriptFile, jythonEnPath, new String[]{"py"}, true);
            }
            catch (Exception e) {
                LOGGER.error("verify Script error!" + scriptPath, (Throwable)e);
            }
            if (!flag) {
                throw new SignException();
            }
        }
        this.pythonInterpreter.set("__file__", (Object)scriptPath);
        this.pythonInterpreter.execfile(scriptPath);
    }

    public synchronized void compileScriptWithoutSign(File scriptFile) throws SignException, FileNotFoundException {
        String scriptPath = "";
        try {
            scriptPath = scriptFile.getCanonicalPath();
            this.pythonInterpreter.set("__file__", (Object)scriptPath);
            this.pythonInterpreter.execfile(scriptPath);
        }
        catch (IOException ioe) {
            LOGGER.error("get Script file error!" + scriptFile.getName(), (Throwable)ioe);
        }
        catch (Exception e) {
            LOGGER.error("verify Script error!" + scriptPath, (Throwable)e);
        }
    }

    public synchronized List<Object> invokeFunction(String name, Map<String, Object> args) throws ToolException {
        try {
            PyObject pyReturnRet = this.invoke(name, args);
            return PyJavaUtils.convertTuple2List(pyReturnRet);
        }
        catch (PyException e) {
            this.dealException(e);
            throw new ToolException(ResourceUtil.getString("error.info"), false, (Throwable)e);
        }
    }

    private PyObject invoke(String name, Map<String, Object> args) throws ToolException {
        args.put("PYENGINE.PY_ZIP", new PYZip());
        PyFunction function = (PyFunction)this.pythonInterpreter.get(name, PyFunction.class);
        PyDictionary env = PyJavaUtils.convertMap2Dict(args);
        if (null == function) {
            LOGGER.error("Invoke method error.");
            throw new ToolException(ResourceUtil.getString("error.info"));
        }
        PyObject pyReturnRet = function.__call__(new PyObject[]{env});
        Set keys = env.keySet();
        for (Object key : keys) {
            args.put(key.toString(), env.get(key));
        }
        return pyReturnRet;
    }

    public synchronized Object simpleInvokeFunction(String name, Map<String, Object> args) throws ToolException {
        try {
            PyObject pyReturnRet = this.invoke(name, args);
            return PyJavaUtils.converBaseType(pyReturnRet);
        }
        catch (PyException e) {
            this.dealException(e);
            throw new ToolException(ResourceUtil.getString("error.info"), false, (Throwable)e);
        }
    }

    public synchronized Object simpleInvokeFunction(String name, Object ... args) throws ToolException {
        try {
            PyObject pyReturnRet = this.getPyRet(name, args);
            return PyJavaUtils.converBaseType(pyReturnRet);
        }
        catch (PyException e) {
            this.dealException(e);
            throw new ToolException(ResourceUtil.getString("error.info"), false, (Throwable)e);
        }
    }

    private void dealException(PyException e) throws ToolException {
        if (e.type.equals((Object)PyType.fromClass(TLVException.class))) {
            TLVException exception = (TLVException)((PyObjectDerived)e.value).__tojava__(TLVException.class);
            throw new TLVException(this.getTlvMessage(exception, exception.getErrorId()), (Throwable)e);
        }
        if (e.type.equals((Object)PyType.fromClass(ToolException.class))) {
            ToolException exp = (ToolException)((PyObjectDerived)e.value).__tojava__(ToolException.class);
            throw new ToolException(exp.getMessage(), false, (Throwable)e);
        }
        if (e.type.equals((Object)PyType.fromClass(IsmException.class))) {
            IsmException exception = (IsmException)((PyObjectDerived)e.value).__tojava__(IsmException.class);
            throw new IsmException(this.getTlvMessage((Exception)exception, exception.getErrorId()), (Throwable)e);
        }
    }

    public synchronized List<Object> invokeFunction(String name, Object ... args) throws ToolException {
        try {
            PyObject pyReturnRet = this.getPyRet(name, args);
            return PyJavaUtils.convertTuple2List(pyReturnRet);
        }
        catch (PyException e) {
            if (e.type.equals((Object)PyType.fromClass(ToolException.class))) {
                throw (ToolException)((PyObjectDerived)e.value).__tojava__(ToolException.class);
            }
            if (e.type.equals((Object)PyType.fromClass(TLVException.class))) {
                TLVException exp = (TLVException)((PyObjectDerived)e.value).__tojava__(TLVException.class);
                throw new TLVException(this.getTlvMessage(exp, exp.getErrorId()), (Throwable)e);
            }
            if (e.type.equals((Object)PyType.fromClass(IsmException.class))) {
                IsmException exp = (IsmException)((PyObjectDerived)e.value).__tojava__(IsmException.class);
                throw new TLVException(this.getTlvMessage((Exception)exp, exp.getErrorId()), (Throwable)e);
            }
            throw new ToolException("error.info", true, (Throwable)e);
        }
    }

    private PyObject getPyRet(String name, Object ... args) throws ToolException {
        PyFunction function = (PyFunction)this.pythonInterpreter.get(name, PyFunction.class);
        if (null == function) {
            LOGGER.error("Invoke method error.");
            throw new ToolException(ResourceUtil.getString("error.info"));
        }
        PyObject[] pyArgs = null;
        if (null == args) {
            pyArgs = new PyObject[]{};
        } else {
            pyArgs = new PyObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                pyArgs[i] = PyJavaType.wrapJavaObject((Object)args[i]);
            }
        }
        PyObject pyReturnRet = function.__call__(pyArgs);
        return pyReturnRet;
    }

    public void set(String name, Object val) {
        this.pythonInterpreter.set(name, val);
    }

    private String getTlvMessage(Exception ex, long errorCode) {
        String errorCodeStr = String.valueOf(errorCode);
        if (ex instanceof TLVException) {
            TLVException exTmp = (TLVException)ex;
            String errorCodeTmp = ErrorCodeUtils.queryErrorMessage(this, exTmp.getErrorId());
            if (!errorCodeTmp.equals(errorCodeStr)) {
                return errorCodeTmp;
            }
            return exTmp.getErrorMessage();
        }
        if (ex instanceof IsmException) {
            IsmException exTmp = (IsmException)ex;
            String errorCodeTmp = ErrorCodeUtils.queryErrorMessage(this, exTmp.getErrorId());
            if (!errorCodeTmp.contains(errorCodeStr)) {
                return errorCodeTmp;
            }
            return exTmp.getErrorMessage();
        }
        return errorCodeStr;
    }

    public void cleanup() {
        if (null != this.pythonInterpreter) {
            this.pythonInterpreter.getSystemState().cleanup();
        }
    }

    public void cleanupDeeply() {
        if (null != this.pythonInterpreter) {
            try {
                this.pythonInterpreter.getSystemState().cleanup();
            }
            catch (Exception e) {
                LOGGER.error("cleansystem error happened..", (Throwable)e);
            }
        }
    }

    public List<File> getClassPaths() {
        return this.classPaths;
    }

    public void setClassPaths(List<File> classPaths) {
        this.classPaths = classPaths;
    }

    static {
        PySystemState.initialize((Properties)PySystemState.getBaseProperties(), null);
        Py.defaultSystemState.setdefaultencoding("utf8");
        AstModule.classDictInit((PyObject)new PyStringMap());
    }

    private static final class InitInstanceTask
    implements Runnable {
        private final InstanceLocator<JythonExecuter> locator;

        private InitInstanceTask(InstanceLocator<JythonExecuter> locator) {
            this.locator = locator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstanceLocator<JythonExecuter> instanceLocator = this.locator;
            synchronized (instanceLocator) {
                try {
                    LOGGER.info("init executor start...");
                    JythonExecuter instance = new JythonExecuter();
                    this.locator.setInstance(instance);
                    LOGGER.info("init executor end...");
                }
                catch (RuntimeException e) {
                    LOGGER.error("init executor error!", (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error("init executor error!", (Throwable)e);
                }
            }
        }
    }
}

