/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.psdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.pyengine.psdk.IPyTaskProxy;
import com.huawei.ism.tool.pyengine.psdk.PythonTaskService;
import com.huawei.ism.tool.pyengine.psdk.bean.CheckConfigItem;
import com.huawei.ism.tool.pyengine.psdk.bean.ExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.bean.PyTask;
import com.huawei.ism.tool.pyengine.psdk.bean.PyTaskResult;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckItemService {
    private static final Logger log = LoggerFactory.getLogger(CheckItemService.class);
    private final ExecuteEnv env;
    private final IPyTaskProxy pyTaskProxy;

    public CheckItemService(ExecuteEnv env, IPyTaskProxy pyTaskProxy) {
        this.env = env;
        this.pyTaskProxy = pyTaskProxy;
    }

    public List<CheckConfigItem> getCheckItemList(@NotNull DevNode devNode) {
        log.info("get check item list");
        PyTask pyTask = new PyTask(devNode);
        pyTask.setExecuteEnv(this.env);
        pyTask.setModulePath("psdk.checkitem.check_item_mgr");
        pyTask.setMethodName("get_check_items");
        PythonTaskService runner = new PythonTaskService(this.pyTaskProxy);
        PyTaskResult taskResult = runner.executePyScript(pyTask);
        String data = taskResult.getData();
        return this.parseConfigItems(data);
    }

    private List<CheckConfigItem> parseConfigItems(String data) {
        try {
            List ret = JSON.parseArray((String)data, CheckConfigItem.class);
            if (ret == null) {
                log.error("config item is null");
                return Collections.emptyList();
            }
            log.info("all config item: {}", ret.stream().map(CheckConfigItem::getName).collect(Collectors.toList()));
            return ret;
        }
        catch (JSONException e) {
            log.error("config item parse exception", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public PyTaskResult runCheckConfigItem(@NotNull DevNode devNode, @NotNull String itemId) {
        log.info("run check item. item id={}", (Object)itemId);
        PyTask pyTask = new PyTask(devNode);
        pyTask.setExecuteEnv(this.env);
        pyTask.setModulePath("psdk.checkitem.check_item_mgr");
        pyTask.setMethodName("execute_common_item");
        pyTask.getArgs().add(itemId);
        PythonTaskService runner = new PythonTaskService(this.pyTaskProxy);
        PyTaskResult taskResult = runner.executePyScript(pyTask);
        log.info("task result: {}", (Object)taskResult);
        return taskResult;
    }
}

