#!/bin/sh 
GRAB_VERSION="1.0.1"
set_val()
{
    eval $1=\"$2\"
}
get_val()
{
    eval echo \"'$'$1\"
}

decode()
{
    str=$1
    str=`echo "$str" | sed -e 's/\\\\\*/*/g'`
    echo "$str"
}

call_single_cmd()
{
    cmd=$1
    outputitems=$2
    echo "$cmd"
    if [ "$G_isInteractive" = "true" ];then
        write_interactive_cmd "$cmd"
        return
    fi
    
    echo call cmd "$cmd" >>${LOG_FILE} 2>&1
    echo StartCmd:"$cmd" >>${ECHO_FILE} 2>&1
    cmdkey=`echo "$cmd" | awk '{print $1}'`
    
    if [ "$cmdkey" = "cd" ];then
        # 切换目录
        eval "$cmd"  >>${LOG_FILE} 2>&1
        if [ "$?" != "0" ];then
            mkdir "$basepath"/tmp >>${LOG_FILE} 2>&1
            cd "$basepath"/tmp >>${LOG_FILE} 2>&1
        fi
        G_cmdecho=`eval "$cmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
    elif [ "$cmdkey" = "ll" ];then
        #不支持ll的系统，采用ls -l执行
        tempcmd=`echo "$cmd" | sed 's/ll/ls -l/'`
        G_cmdecho=`eval "$tempcmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
        eval "$tempcmd"  >>${LOG_FILE} 2>&1
    elif [ "$cmdkey" = "parted" ];then
        # 该命令可能超时，霿要交互时输入cancel
        G_cmdecho=`echo cancel | "$cmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
    elif [ "$cmdkey" = "/bin/ls" ];then
        #该命令输出不能加引号
        G_cmdecho=`eval "$cmd" 2>>${ECHO_FILE}`
        echo $G_cmdecho >>${ECHO_FILE} 2>&1
    elif echo "$cmd" | grep 'format';then
        G_cmdecho=`eval "$cmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
    elif [ -n "$outputitems" ];then
        #霿要用作输出，先保存至变量中，在输出文仿
        G_cmdecho=`eval "$cmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
    else
        #直接输出到文仿
        G_cmdecho=`eval "$cmd" >>${ECHO_FILE} 2>&1`
    fi
    
    if [ "$cmdkey" = "mpathadm" ];then
        echo "" >>${ECHO_FILE}
    fi
    if echo "$cmd" | grep 'qaucli'; then
        #Solaris该命令回显无换行笿
        echo "" >>${ECHO_FILE}
    fi
    count=`tail -1 ${ECHO_FILE} | wc -l` 2>>${ECHO_FILE}
    if [ "$count" = "0" ];then
        echo "">>${ECHO_FILE} 2>&1
    fi
    echo EndCmd:"$cmd" >>${ECHO_FILE} 2>&1
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
}

hpux_extra_grab()
{
    isV1V2=`uname -a |grep -E 'B\.11\.[1|2]'`
    if [ -z "$isV1V2" ];then
        return
    fi
    hwpaths=`ioscan -funC fc | awk '/^\s*fc/{print $3}'`
    for temppath in $hwpaths;do
        hwpath=`echo ${temppath} | sed 's#/#\\\/#g'`
        fcd=`ioscan -funC fc | awk 'BEGIN{tmp=0}{if (tmp==1){print $1;tmp=0}}/'${hwpath}'/{tmp=1}'`
            disks=`ioscan -funC disk | awk 'BEGIN{tmp=0}/^[^[:space:]]/{tmp=0}{if (tmp==1){for(i=1; i<=NF; i++){ print $i; }}}/'${hwpath}'/{tmp=1}' | grep /dev/dsk`
            for disk in ${disks};do
                echo disk=$disk
                call_single_cmd "pvdisplay ${disk}  | grep 'PV Name'"
            done
            echo temppath=$temppath
            wwpns=`ioscan -funC disk | grep ${temppath} | sed 's/.*'${hwpath}'\.\([0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\).*/\1/'`
            for wwpn in ${wwpns};do
                wwpn=`echo $wwpn |  awk -F '.' '{for (i=1;i<=NF;i++){printf ("%02x",$i)}}'`
                wwpn=0x$wwpn
                echo fcd=${fcd},wwpn=$wwpn >>${LOG_FILE} 2>&1
                call_single_cmd "fcmsutil ${fcd} get remote ${wwpn} | grep ' Target Port World Wide Name'"
            done
    done
}


write_interactive_cmd()
{
    cmd=$1
    #将命令写入文件中
    echo "$cmd" >>$basepath/temp_data
}

call_interactive_cmd()
{
    
    echo StartCmd:interactivecmd >>${ECHO_FILE} 2>&1
    cat $INTERACT_FILE >>${ECHO_FILE} 2>&1
    echo "####InteractiveEcho####" >>${ECHO_FILE} 2>&1
    
    
    #取文件第丿行作为交互式的命仿
    interactive_cmd=`cat $INTERACT_FILE | sed -n '1p'`
    
    #取文件剩余行作为输入
    sed -e '1d' $INTERACT_FILE >temp
    echo "$interactive_cmd"
    eval "$interactive_cmd" < temp >>${ECHO_FILE} 2>&1
    if [ "$interactive_cmd" = "qaucli" ];then
        #Solaris quacli回显无法换行
        echo "" >>${ECHO_FILE}
    fi
    echo EndCmd:interactivecmd >>${ECHO_FILE} 2>&1
    rm -f temp
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
}

get_full_cmd()
{   
    cmd=${1}
    params=${2} #目前只识别一个参敿?
    flowid=${3}
    
    for param in "${params}";do
        # 看上下文中是否存在该变量的忿
        param=`echo "$param" | sed -e 's#/#\\\/#g'`
        cmd=`echo "$cmd" | sed -e 's/%s/'"${param}"'/'`
    done
    cmd=`echo "$cmd" | sed -e 's/#/$/g'`
    echo get_full_cmd: "$cmd" >>${LOG_FILE} 2>&1
    echo "$cmd"
}

get_tag_items()
{
    rootId=$1
    parentId=$2
    tag=$3
    ret=`get_val ${rootId}_${parentId}_${tag}items | sed -e 's/#/ /g'`
    echo $ret
    
}

get_tag_obj_name()
{
    rootId=$1
    parentId=$2
    elementId=$3
    tag=$4
    echo ${rootId}_${parentId}_${elementId}_${tag}obj

}

get_output()
{
    rootId=$1
    name=$2
    get_val ${rootId}_output_${name}
}

set_output()
{
    rootId=$1
    name=$2
    value=$3
    echo "setoutput name=${rootId}_output_${name}, value=${value}" >>${LOG_FILE} 2>&1
    set_val "${rootId}_output_${name}" "${value}"
}
get_attr_val()
{   
    objname=$1
    attr=$2
    ret=`get_val ${objname}_${attr}`
    ret=`decode "$ret"`
    echo "$ret"
}

#处理output逻辑
save_output()
{
    flowid=$1
    operid=$2
    cmdecho=$3
    outputitems=`get_tag_items ${flowid} ${operid} output`
    
    if [ -n "outputitems" ];then
        for outputid in $outputitems;do
            outputobjname=`get_tag_obj_name $flowid $operid $outputid output`
            name=`get_attr_val ${outputobjname} name`
            value=`get_attr_val ${outputobjname} value`
            echo "save_output: name=${name}, value=${value}, cmdecho=${cmdecho}" >>${LOG_FILE} 2>&1
            if [ "${value}" = '#1' ];then
                value="$cmdecho"
            elif [ "$value" != "#1" ];then
                value=`echo $value |sed -e s/#1// | sed -e 's/#/$/g'`
                value='"$cmdecho"'"$value"
                value=`eval echo "$value"`
            fi
            set_output "$flowid" "$name" "$value"
        done
    fi
}

parse_operation_obj()
{
    flowid=$1
    innerflowid=$2
    operid=$3
    
    # 如果指定了next,而当前operationid不是next指定的opertionid，直接跳迿
    if [ -n "$nextoperation" ] && [ "$nextoperation" != "$operid" ];then
        echo "skip the operation:${operid}" >>${LOG_FILE} 2>&1
        return
    fi
    
    echo "operation begin====flowid=${flowid},innerflowid=${innerflowid},operid=${operid}" >>${LOG_FILE} 2>&1
    operationobjname=`get_tag_obj_name ${flowid} ${innerflowid} ${operid} operation`
    cmd=`get_attr_val ${operationobjname} cmd`
    params_var=`get_attr_val ${operationobjname} params`
    loopcmd=`get_attr_val ${operationobjname} loopcmd`
    breakWhenContains=`get_attr_val ${operationobjname} breakWhenContains`
    loop=`get_attr_val ${operationobjname} loop`
    nextoperation=`get_attr_val ${operationobjname} next`
    params=`get_output "$flowid" "$params_var"`
    outputitems=`get_tag_items ${flowid} ${operid} output`
    echo "operationobjname=${operationobjname}, cmd=${cmd}, params_var=${params_var}, params=${params}, loopcmd=${loopcmd}, loop=${loop}, nextoperation=${nextoperation}" >> "${LOG_FILE}" 2>&1
    if [ -n "$loopcmd" ];then
        #处理loopcmd逻辑
        if [ -n "$breakWhenContains" ];then
            for param in $params;do
                full_cmd=`get_full_cmd "$loopcmd" "$param" "$flowid"`
                call_single_cmd "$full_cmd" "$outputitems"
                save_output "$flowid" "$operid" "$G_cmdecho"
                if tail -10 ${ECHO_FILE} | grep -i "$breakWhenContains";then
                    break
                fi
            done
        else
            for param in $params;do
                full_cmd=`get_full_cmd "$loopcmd" "$param" "$flowid"`
                call_single_cmd "$full_cmd" "$outputitems"
                save_output "$flowid" "$operid" "$G_cmdecho" 
            done
        fi
    elif [ -n "$loop" ];then
        #处理loop逻辑
        loop_var=`echo $loop | awk '{print $1}'`
        loop_data_key=`echo $loop | awk '{print $3}'`
        loop_datas=`get_output ${flowid} ${loop_data_key}`
        
        for data in $loop_datas; do
            set_output "${flowid}" "${loop_var}" "$data"
            full_cmd=`get_full_cmd "$cmd" "$params" "$flowid"`
            call_single_cmd "$full_cmd" "$outputitems"
            save_output "$flowid" "$operid" "$G_cmdecho"
        done
        
    else
        #处理单条命令
        full_cmd=`get_full_cmd "$cmd" "$params" "$flowid"`
        call_single_cmd "$full_cmd" "$outputitems"
        save_output "$flowid" "$operid" "$G_cmdecho"
    fi
    echo "operation end" >>${LOG_FILE} 2>&1

}


#子流程不嵌入子流稿
#变量名不体现子流程ID
parse_innerflow_obj()
{
    flowid=$1
    innerflowid=$2
    # 如果指定了next,而当前innerflowid不是next指定的innerflowid，直接跳迿
    if [ -n "$nextinnerflow" ] && [ "$nextinnerflow" != "$innerflowid" ];then
        echo "skip the innerflow:${innerflowid}" >>${LOG_FILE} 2>&1
        return
    fi
    echo "innerflow begin====flowid=${flowid},innerflowid=${innerflowid}" >>${LOG_FILE} 2>&1
    innerflowobjname=`get_tag_obj_name ${flowid} ${flowid} ${innerflowid} innerflow`
    operation_items=`get_tag_items ${flowid} ${innerflowid} operation`
    loop=`get_attr_val ${innerflowobjname} loop`
    nextinnerflow=`get_attr_val ${innerflowobjname} next`
    type=`get_attr_val ${innerflowobjname} type`
    
    echo "innerflowobjname=${innerflowobjname}, loop=${loop},nextinnerflow=${nextinnerflow}, operation_items=${operation_items}" >>${LOG_FILE} 2>&1
    if [ -n "$loop" ]; then
        #处理loop逻辑
        loop_var=`echo $loop | awk '{print $1}'`
        loop_data_key=`echo $loop | awk '{print $3}'`
        loop_datas=`get_output ${flowid} ${loop_data_key}`
        
        for data in $loop_datas; do
            #针对交互式的特殊处理
            if [ "$type" = "interactive" ];then
                G_isInteractive="true"
                rm -f $INTERACT_FILE
            fi
            for operid in ${operation_items} ;do
                set_output "${flowid}" "${loop_var}" "${data}"
                parse_operation_obj "${flowid}" "${innerflowid}" "${operid}"
            done
            if [ "$type" = "interactive" ];then
                #交互式结束，执行命令
                call_interactive_cmd
                G_isInteractive="false"
                rm -f $INTERACT_FILE
            fi
        done
    else
        #针对交互式的特殊处理
        if [ "$type" = "interactive" ];then
            G_isInteractive="true"
            rm -f $INTERACT_FILE
        fi
        for operid in ${operation_items};do
            parse_operation_obj "${flowid}" "${innerflowid}" "${operid}"
        done

        if [ "$type" = "interactive" ];then
            #交互式结束，执行命令
            call_interactive_cmd
            G_isInteractive="false"
            rm -f $INTERACT_FILE
        fi
    fi
    
    echo "innerflow end" >>${LOG_FILE} 2>&1
}

Linux_adapter()
{
    deviceIP=`ifconfig -a|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d "addr:"|head -n 1`
    fileName="Linux_data.sh"
    export LC_ALL=en_US.UTF-8
}

AIX_adapter()
{
    export LC_ALL=en_US
    deviceIP=`ifconfig -a |grep 'inet ' |grep -v '127.0.0.1' |head -n 1 |awk '{print $2}'`
    fileName="AIX_data.sh"
    
}

HPUX_adapter()
{
    export LANG=en_US.utf8
    deviceIP=`netstat -nr |grep '[0-9]'|grep -v '127.0.0.1' |head -n 1 |awk '{print $1}'`
    fileName="HP-UX_data.sh"
    extra_collect="hpux_extra_grab"
    hostType="HP-UX"
}

Solaris_adapter()
{
    deviceIP=`ifconfig -a |grep 'inet ' |grep -v '127.0.0.1' |head -n 1 |awk '{print $2}'`
    fileName="Solaris_data.sh"
    extra_collect="solaris_extra_grab"
}
FusionSphere_adapter()
{
    deviceIP=`ifconfig -a|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d "addr:"|head -n 1`
    fileName="FusionSphere_data.sh"
    extra_collect=""
}

VMware_adapter()
{
    deviceIP=`esxcli network ip interface ipv4 get | sed -n '3p'|awk '{print $2}'`
    fileName="VMware_data.sh"
    extra_collect=""
}

Oracle_adapter()
{
    extra_collect=""
}



#获取主机的基本信恿
get_hostBaseInfo()
{
    dateTmp=`date "+%Y%m%d%H%M"`
    #当前脚本承在目彿
    cd `dirname $0`
    basepath=`pwd`

    hostType="UNKnown"
    fileName="Linux_data.sh"
    deviceIP=""
    cmdRet=`uname -a`
    releaseRet=`cat /etc/*release`
    if echo $cmdRet | grep -i "vmkernel"; then
        hostType="VMware"
    elif echo $cmdRet | grep -i "linux"; then
        fsVRCVer=`cat /opt/galax/version/GalaxVersion.cfg | grep -E 'V[0-9]+R[0-9]+C[0-9]+' ` >/dev/null 2>&1
        fsDigtalVer=`cat /opt/galax/version/GalaxVersion.cfg | grep -E '[0-9]+.[0-9]+.[0-9]+'` >/dev/null 2>&1
        fsOSVRCVer=`cat /etc/hostos.version | grep -E 'V[0-9]+R[0-9]+C[0-9]+' ` >/dev/null 2>&1
        fsOSDigtalVer=`cat /etc/hostos.version | grep -E '[0-9]+.[0-9]+.[0-9]+'` >/dev/null 2>&1
        if [ -n "$fsVRCVer" ];then
            hostType="FusionSphere"
        elif [ -n "$fsDigtalVer" ];then
            hostType="FusionSphere"
        elif [ -n "$fsOSVRCVer" ];then
            hostType="FusionSphere"
        elif [ -n "$fsOSDigtalVer" ];then
            hostType="FusionSphere"
        else
            hostType="Linux"
        fi
    elif echo ${releaseRet} | grep -i "solaris"; then
        hostType="Solaris"
    elif echo $cmdRet | grep -i "aix"; then
        hostType="AIX"
    elif echo $cmdRet | grep -i "hp-ux"; then
        hostType="HPUX"
    elif echo $cmdRet | grep -i "xenserver"; then
        hostType="Xenserver"
        #待实玿
        deviceIP=``
        fileName="Xenserver_data.sh"
    else
        #未知异常
        echo "Process Error:" $cmdRet
    fi
    
    
    
    if [ -n "$G_type" ];then
        if echo "$G_type" | grep -i "Oracle";then
            eval "${hostType}_adapter"
            # 重新设置主机类型
            hostType="Oracle"
            fileName="OracleDB_data.sh"
            Oracle_adapter
        else
            hostType="$G_type"
            eval "${hostType}_adapter"
        fi
    else
        eval "${hostType}_adapter"
    fi
    
    if [ -z "${deviceIP}" ]; then
        # 为空时设置默认IP
        deviceIP="not_found_ip"
    fi
    
    #主机采集项信恿
    collectCmdFilePath="$basepath/command/${fileName}"
    chmod u+x ${collectCmdFilePath}
    . ${collectCmdFilePath}

    collectFileName="${hostType}_${deviceIP}_${dateTmp}.data"
    collectLogFile="CollectLog_${deviceIP}_${dateTmp}.txt"
    ECHO_FILE=$basepath/${collectFileName}
    LOG_FILE=$basepath/${collectLogFile}
    INTERACT_FILE=$basepath/temp_data
    
    #校验用户名是否为root，如果不是root，提示用户
    username=`echo $USER`
    if [ "$username" != "" ] && [ "$username" != "root" ];then
        while :
        do
            echo "The current user is not root, some commands may fail to execute, do you continue?[Y|N]:"
            read inputVal
            if [ "$inputVal" = "Y" ] || [ "$inputVal" = "y" ]; then
                echo username=$username inputVal=$inputVal >>${LOG_FILE} 2>&1
                break
            elif [ "$inputVal" = "N" ] || [ "$inputVal" = "n" ]; then
                exit 1
            fi
        done
    fi
}

#获取主机基本信息写入文件丿
write_basicinfo()
{
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
    os=${hostType}
    ip=${deviceIP}
    echo "StartCmd:self_define_cmd_basicinfo" >>${ECHO_FILE} 2>&1
    echo "${os}" >>${ECHO_FILE} 2>&1
    echo "${ip}" >>${ECHO_FILE} 2>&1
    echo "EndCmd:self_define_cmd_basicinfo" >>${ECHO_FILE} 2>&1
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
}

write_checkinfo()
{
    echo "StartCmd:self_define_cmd_checkinfo" >>${ECHO_FILE} 2>&1
    echo "version:${GRAB_VERSION}" >>${ECHO_FILE} 2>&1
    echo "EndCmd:self_define_cmd_checkinfo" >>${ECHO_FILE} 2>&1
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
}

usage()
{
    echo "Usage:|sh main.sh [-type AIX|HP-UX|Linux|Solaris|VMware|FusionSphere|OracleDB] [-scene upgrade|migration|lite|deploy]"
    echo "|-help  |: Displays this help screen"
    echo "|-type  |: - Specify grab host information or database information."
    echo "|  |: AIX|HP-UX|Linux|Solaris|VMware|FusionSphere - Grab host information, which is not required. and the program can automatically identify the host type"
    echo "|  |: OracleDB - Grab database information, this parameter must be selected."
    echo "|-scene |: <upgrade><migration> - Specifies the scene of the grab command"
    echo "|  |: upgrade - Select 'upgrade' to grab the commands required for the upgrade"
    echo "|  |: migration - Select 'migration' to grab the commands required for the migration"
    echo "|  |: lite - Select 'lite' to grab the lite commands required for the upgrade"
	echo "|  |: deploy - Select 'deploy' to grab the deploy commands required for the deployment infograb"
}

verify()
{
    typeValide="false"
    if [ "$G_type" = "OracleDB" ] && [ "$G_scene" = "" ]; then
            G_scene="upgrade"
    fi
    for type in `echo "AIX|HP-UX|Linux|Solaris|VMware|FusionSphere|OracleDB" | sed -e 's/|/ /g'`; do
        if [ "$type" = "$G_type" ]; then
            typeValide="true"
        fi
    done
    if [ "$G_type" != "" ] && [ "$typeValide" = "false" ]; then
        echo not support type: $G_type
        usage; exit 1;
    fi
    sceneValide="false"
    for scene in `echo "upgrade|migration|lite|deploy" | sed -e 's/|/ /g'`; do
        if [ "$scene" = "$G_scene" ]; then
            sceneValide="true"
        fi
    done
    if [ "$sceneValide" = "false" ]; then
        echo not support scene: $G_scene; usage; exit 1;
    fi
}

nextinnerflow=""
nextoperation=""
G_cmdecho=""
G_isInteractive="false"
G_type=""
G_scene=""
extra_collect=""

#解析参数
para="para: ";
while [ $# -ge 1 ] ; do
        case "$1" in
                -type)  para="${para} argument $1 = $2"; G_type=$2; shift 2;;
                -scene) para="${para} argument $1 = $2"; G_scene=$2; shift 2;;
                *) usage; exit 1 ; break;;
        esac
done

umask 0027
#校验参数
verify

#获取主机的基本信恿
get_hostBaseInfo

#将基本信息写入文件中
write_basicinfo


#依次执行承有命仿
echo $para >>${LOG_FILE} 2>&1
echo "[Note] Begin to collect information."
echo "This operation will take 3 to 5 minutes, please wait..."
sceneflowitems=`get_val root_flowitems_${G_scene}`
flowitems=`echo ${sceneflowitems} | sed -e 's/#/ /g'`
for flowid in $flowitems; do
    echo "flow begin=====flowid=$flowid" >>${LOG_FILE} 2>&1
    innerflow_items=`get_tag_items "${flowid}" "${flowid}" "innerflow"`
    for innerflowid in ${innerflow_items};do
        parse_innerflow_obj "${flowid}" "${innerflowid}"
    done 
    echo "flow end" >>${LOG_FILE} 2>&1
done

# 特殊的直接鿚过脚本的方式执衿
if [ -n "$extra_collect" ];then
    eval "$extra_collect"
fi
write_checkinfo
echo "[Note] The operation succeed."
echo "(1) The infomation collection file is: "$ECHO_FILE
echo "(2) The log file is: "$LOG_FILE
