#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging
import os
import re
import sys
import tempfile

# 定义返回值
RETURN_OK = 0
RETURN_ERROR = 1

# 上电时集群主收到的IP框和sas框的too次数
SAS_TOPO_NUM = 20
IP_TOPO_NUM = 88

# 集群主处理topo的的队列深度
QUEUE_DEPTH = 1000

logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')


# 执行命令并把内容输出到文件
def exec_cmd(cmd_str, file_ath):
    exec_str = cmd_str + file_ath
    ret = os.system(exec_str)
    if ret:
        logging.warning("CHECK_FRAME_NUM: Cmd(%s) exec failed, ret %d.", exec_str, ret)
    return ret


def check_frame_number_is_ok(path):
    with open(path) as fd:
        text = fd.readlines()
        ip_frame_num = len(re.findall(r"frameType        = IpEncl", "".join(text), flags=re.S))
        sas_frame_num = len(re.findall(r"frameType        = SasEncl", "".join(text), flags=re.S))
        logging.info("CHECK_FRAME_NUM: Ip frame num(%d), sas frame num(%d).", ip_frame_num, sas_frame_num)

    return False if (sas_frame_num * SAS_TOPO_NUM + ip_frame_num * IP_TOPO_NUM) > QUEUE_DEPTH else True


def check_frame_num():
    storage_cmd = 'diagsh --attach="devm_21" --cmd="eam showframe" > '

    _fd, temp_file = tempfile.mkstemp(prefix="DEVM_check_frame_num_", text=True)
    os.close(_fd)

    if exec_cmd(storage_cmd, temp_file) != RETURN_OK:
        os.remove(temp_file)
        return False

    check_result = check_frame_number_is_ok(temp_file)
    os.remove(temp_file)

    return check_result


def main():
    try:
        if check_frame_num():
            print("True")
        else:
            print("False")
        return RETURN_OK

    except Exception as e:
        logging.exception("CHECK_FRAME_NUM: %s", e)
        print("False")
        return RETURN_ERROR


if __name__ == '__main__':
    sys.exit(main())
