#!/bin/bash
# 根据设备信号检测是否进行升级检测

TEMP_DIR=""

function vmms_check_diag()
{
diagnose --auto << EOF
vmms CheckAllVMShutoff
quit
EOF
}

trap "vmms_upd_deltmp" HUP INT QUIT TERM

function vmms_upd_check()
{
    local retryTimes=3
    local i=0
    local productNAME=`cat /proc/osp/bsp | grep -i "Model of products is" | awk -F ':' '{print $2}'`
    if [[ $productNAME == 2210_V5_* ]]; then
        echo "pass"
        return 0
    fi

    : ${TMPDIR:=/tmp}
    local saveMask=$(umask)
    umask 077
    TEMP_DIR=$(mktemp -d "${TMPDIR}/XXXXXXXXXXXXXXXXXX")
    if [ $? -ne 0 ]; then
        umask "${saveMask}"
        echo "error"
        return 1
    fi
    umask "${saveMask}"

    local resultFile="/tempfile.$$"
    local resultFilePath="$TEMP_DIR$resultFile"
    while [[ $i -lt $retryTimes ]];do
        vmms_check_diag > $resultFilePath
        passNum=`cat $resultFilePath 2>/dev/null | awk '/^pass/' | wc -l`
        if [ $passNum -eq 1 ]; then
            echo "pass"
            break
        else
            OS_echo "vmms_upd_check failed, will retry $i times."
        fi
        let i++
        sleep 1
    done
    if [ $i -eq $retryTimes ];then
        echo "error"
    fi
    rm -rf ${TEMP_DIR}
    return 0
}

function vmms_upd_deltmp()
{
    rm -rf ${TEMP_DIR}
    exit 1
}

vmms_upd_check
