#!/bin/bash

localPath="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/"
cpldreg="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/cpldreg"
secureLogTar="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/secure_curlog.tar.gz"

# BMC升级前需要检查syslog状态

# 判断文件是否为链接文件 #
function PANGEA_CheckLinkFile()
{
    INPUT_FILE=$1
    if [ -L "${INPUT_FILE}" ]; then
        OS_echo "${INPUT_FILE} is a link file."
        echo "False"
        exit 0
    fi
}

PANGEA_CheckLinkFile "${localPath}"
PANGEA_CheckLinkFile "${cpldreg}"
PANGEA_CheckLinkFile "${secureLogTar}"

# 如果文件夹不存在，则检查不通过
if [ ! -d "${localPath}" ];
then
   OS_echo "${localPath} is not exist."
   echo "False"
   exit 0
fi

# cpldreg以及secure_curlog.tar.gz文件均不存在，则检查不通过
if [ ! -f "${cpldreg}" ] && [ ! -f "${secureLogTar}" ];
then
   echo "False"
   OS_echo "${cpldreg} and ${secureLogTar} are not exist."
   exit 0
fi


G_RET_NEED_CHECK=1
G_RET_NO_NEED_CHECK=0

# 根据补丁版本判断是否进行检测判断
function PANGEA_CHECK_PATCH_LESS()
{
	local verCode=$1
	local patch_ver_max=$2
	local path_file_path="/startup_disk/image/${verCode}/hotpatch/patch_cur/patch.yml"
	if [ ! -f $path_file_path ] ;then	# 文件不存在, 非补丁，需要检测
        return ${G_RET_NEED_CHECK}
    fi
	
	local cur_patch_ver=`cat ${path_file_path} | grep patch_version | head -1 | awk '{print $(NF)}'`
	if [ -z $cur_patch_ver ] ;then	# 匹配失败，环境存在问题不需要检测
        return ${G_RET_NO_NEED_CHECK}
    fi
	# 需要解析SPHabcd版本号到具体数字abcd避免字符串存在问题
	if [ `expr substr $cur_patch_ver 4 5 \< substr $patch_ver_max 4 5` -eq 1 ] ;then
		return ${G_RET_NEED_CHECK}
	fi
	return ${G_RET_NO_NEED_CHECK}
}

# 根据版本判断是否进行检测判断
function PANGEA_NEED_CHECK()
{
	local manifest_file_path=/startup_disk/image/pkg_cur/manifest.yml
		if [ ! -f $path_file_path ] ;then	# 文件不存在
        return ${G_RET_NO_NEED_CHECK}
    fi
	
	local MainVer=`cat ${manifest_file_path}  | grep -w SpcVersion | awk '{print $(NF)}'`
	local VerCode=`cat ${manifest_file_path}  | grep -w Version | awk '{print $(NF)}'`
	
    if [ "$MainVer" == "V500R007C60SPC100" ] ;then	# V500R007C60SPC100 需要检测
        return ${G_RET_NEED_CHECK}
    fi
	
    if [ "$MainVer" == "V500R007C60SPC300" ] ;then	# V500R007C60SPC300 补丁版本小于SPH309需要检测
		PANGEA_CHECK_PATCH_LESS ${VerCode} "SPH309"
		if [ "$?" == ${G_RET_NEED_CHECK} ] ;then
			return ${G_RET_NEED_CHECK}
        fi
    fi
		
    OS_echo "${MainVer} no need check"
    return ${G_RET_NO_NEED_CHECK}	# 文件找不到或则不匹配
}

# 如果不需要检测直接退出
PANGEA_NEED_CHECK 
if [ "$?" == ${G_RET_NO_NEED_CHECK} ] ;then
	echo "True"
	exit 0
 fi
	
# 判断cpldreg以及secure_curlog.tar.gz文件最近一次的更新时间，如果两者其中之一文件的最近更新时间与当前系统时间相差1小时以上，则检查不通过
function PANGEA_CompileTimestamp()
{
    INPUT_FILE=$1
    if [ -f "$INPUT_FILE" ];then
        LAST_MODIFY_TIMESTAMP=`stat -c %Y $INPUT_FILE`
        current=`date "+%Y-%m-%d %H:%M:%S"`
        SYSTEM_CURRENT_TIMESTAMP=`date -d "$current" +%s`
        time=`expr $SYSTEM_CURRENT_TIMESTAMP - $LAST_MODIFY_TIMESTAMP`
        if [ $time -gt 3600 ];then
            echo "False"
            exit 0
        fi
    fi
}

PANGEA_CompileTimestamp "${cpldreg}"
PANGEA_CompileTimestamp "${secureLogTar}"

echo "True"
exit 0
