#!/bin/bash
G_RET_SUCC=0
G_RET_FAIL=1
G_RET_NO_MATCH=2
G_VERSION_NO_LOG=0
localPath="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/app_curlog.tar.gz"
hisPath="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/app_debug_log.tar.gz"

function PANGEA_CHECK_CONTROLLER_SN(){
    local L_RET=0
    local L_TempFile="bmcflashchecksn"
    local SN=""
    local CMD="mpa bmc getelable 200 0"
    cat /proc/osp/bsp 2>/dev/null | grep -E "PANGEA_V6R3C30_HI1620S_1P_2U2C_SAS|PANGEA_V6R3C30_HI1620S_1P1L_2U2C_SAS|PANGEA_V6R3C30_HI1620S_1P1H_2U2C_SAS" >/dev/null 2>&1
    if [[ $? = 0 ]]; then
        local CMD_ATT="attach 12"
    else
        local CMD_ATT="attach 21"
    fi
(
diagnose_usr --auto <<EOF
${CMD_ATT}
${CMD}
exit
EOF
) > ${L_TempFile}
    SN=`grep BarCode "${L_TempFile}" | head -1 | awk -F "=" '{print $2}'`
    rm ${L_TempFile}

    cur_folder=$(readlink -f "$(dirname "$0")")
    list=`cat ${cur_folder}/checkbmcflashrisk_sn_mid_low.txt`
    for val in $list
    do
        if [[ ${list[@]} =~ $SN ]]; then
            OS_echo "[MID_LOW]bmc flash SN check fail, return ${G_RET_FAIL}."
            return ${G_RET_FAIL}
        fi
    done
    OS_echo "[MID_LOW]bmc flash SN check OK, return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_PATCH_601()
{
    local CMD="ver show 3"
    local L_TempFile="bmcflashcheckpatch601"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    local finalVer=`echo $VER | awk -F "H" '{print $2}'`
    if [[ 10#$finalVer -lt 15 ]] || [[ "$VER" == "--" ]]; then
        OS_echo "[MID_LOW]bmc flash version 601 check fail, return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
    OS_echo "[MID_LOW]bmc flash version 601 check OK, return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_PATCH_610()
{
    local CMD="ver show 3"
    local L_TempFile="bmcflashcheckpatch610"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    local finalVer=`echo $VER | awk -F "H" '{print $2}'`
    if [[ 10#$finalVer -lt 7 ]] || [[ "$VER" == "--" ]]; then
        OS_echo "[MID_LOW]bmc flash version 610 check fail, return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
    OS_echo "[MID_LOW]bmc flash version 610 check OK, return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_PATCH_C60()
{
    local CMD="ver show 3"
    local L_TempFile="bmcflashcheckpatchC60"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    local finalVer=`echo $VER | awk -F "H" '{print $2}'`
    if [[ 10#$finalVer -lt 312 ]] || [[ "$VER" == "--" ]]; then
        OS_echo "[MID_LOW]bmc flash version C60 check fail, return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
    OS_echo "[MID_LOW]bmc flash version C60 check OK, return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_PATCH_C71()
{
    local CMD="ver show 3"
    local L_TempFile="bmcflashcheckpatchC71"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    local finalVer=`echo $VER | awk -F "H" '{print $2}'`
    if [[ 10#$finalVer -lt 105 ]] || [[ "$VER" == "--" ]]; then
        OS_echo "[MID_LOW]bmc flash version C71 check fail, return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
    OS_echo "[MID_LOW]bmc flash version C71 check OK, return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

#获取阵列版本
function PANGEA_CHECK_PRODUCT_VER()
{
    local CMD="ver show 1"
    local L_RET=0
    local L_TempFile="bmcflashcheckver"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    if [[ "$VER" == "6.0.1" ]] ;then
        PANGEA_CHECK_PATCH_601
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            return ${G_RET_SUCC}
        else
            return ${G_RET_FAIL}
        fi
    fi

    if [[ "$VER" == "6.1.0" ]] ;then
        PANGEA_CHECK_PATCH_610
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            return ${G_RET_SUCC}
        else
            G_VERSION_NO_LOG=1
            return ${G_RET_FAIL}
        fi
    fi

    if [[ "$VER" == "V500R007C60SPC300" ]] ;then
        PANGEA_CHECK_PATCH_C60
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            return ${G_RET_SUCC}
        else
            return ${G_RET_FAIL}
        fi
    fi

    if [[ "$VER" == "V500R007C71SPC100" ]] ;then
        PANGEA_CHECK_PATCH_C71
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            G_VERSION_NO_LOG=1
            return ${G_RET_SUCC}
        else
            return ${G_RET_FAIL}
        fi
    fi
    OS_echo "[MID_LOW]bmc flash version check is dismatch, return ${G_RET_FAIL}."
    return ${G_RET_FAIL}
}

function PANGEA_CHECK_GET_BMC_LOG(){
    local L_TempFile="bmcflashgetlog"
    local CMD="mpa bmc getlog 200 0"
    cat /proc/osp/bsp 2>/dev/null | grep -E "PANGEA_V6R3C30_HI1620S_1P_2U2C_SAS|PANGEA_V6R3C30_HI1620S_1P1L_2U2C_SAS|PANGEA_V6R3C30_HI1620S_1P1H_2U2C_SAS" >/dev/null 2>&1
    if [[ $? = 0 ]]; then
        local CMD_ATT="attach 12"
    else
        local CMD_ATT="attach 21"
    fi
(
diagnose_usr --auto <<EOF
${CMD_ATT}
${CMD}
exit
EOF
) > ${L_TempFile}

    rm ${L_TempFile}
}

function PANGEA_CALC_BKOCK_RESULT()
{
    resblock=$1
    badblock=$2
    totalblock=$((10#$resblock+10#$badblock))
    allowbad=$((10#$totalblock*7))
    badtotal=$((10#$badblock*10))
    OS_echo "[MID_LOW]bmc flash badblock is $badtotal and allowed block is $allowbad."
    #允许的坏块为总坏块的0.7，这里总数扩大7倍，坏块扩大10倍进行比较
    if [[ $allowbad -ge $badtotal ]]; then
        OS_echo "[MID_LOW]bmc flash bad block check OK, return ${G_RET_SUCC}."
        return ${G_RET_SUCC}
    else
        OS_echo "[MID_LOW]bmc flash bad block check fail, return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
}

function PANAGEA_CHECK_TEST_LOG()
{
    local ret=
    testpath=$1
    for ((i=0;i<5;i++));
    do
        gzip --test $testpath >/dev/null 2>&1
        ret=$?
        if [ $ret == 0 ]; then
            OS_echo "[MID_LOW]bmc flash gzip test log OK."
            return ${G_RET_SUCC}
        fi
        #日志正在被操作时，需要等待
        OS_echo "[MID_LOW]bmc flash gzip test log error for times $i, ret is $ret, sleep 2s."
        sleep 2s
    done
    return ${G_RET_FAIL}
}

function PANAGEA_CHECK_FLASH_BLOCK()
{
    local targetDir="/OSM/log/pangea/bmctmp"
    local curFile="/OSM/log/pangea/bmctmp/var/log/pme/app_debug_log"
    local hisFile="/OSM/log/pangea/bmctmp/md_so_app_debug_log"
    local pattern='Nandflash healthreport infomation: avg-earsed-count=([0-9]+), resvd-block=([0-9]+), bad-block=([0-9]+).'

    rm -rf $targetDir >/dev/null 2>&1
    mkdir $targetDir >/dev/null 2>&1
    #判断日志的完整性
    OS_echo "[MID_LOW]bmc flash check current log begin."
    PANAGEA_CHECK_TEST_LOG $localPath
    L_RET=$?
    if [ "${L_RET}" != 0 ] ;then
        OS_echo "[MID_LOW]bmc flash curlog test error, return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi

    #解压日志
    tar xzvf $localPath -C $targetDir >/dev/null 2>&1
    L_RET=$?
    if [ "${L_RET}" != 0 ] ;then
        #日志解压失败，重试
        OS_echo "[MID_LOW]bmc flash curlog unzip error, sleep 2s, try again."
        sleep 2s
        tar xzvf $localPath -C $targetDir >/dev/null 2>&1
    fi
    #匹配日志
    target=`cat $curFile | grep -a "bad-block" | tail -1`
    if [[ $target =~ $pattern ]]; then
        PANGEA_CALC_BKOCK_RESULT ${BASH_REMATCH[2]} ${BASH_REMATCH[3]}
        return $?
    fi

    #判断日志的完整性
    OS_echo "[MID_LOW]bmc flash check history log begin."
    PANAGEA_CHECK_TEST_LOG $hisPath
    L_RET=$?
    if [ "${L_RET}" != 0 ] ;then
        OS_echo "[MID_LOW]bmc flash hislog test error, return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi

    #解压日志
    tar xzvf $hisPath -C $targetDir >/dev/null 2>&1
    L_RET=$?
    if [ "${L_RET}" != 0 ] ;then
        #日志解压失败，重试
        OS_echo "[MID_LOW]bmc flash hislog unzip error, sleep 2s, try again."
        sleep 2s
        tar xzvf $hisPath -C $targetDir >/dev/null 2>&1
    fi
    #匹配日志
    target=`cat $hisFile | grep -a "bad-block" | tail -1`
    if [[ $target =~ $pattern ]]; then
        PANGEA_CALC_BKOCK_RESULT ${BASH_REMATCH[2]} ${BASH_REMATCH[3]}
        return $?
    fi
    rm -rf $targetDir >/dev/null 2>&1
    OS_echo "[MID_LOW]bmc flash product bad block log is dismatch, return ${G_RET_NO_MATCH}."
    return ${G_RET_NO_MATCH}
}

function PANGEA_FLASH_STAT_LOG()
{
    MODIFY_TIMESTAMP=
    for ((i=0;i<5;i++));
    do
        MODIFY_TIMESTAMP=`stat -c %Y $localPath`
        if [[ $MODIFY_TIMESTAMP != "" ]]; then
            return ${G_RET_SUCC}
        fi
        OS_echo "[MID_LOW]bmc flash stat log error for times $i, sleep 2s."
        sleep 2s
    done
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_KILL_BMC_BOARD_AND_GET_LOG()
{
    local CUR_MODIFY_TIMESTAMP=
    local LAST_MODIFY_TIMESTAMP=

    if [ $G_VERSION_NO_LOG == 1 ]; then
        echo -e "killall board\n" | ip vrf exec vrf-inner ssh -q -o StrictHostKeyChecking=no root@192.168.0.2 >/dev/null 2>&1
        OS_echo "[MID_LOW]bmc flash kill bmc board."
        OS_echo "[MID_LOW]bmc flash log donot need check on this version."
        return ${G_RET_FAIL}
    fi

    #1)首先记录当前日志的修改时间，异常重试1次，失败返回
    PANGEA_FLASH_STAT_LOG
    LAST_MODIFY_TIMESTAMP=$MODIFY_TIMESTAMP
    if [[ $LAST_MODIFY_TIMESTAMP == "" ]]; then
        OS_echo "[MID_LOW]bmc flash stat old log error, timestamp is ${LAST_MODIFY_TIMESTAMP}."
        return ${G_RET_FAIL}
    fi

    #2)重启BMC board模块
    echo -e "killall board\n" | ip vrf exec vrf-inner ssh -q -o StrictHostKeyChecking=no root@192.168.0.2 >/dev/null 2>&1
    OS_echo "[MID_LOW]bmc flash kill bmc board."

    #3)再次收集日志
    sleep 1m
    PANGEA_CHECK_GET_BMC_LOG

    #4-1)记录最新日志的变化时间，异常重试1次，失败返回
    PANGEA_FLASH_STAT_LOG
    CUR_MODIFY_TIMESTAMP=$MODIFY_TIMESTAMP
    if [[ $CUR_MODIFY_TIMESTAMP == "" ]]; then
        OS_echo "[MID_LOW]bmc flash stat new log error, timestamp is ${CUR_MODIFY_TIMESTAMP}."
        return ${G_RET_FAIL}
    fi

    #4-2)日志未刷新重试
    if [[ $LAST_MODIFY_TIMESTAMP == $CUR_MODIFY_TIMESTAMP ]]; then
        OS_echo "[MID_LOW]bmc flash product log is not changed, try again, sleep 30s."
        sleep 30s
        PANGEA_CHECK_GET_BMC_LOG
        PANGEA_FLASH_STAT_LOG
        CUR_MODIFY_TIMESTAMP=$MODIFY_TIMESTAMP
        if [[ $CUR_MODIFY_TIMESTAMP == "" ]]; then
            OS_echo "[MID_LOW]bmc flash stat new log error again, timestamp is ${CUR_MODIFY_TIMESTAMP}."
            return ${G_RET_FAIL}
        fi
        if [[ $LAST_MODIFY_TIMESTAMP == $CUR_MODIFY_TIMESTAMP ]]; then
            OS_echo "[MID_LOW]bmc flash product log is not changed again, return ${G_RET_FAIL}."
            return ${G_RET_FAIL}
        fi
    fi
    OS_echo "[MID_LOW]bmc flash product log has changed."

    #4-3)解压日志并解析日志关键词
    PANAGEA_CHECK_FLASH_BLOCK
    L_RET=$?
    if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
        return ${G_RET_SUCC}
    else
        if [ "${L_RET}" == "${G_RET_NO_MATCH}" ] ;then
            OS_echo "[MID_LOW]bmc flash product log is dismatch for first time."
            sleep 30s
            PANGEA_CHECK_GET_BMC_LOG
            PANAGEA_CHECK_FLASH_BLOCK
            L_RET=$?
            if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
                return ${G_RET_SUCC}
            fi
        fi
    fi
    return ${G_RET_FAIL}
}

PANGEA_CHECK_CONTROLLER_SN
ret=$?
if [ "${ret}" == "${G_RET_SUCC}" ] ;then
    echo "True"
    exit 0
fi

PANGEA_CHECK_PRODUCT_VER
ret=$?
if [ "${ret}" == "${G_RET_SUCC}" ] ;then
    echo "True"
else
    #检查不通过，重启BMC的board模块并解析日志
    PANGEA_CHECK_KILL_BMC_BOARD_AND_GET_LOG
    ret=$?
    if [ "${ret}" == "${G_RET_SUCC}" ] ;then
        echo "True"
        exit 0
    fi
    echo "False"
fi
exit 0
