#!/bin/bash
G_RET_SUCC=0
G_RET_FAIL=1

# 判断补丁版本是否为对应版本
function PANGEA_CHECK_PATCH_VER()
{
    local verCode=$1
    local patch_check_ver=$2
    local path_file_path="/startup_disk/image/${verCode}/hotpatch/patch_cur/patch.yml"
    # 没有此补丁配置文件，没安装此补丁
    if [ ! -f $path_file_path ] ;then
        return ${G_RET_SUCC}
    fi

    local cur_patch_ver=`cat ${path_file_path} | grep patch_version | head -1 | awk '{print $(NF)}'`
    if [ -z $cur_patch_ver ] ;then
        return ${G_RET_SUCC}
    fi
    # 需要解析SPHabcd版本号到具体数字abcd避免字符串存在问题
    if [ `expr substr $cur_patch_ver 4 5 == substr $patch_check_ver 4 5` -eq 1 ] ;then
        return ${G_RET_FAIL}
    fi
    return ${G_RET_SUCC}
}

# 根据版本判断是否进行检测判断
function PANGEA_NEED_CHECK()
{
    local manifest_file_path=/startup_disk/image/pkg_cur/manifest.yml
    local L_RET=0
    if [ ! -f $path_file_path ] ;then # 文件不存在
        return ${G_RET_SUCC}
    fi

    local VerCode=`cat ${manifest_file_path}  | grep -w Version | awk '{print $(NF)}'`
    # 6200819073对应V500R007C73SPC100，此版本需要检测
    if [ "$VerCode" == "6200819073" ] ;then
        PANGEA_CHECK_PATCH_VER ${VerCode} "SPH116"
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            return ${G_RET_SUCC}
        else
            return ${G_RET_FAIL}
        fi
    fi
    OS_echo "${VerCode} no need check"
    return ${G_RET_SUCC}
}
 
# 如果不需要检测直接退出
PANGEA_NEED_CHECK 
if [ "$?" == ${G_RET_SUCC} ] ;then
    echo "True"
    exit 0
else
    #检查不通过
    echo "False"
    exit 0
fi

