#!/usr/bin/python
# -*- coding: utf-8 -*-

import logging
import os
import yaml

CUR_MANIFEST_PATH = '/OSM/conf/manifest.yml'
IMAGE_DISK = '/startup_disk/image'
PATCH_MANIFEST = 'patch.yml'

log = logging.getLogger("check_func")
formatter = logging.Formatter(fmt="[%(asctime)s][%(levelname)s][%(message)s]"
                                  "[%(filename)s, %(lineno)d]",
                              datefmt="%b %d %Y %H:%M:%S")
file_handler = logging.FileHandler(filename="/OSM/log/cur_debug/messages")
file_handler.setFormatter(formatter)
log.addHandler(file_handler)
log.setLevel(logging.INFO)
log.propagate = False


def get_cur_sys_version():
    if not os.path.exists(CUR_MANIFEST_PATH):
        log.info("CHECK_FUNC: can not get the src version, %s does"
                 " not exist." % CUR_MANIFEST_PATH)
        return "", "", ""
    with open(CUR_MANIFEST_PATH) as fd:
        cfg_yml = yaml.safe_load(fd)
        try:
            target_version = str(cfg_yml.get("SYS")["Version"])
            target_spc_version = str(cfg_yml.get("SYS")["SpcVersion"])
            target_apollo_version = str(cfg_yml.get("ApolloVersion", ''))
            return target_version, target_spc_version, target_apollo_version
        except Exception:
            log.exception("CHECK_FUNC: Failed to get version.")
            return "", "", ""


def get_patch_version(conf_file):
    """

    :param conf_file:补丁配置文件
    :return:
    """
    if not os.path.exists(conf_file):
        return ""
    fd = open(conf_file)
    patch_conf = yaml.safe_load(fd)
    fd.close()
    ver_conf = patch_conf.get("PatchConf", None)
    if not ver_conf:
        return ""
    return ver_conf.get('patch_version', "")


def get_hotpatch_version():
    """
    :return:
    """
    version = get_cur_sys_version()[0]
    cur_patch_path = os.path.join(IMAGE_DISK, str(version),
                                  'hotpatch/patch_cur/', PATCH_MANIFEST)
    cur_sph = get_patch_version(cur_patch_path)
    bak_patch_path = os.path.join(IMAGE_DISK, str(version),
                                  'hotpatch/patch_bak', PATCH_MANIFEST)
    bak_sph = get_patch_version(bak_patch_path)
    return cur_sph, bak_sph


def check_sys_and_hotpatch_version(resolve_patch):
    """
    :param resolve_patch:
    :return:
    """
    sys_version = get_cur_sys_version()[0]
    hotpatch_version = get_hotpatch_version()[0]
    if not hotpatch_version or not sys_version:
        return False
    if sys_version in resolve_patch:
        hotpatch_version_num = int(filter(lambda ch: ch in '0123456789',
                                          hotpatch_version))
        resolve_hotpatch_version_num = int(filter(lambda ch: ch in '0123456789',
                                                  resolve_patch[sys_version]))
        if hotpatch_version_num >= resolve_hotpatch_version_num:
            log.info("CHECK_FUNC: The %s has been installed.", hotpatch_version)
            return True
    return False
