#!/bin/bash
# 检查当前环境中是否存在SAS链路错误组网异常, 用于升级前提前拦截错误并完成整改;
# 避免升级后被线缆检测新策略直接生效, 错误拦截盘框接入.
# 先检查是否为V6新硬件, 如果不是, 不需要检查, 默认返回TRUE.

function eam_exec_diagu(){
    cat /proc/osp/bsp 2>/dev/null | grep -E "PANGEA_V6R3C30_HI1620S_1P_2U2C_SAS|PANGEA_V6R3C30_HI1620S_1P1L_2U2C_SAS|PANGEA_V6R3C30_HI1620S_1P1H_2U2C_SAS" >/dev/null 2>&1
    if [[ $? = 0 ]]; then
        local CMD_ATT="12"
    else
        local CMD_ATT="21"
    fi
diagnose_usr --auto <<EOF
attach ${CMD_ATT}
$*
exit
EOF
}

function eam_cable_check()
{
    : ${TMPDIR:=/tmp}
    local temp_dir=""
    local save_mask=$(umask)
    umask 077
    temp_dir=$(mktemp -d "${TMPDIR}/XXXXXXXXXXXXXXXXXX") 
    if [ $? -ne 0 ]
    then
        umask "${save_mask}"
        return 1
    fi
    umask "${save_mask}"
    
    hard_ware_v6=`cat /proc/osp/bsp | grep PANGEA_V6 | wc -l`
    if [ $hard_ware_v6 -eq 0 ] ; then
        result="TRUE"
    else
        local result_file="/tempfile.$$"
        local result_file_path="$temp_dir$result_file"
        eam_exec_diagu "eam showcablecheck" > "$result_file_path"
        error_link_num=`cat $result_file_path | awk '/^Err Link/' | wc -l`
        error_link_num_old=`cat $result_file_path | awk '$1==1' | wc -l`
        if [ $error_link_num -ne 0 ] || [ $error_link_num_old -ne 0 ] ; then
            result="False"
        else
            result="TRUE"
        fi
    fi
    
    echo $result
    
    rm -f $result_file_path
    trap '[ -n "${temp_dir}" ] && rm -rf "${temp_dir}"' EXIT
}

eam_cable_check
