#!/bin/bash
# BMC主从切换

function bmc_master_slave_check()
{
    # 查看当前设备的控制器丝印，只处理A\B控，C\D控直接返回pass，不做切换
    ret=`ipmitool raw 0x32 0xb4 0x00 0x02 0x00 0x00 0x70`
    if [ "$?" == 0 ];then
        ret=`echo $ret | sed s/[[:space:]]//g`
        if [ "$ret" == "01" ] || [ "$ret" == "00" ];then
            # 检查本控是否为主控，若为主控，直接返回
            result=`ipmitool raw 0x32 0x1d 0x01 0x02 0x00 0x00 0x00`
            result=`echo $result | sed s/[[:space:]]//g`
            if [ "$result" == "01" ]; then
                OS_echo "This board is master already"
                return 0
            else
                # B控延时5s
                if [ "$ret" == "01" ];then
                    sleep 5
                fi
                for ((i=0;i<3;i++))
                do
                    OS_echo "Change to master"
                    ret=`ipmitool raw 0x32 0x1c 0x00 0x02 0x00 0x00 0x00 0x01`
                    if [ "$?" == 0 ];then
                        ret=`ipmitool raw 0x32 0x1d 0x00 0x02 0x00 0x00 0x00`
                        ret=`echo $ret | sed s/[[:space:]]//g`
                        if [ "$ret" == "01" ];then
                            OS_echo "Change to master success"
                            return 0
                        fi
                    fi
                    # 失败后延时2s
                    sleep 2
                done

                OS_echo "Change to master failed"
                return 1
            fi
        else
            OS_echo "This board is C/D, return ok"
            return 0
        fi
    fi
}

OS_echo "Start to check bmc master"
bmc_master_slave_check
if [ $? -ne 0 ]; then
	echo "False"
	exit 0
fi
OS_echo "End of checking bmc master"
echo "True"
exit 0
