#!/bin/bash

Power_Output="power_output"


function PSU_echo()
{
    local loop=0
    while ((${loop}<10)); do
        if [ -S "/dev/log" ]; then
            OS_echo "$1"
            # echo "$1"
            break
        fi
        sleep 1
        let loop+=1
    done
}

# MPA命令执行 用户态及attach 21
function MPA_BMC_CMD_OUTPUT()
{
    local CMD_EXEC=$1
(
diagnose_usr --auto <<EOF
attach 21
${CMD_EXEC}
exit
EOF
) > ${Power_Output}
}

function Check_Upgrade_For_Risk_PSU()
{
    local PSU_PAC2000S12_BG="50 41 43 32 30 30 30 53 31 32 2d 42 47" # 电源型号
    local PSU_02312HGY="30 32 33 31 32 48 47 59" # 电源编码
    local frameType=""
    local retCode=0

    frameTyp=$(grep -i "Product Name" /proc/osp/bsp |awk -F "is" '{print $2}')
    if [[ "${frameType}" =~ "HI1620_4U4C" ]]; then
        PSU_echo "[PangeaPowerUpdateCheck]Device is HI1620_4U4C"
        return 1 # 高端控制框需要检查升级文件
    fi
    
    for fruID in {0,1}; do
        psu_model=$(sudo ipmitool raw 0x32 0x2c ${fruID} 0x20 0 0 0 2>&1)
        psu_model=${psu_model:1:38} # 截取电源型号
        PSU_echo "[PangeaPowerUpdateCheck]psu_model PSU${fruID}: ${psu_model}"
        if [[ "x${psu_model}" != "x${PSU_PAC2000S12_BG}" ]]; then
            continue
        fi
        psu_code=$(sudo ipmitool raw 0x32 0xbb ${fruID} 0x10 0 0 0x59 2>&1)
        psu_code=${psu_code:1:23}
        PSU_echo "[PangeaPowerUpdateCheck]psu_info PSU${fruID}:${psu_code}"
        if [[ "x${psu_code}" != "x${PSU_02312HGY}" ]]; then
            continue
        fi
        MPA_BMC_CMD_OUTPUT "mpa bmc getpowerversion 100${fruID} 1"
        psu_version=$(grep "Power Software Version" "${Power_Output}" |awk -F ":" '{print $2}')
        PSU_echo "[PangeaPowerUpdateCheck]psu_version PSU${fruID}:${psu_version}"
        if [[ "x${psu_version}" == "x111" ]] || [[ "x${psu_version}" == "x113" ]] || \
           [[ "x${psu_version}" == "x115" ]] || [[ "x${psu_version}" == "x119" ]]; then
            retCode=1
        fi
    done
    rm -f ${Power_Output}
    
    return ${retCode}
}

function Get_Local_Host_Id()
{
(
swm_diagnose --auto <<EOF
host show
exit
EOF
) > ${Power_Output}

    local host_id=""
    local retCode=0

    host_id=$(grep "Local host id is:" "${Power_Output}" |awk -F "is: " '{print $2}')
    if [ "x${host_id}" != "x0" ]; then
        retCode=1
    fi
    PSU_echo "[PangeaPowerUpdateCheck] Local host id is: ${host_id}"
    rm -f ${Power_Output}
    return ${retCode}
}

function Close_Power_Process()
{
    local result=""

    # 获取host id, 非0A节点退出
    local host_id=0
    Get_Local_Host_Id
    host_id=$?
    if [ "x${host_id}" != "x0" ]; then
        return
    fi
    # 关闭守护进程
    /OSM/script/eam.sh psu_upgrade_daemon_process off >/dev/null 2>&1
    PSU_echo "[PangeaPowerUpdateCheck] close psu_upgrade_daemon_process."

    # 关闭管理进程
    result=$(ps -ef |grep power_update_tool_manage.py |grep -v "grep")
    if [ "x${result}" != "x" ]; then # 进程存在
        ps -ef | grep power_update_tool_manage.py | grep -v "grep" | awk -F " " '{print $2}'| xargs kill -9 >/dev/null 2>&1
        PSU_echo "[PangeaPowerUpdateCheck] close power_update_tool_manage.py."
    fi
    return
}

function PSU_Upgrade_Check_Main()
{
    local retCode=0

    # 1.检查电源升级补丁存在
    if [ ! -f "/OSM/script/power_update_daemon_process.sh" ]; then
        return 0
    fi
    # 2.检查风险电源升级完成
    Check_Upgrade_For_Risk_PSU
    retCode=$?
    if [[ ${retCode} -eq 0 ]]; then # 相等
        return 0
    fi
    # 3.0A节点关闭进程
    Close_Power_Process
    # 4.创建临时禁止升级文件
    local filePath="/tmp"
    if [ -f "/home/ibc_os_hs/power_upgrade_conf_data" ]; then
        filePath="/home/ibc_os_hs"
    fi
    echo "power_upgrade_prohibit_temp" >"${filePath}/power_upgrade_prohibit_temp"
    PSU_echo "[PangeaPowerUpdateCheck] create file: ${filePath}/power_upgrade_prohibit_temp."

    if [ -f "${filePath}/power_upgrade_start" ]; then
        sudo rm -f "${filePath}/power_upgrade_start"
        PSU_echo "[PangeaPowerUpdateCheck] delete file: ${filePath}/power_upgrade_start."
    fi
    # 5.查询电源升级进程
    local loop=0
    local result=""
    retCode=1
    while ((${loop}<9)); do
        result=$(ps -ef | grep power_update_tool_upgrade.py | grep -v "grep")
        if [ "x${result}" == "x" ]; then # 进程不存在
            PSU_echo "[PangeaPowerUpdateCheck] close process: power_update_tool_upgrade.py."
            retCode=0
            break
        fi
        sleep 30
        let loop+=1
    done
    # 6.删除临时禁止升级文件
    if [ -f "${filePath}/power_upgrade_prohibit_temp" ]; then
        sudo rm -f "${filePath}/power_upgrade_prohibit_temp"
        PSU_echo "[PangeaPowerUpdateCheck] delete file: ${filePath}/power_upgrade_prohibit_temp."
    fi
    # 7.0A恢复电源守护进程
    if [[ ${retCode} -eq 1 ]]; then # 存在电源升级进程
        local host_id=0
        Get_Local_Host_Id
        host_id=$?
        if [ "x${host_id}" == "x0" ]; then
            /OSM/script/eam.sh psu_upgrade_daemon_process on >/dev/null 2>&1
            PSU_echo "[PangeaPowerUpdateCheck] start process: psu_upgrade_daemon_process."
        fi
    fi
    return ${retCode}
}

PSU_Upgrade_Check_Main
retCheck=$?
if [ "${retCheck}" == "0" ]; then
    echo "True"
else
    echo "False"
fi
exit 0

