#!/bin/bash

Power_Output="power_output"


function PSU_echo()
{
    local loop=0
    while ((${loop}<10)); do
        if [ -S "/dev/log" ]; then
            OS_echo "$1"
            # echo "$1"
            break
        fi
        sleep 1
        let loop+=1
    done
}

# MPA命令执行 用户态及attach 21
function MPA_BMC_CMD_OUTPUT()
{
    local CMD_EXEC=$1
(
diagnose_usr --auto <<EOF
attach 21
${CMD_EXEC}
exit
EOF
) > ${Power_Output}
}

function Check_Upgrade_For_Risk_PSU()
{
    local PSU_PAC2000S12_BG="50 41 43 32 30 30 30 53 31 32 2d 42 47" # 电源型号
    local PSU_02312HGY="30 32 33 31 32 48 47 59" # 电源编码
    local frameType=""
    local retCode=0

    frameType=$(grep -i "Product Name" /proc/osp/bsp |awk -F "is" '{print $2}')
    if [[ "${frameType}" =~ "HI1620_4U4C" ]]; then
        PSU_echo "[PangeaPowerUpdateCheck]Device is HI1620_4U4C"
        return 1 # 高端控制框需要检查升级文件
    fi
    
    for fruID in {0,1}; do
        psu_model=$(sudo ipmitool raw 0x32 0x2c ${fruID} 0x20 0 0 0 2>&1)
        psu_model=${psu_model:1:38} # 截取电源型号
        PSU_echo "[PangeaPowerUpdateCheck]psu_model PSU${fruID}: ${psu_model}"
        if [[ "x${psu_model}" != "x${PSU_PAC2000S12_BG}" ]]; then
            continue
        fi
        psu_code=$(sudo ipmitool raw 0x32 0xbb ${fruID} 0x10 0 0 0x59 2>&1)
        psu_code=${psu_code:1:23}
        PSU_echo "[PangeaPowerUpdateCheck]psu_info PSU${fruID}:${psu_code}"
        if [[ "x${psu_code}" != "x${PSU_02312HGY}" ]]; then
            continue
        fi
        MPA_BMC_CMD_OUTPUT "mpa bmc getpowerversion 100${fruID} 1"
        psu_version=$(grep "Power Software Version" "${Power_Output}" |awk -F ":" '{print $2}')
        PSU_echo "[PangeaPowerUpdateCheck]psu_version PSU${fruID}:${psu_version}"
        if [[ "x${psu_version}" == "x111" ]] || [[ "x${psu_version}" == "x113" ]] || \
           [[ "x${psu_version}" == "x115" ]] || [[ "x${psu_version}" == "x119" ]]; then
            retCode=1
        fi
    done
    rm -f ${Power_Output}
    
    return ${retCode}
}

function Get_Local_Host_Id()
{
(
swm_diagnose --auto <<EOF
host show
exit
EOF
) > ${Power_Output}

    local host_id=""
    local retCode=0

    host_id=$(grep "Local host id is:" "${Power_Output}" |awk -F "is: " '{print $2}')
    if [ "x${host_id}" != "x0" ]; then
        retCode=1
    fi
    PSU_echo "[PangeaPowerUpdateCheck] Local host id is: ${host_id}"
    rm -f ${Power_Output}
    return ${retCode}
}

function PSU_Upgrade_Status_Check_Main()
{
    local retCode=0

    # 1.检查电源升级补丁存在
    if [ ! -f "/OSM/script/power_update_daemon_process.sh" ]; then
        return 0
    fi
    # 2.检查风险电源升级完成
    Check_Upgrade_For_Risk_PSU
    retCode=$?
    if [[ ${retCode} -eq 0 ]]; then # 相等
        return 0
    fi
    # 3.0A节点判断升级状态
    local host_id=0
    retCode=0
    Get_Local_Host_Id
    host_id=$?
    if [ "x${host_id}" == "x0" ]; then
        if [ -f "/startup_disk/conf/conf_local/power_upgrade_permit" ]; then
            PSU_echo "[PangeaPowerUpdateCheck] /startup_disk/conf/conf_local/power_upgrade_permit is exist."
            retCode=1
        fi
        if [ -f "/startup_disk/conf/conf_local/power_upgrade_prohibit" ]; then
            PSU_echo "[PangeaPowerUpdateCheck] /startup_disk/conf/conf_local/power_upgrade_prohibit is exist."
            retCode=0
        fi
    else
        local filePath="/tmp"
        if [ -f "/home/ibc_os_hs/power_upgrade_conf_data" ]; then
            filePath="/home/ibc_os_hs"
        fi
        if [ -f "${filePath}/power_upgrade_start" ]; then
            PSU_echo "[PangeaPowerUpdateCheck] ${filePath}/power_upgrade_start is exist."
            retCode=1
        fi
    fi

    return ${retCode}
}

PSU_Upgrade_Status_Check_Main
retCheck=$?
if [ "${retCheck}" == "0" ]; then
    echo "True"
else
    echo "False"
fi
exit 0

