# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
from cbb.business.operate.fru.common import BaseFactory
from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil

# 融合存储限制型号
LIMIT_PDT_MODEL = [
    "5600 V3", "5800 V3", "6800 V3", "18500 V3", "18800 V3",
    "5600 V5", "5800 V5", "6800 V5", "18500 V5", "18800 V5",
]

# 限制的版本
LIMIT_PDT_VERSION = {
    # 融合存储版本
    "hybrid": [
        "V300R006C10", "V300R006C10SPC100", "V300R006C20",
        "V300R006C20SPC100", "V300R006C30", "V300R006C50SPC100",
        "V300R006C50SPC200", "V500R007C00", "V500R007C00SPC100",
        "V500R007C10", "V500R007C20", "V500R007C30SPC100", "V500R007C30SPC200"
    ],
    # Dorado版本
    "solid": ["V300R002C10SPC100", "V300R002C20"]
}


def execute(dataDict):
    """补丁工具特定版本限制使用维护口登录

    :param dataDict:
    :return:
    """
    lang = dataDict.get('lang')
    try:
        # 检查型号及版本是否需要限制
        if not is_limit_model_version(dataDict):
            return True, ""
        # 检查登录工具的IP是否是维护口IP
        return check_ip(dataDict)
    except Exception as ex:
        BaseFactory.log.error(
            dataDict, "Exception occurred when check ip:{}".format(str(ex)))
        return False, baseUtil.getPyResource(lang, "query.result.abnormal")


def is_limit_model_version(dataDict):
    """检查是否为受限型号及版本

    :param dataDict:
    :return:
    """
    dev = dataDict.get('dev')
    pdt_model = str(dev.getDeviceType())
    pdt_version = dev.getProductVersion()
    login_ip = dev.getIp()
    BaseFactory.log.info(dataDict,
                         "current product model:{}, version:{}, login "
                         "ip:{}".format(pdt_model, pdt_version, login_ip))
    if (pdt_model in LIMIT_PDT_MODEL
        and pdt_version in LIMIT_PDT_VERSION.get("hybrid")) \
        or (baseUtil.isDoradoNAS(pdt_model)
            and pdt_version in LIMIT_PDT_VERSION.get("solid")):
        return True
    return False


def check_ip(dataDict):
    """检查工具登录的IP是否是维护口IP

    :param dataDict:
    :return:
    """
    dev = dataDict.get('dev')
    login_ip = dev.getIp()
    cmd = r"show port general logic_type=Maintenance_Port"
    cli = dataDict.get("ssh")
    lang = dataDict.get('lang')
    cli_ret = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if cli_ret[0] is not True:
        return False, cli_ret[2]

    port_infos = cliUtil.getHorizontalCliRet(cli_ret[1])
    if not port_infos:
        return False, baseUtil.getPyResource(lang, "query.result.abnormal")

    for port in port_infos:
        ipv4 = port.get("IPv4 Address")
        ipv6 = port.get("IPv6 Address")
        if login_ip == ipv4 or login_ip == ipv6:
            return False, baseUtil.getPyResource(
                lang, "patch.limit.maintenance.port")
    return True, ""
