# -*- coding: UTF-8 -*-

from cbb.frame.rest.restUtil import Tlv2Rest
from cbb.frame.rest.restData import TlvCmd
from cbb.frame.tlv.tlvData import OM_OBJ_E
from cbb.frame.tlv.tlvData import PUB_ATTR
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil

NODE_ID_INDEX = "1"
VALUE_INDEX = "64"


def execute(data_dict):
    params = []
    param = (PUB_ATTR.get('type'), OM_OBJ_E.get('TASK_RESTRICT_STATE'))
    params.append(param)
    logger = contextUtil.getLogger(data_dict)
    lang = contextUtil.getLang(data_dict)
    recs = ''
    try:
        recs = Tlv2Rest.execCmd(contextUtil.getRest(data_dict),
                                TlvCmd.GET_BATCH, params)
        result_map = trans_response2map(recs)
        error = []
        for key in result_map:
            if result_map[key] != '0':
                error.append(
                    baseUtil.getPyResource(
                        lang, 'checkitem.restrictstate.notpass', key))
        return len(error) == 0, '\n'.join(error), recs
    except Exception as e:
        logger.error('error occurs when query restrict info', e)
        return cliUtil.RESULT_NOCHECK, baseUtil.getPyResource(
            lang, 'query.result.abnormal'), recs


def trans_response2map(recs):
    k_2_v_dict = {}
    control_num = len(recs)
    for index in range(0, control_num):
        rec = recs[index]
        node_id = rec.get(NODE_ID_INDEX).get('value')
        result = rec.get(VALUE_INDEX).get('value')
        k_2_v_dict[node_id] = result
    return k_2_v_dict
