# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.frame.base import product
from cbb.frame.base import baseUtil
from utils import Products


def execute(context):
    '''
    检查SSH默认端口
    :return: True：SSH端口是22，False：SSH端口不是22
    '''
    BLACK_LIST = ["6.0.RC1"]
    cur_version = contextUtil.getCurVersion(context)
    # 数字版本非6.0.RC1或者版本大于V500R007C60SPC300使用ssh的端口为22
    if (product.isDigitalVer(cur_version) and cur_version not in BLACK_LIST) \
            or Products.compareVersion(cur_version, "V500R007C60SPC300") >= 0:
        return True, ""
    dev_map = contextUtil.getDevObj(context)
    ssh_port = int(dev_map.get("sshPort"))
    if ssh_port != 22:
        lang = contextUtil.getLang(context)
        err_msg = baseUtil.getPyResource(lang, "ssh.port.not.22")
        return False, err_msg
    return True, ""
