# -*- coding: UTF-8 -*-
import time
from cbb.business.operate.expansion import common
from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil

# 刷盘轮询时间
limit_time = 900


def execute(context):
    """
    启动SMB全局failover功能
    :param context:
    :return:
    """
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    cli = contextUtil.getCli(context)
    # 查询是否有CIFS任务
    flag, err_msg, suggestion = has_task(cli, lang, logger)
    if flag:
        return True, "", ""
    elif err_msg:
        return False, err_msg, suggestion
    logger.logInfo("start smb.")
    # 查询SMB业务连续性状态,若为关闭，则开启
    flag, err_msg, suggestion = get_cifs_status(context, cli, lang, logger)
    if not flag:
        return False, err_msg, suggestion
    if flag is True and err_msg == "no_smb":
        return True, "", ""

    # 查询待更换的控制器上的刷盘状态,轮询15分钟
    start_time = time.time()
    while (time.time() - start_time) < limit_time:
        cmd = "nas_proto_pum -m shim -c show_flush_mem_table_status"
        flag, cli_ret, err_msg = \
            cliUtil.excuteCmdInDebugModel(cli, cmd, True, lang)
        logger.logInfo("cli_ret: %s." % cli_ret)
        if flag is True and "Finished" in cli_ret:
            return True, "", ""
        time.sleep(5)
    err_msg, suggestion = common.getMsg(lang, "deal.tasks.fail")
    return False, err_msg, suggestion


def has_task(cli, lang, logger):
    """
    检查是否有CIFS任务
    :return:
    """
    cmd = "show logical_port general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        err_msg, suggestion = common.getMsg(lang, "system.abnormal")
        return False, err_msg, suggestion

    record_list = cliUtil.getHorizontalCliRet(cli_ret)
    logger.logInfo("record_list: %s." % record_list)
    if not record_list:
        return True, "", ""

    for logic_port in record_list:
        running_status = logic_port.get("Running Status", "")
        support_protocol = logic_port.get("Support Protocol", "")
        if running_status == "Link Up" and "CIFS" in support_protocol:
            return False, "", ""
    return True, "", ""


def get_cifs_status(context, cli, lang, logger):
    """
    获取SMB业务连续性状态，若为关闭，则开启
    :return:
    """
    cmd = "show service cifs"
    ret = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang, preExec=False)
    if not ret[0]:
        err_msg, suggestion = common.getMsg(lang, "open.SMB.fail")
        return False, err_msg, suggestion
    cur_ret = cliUtil.getVerticalCliRet(ret[1])
    logger.logInfo("cur_ret: {}.".format(cur_ret))

    if "SMB Global CA Enable" not in cur_ret[0].keys():
        return True, "no_smb", ""
    cifs_status = cur_ret[0].get("SMB Global CA Enable", None)
    logger.logInfo("cifs_status: %s." % cifs_status)
    if cifs_status is None:
        err_msg, suggestion = common.getMsg(lang, "open.SMB.fail")
        return False, err_msg, suggestion
    if cifs_status == "No":
        ret = open_task(cli, lang)
        logger.logInfo("ret: %s." % ret[1])
        if not ret[0]:
            err_msg, suggestion = common.getMsg(lang, "open.SMB.fail")
            return False, err_msg, suggestion
    if not contextUtil.getItem(context, "cifs_status"):
        contextUtil.setItem(context, "cifs_status", cifs_status)
    return True, "", ""


def open_task(cli, lang):
    """
    开启SMB业务
    :param cli:
    :param lang:
    :return:
    """
    cmd = "change service cifs smb_global_ca_enable=yes"
    ret = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang, preExec=False)
    return ret
