# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.cli import cliUtil
from cbb.frame.rest import restUtil
from cbb.frame.rest import restData


def execute(context):
    lang = contextUtil.getLang(context)
    rest = contextUtil.getRest(context)
    pool_id = contextUtil.getItem(context, "smart_cache_pool_id")
    locations = contextUtil.getItem(context, "scm_disk_locations")

    flag, disk_ids, err_msg = get_disk_ids(rest, locations, lang)
    if flag is not True:
        contextUtil.handleFailure(
            context, {"flag": False, "errMsg": err_msg, "suggestion": ""})
    param_dict = {}
    param_dict["associateObjIDList"] = disk_ids
    param_dict["id"] = pool_id

    flag, err_msg, suggestion = \
        expand_smart_cache_pool(context, rest, lang, param_dict)

    if not flag:
        contextUtil.handleFailure(
            context,
            {"flag": False, "errMsg": err_msg, "suggestion": suggestion})
        return
    contextUtil.handleSuccess(context)
    return


def get_disk_ids(rest, locations, lang):
    """
    获取盘ID
    :param rest:
    :param locations:
    :param lang:
    :return:
    """
    disk_datas = restUtil.CommonRest().getBatchDisks(rest)
    if not disk_datas:
        return False, "", cliUtil.getMsg(lang, "query.result.abnormal")
    disk_ids = []
    for disk_data in disk_datas:
        if disk_data.get("LOCATION") in locations.split(","):
            disk_ids.append(disk_data.get("ID"))
    return True, disk_ids, ""


def expand_smart_cache_pool(context, rest, lang, param_dict):
    """
    执行扩smart_cache_pool
    :param context:
    :param rest:
    :param lang:
    :param param_dict:
    :return:
    """
    uri_param_dict = restUtil.CommonRest.getUriParamDict(
        restData.RestCfg.OBJ.EXPANSION_SMART_CACHE_POOL)
    try:
        restUtil.CommonRest.execCmd(rest,
                                    uri_param_dict,
                                    param_dict,
                                    restData.RestCfg.RestMethod.PUT)
        return True, "", ""
    except Exception as e:

        error_code = e.args[0]
        error_param = e.args[2] if len(e.args) > 2 else ""
        logger = contextUtil.getLogger(context)
        logger.info(
            "xxx:{}".format(contextUtil.getItem(context, 'errCodeMgrObj', {})))
        logger.info(
            "xxx:{}".format(error_code))
        logger.info(
            "xxx:{}".format(
                contextUtil.getItem(context, 'errCodeMgrObj', {}).get(
                    str(error_code))))
        err_msg, suggestion = \
            contextUtil.getItem(context, 'errCodeMgrObj', {}).get(
                int(error_code))

        return False, err_msg.format(error_param), \
            suggestion.format(error_param)
