# -*- coding: UTF-8 -*-

import ConfigParser
import os
import codecs
from cbb.frame.base.funcUtils import wrap_all_exception_logged

TOOL_CONFIG_FILE_NAME = "tool_config.properties"


def getToolConfigPath():
    curDir = __file__.lower()
    flieDir = curDir[:curDir.rfind("process")]
    guideDir = os.path.join(flieDir, "config")
    return os.path.join(guideDir, TOOL_CONFIG_FILE_NAME)


def getValue(key):
    '''
                获取对应key的值，key不存在返回空
    '''
    try:
        configPath = getToolConfigPath()
        config = ConfigParser.ConfigParser()
        config.read(configPath)
        return config.get("TOOL_CONFIG", key)
    except:
        return ""


@wrap_all_exception_logged(logger=None)
def setInfo(key, value):
    '''
                设置对应key的值
    '''

    configPath = getToolConfigPath()
    if not os.path.isfile(configPath):
        return
    with codecs.open(configPath, 'w+', encoding='utf-8') as f:
        f.write("[TOOL_CONFIG]\n{}={}".format(key, value))
