﻿# -*- coding: UTF-8 -*-
import time

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.common.conf.productConfig import PORTS_TOTAL_TIME_SECS
from cbb.common.conf.productConfig import LOOP_CHECK_PORTS_TIME_SECS
from cbb.frame.base import funcUtils
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil

# 保存后端端口key值
ALL_NORMAL_BACK_PORT = "allNormalBackPort"


@funcUtils.fakeProgress(PORTS_TOTAL_TIME_SECS)
def execute(context, preCheck=True):
    """检查后端端口状态更换前后是否一致

    :param context: python执行上下文
    :param preCheck: True - 更换前检查  False - 更换后检查
    :return:
    """
    # 更换前备份信息
    if preCheck:
        normalPortbefore = getCurrentBackPort(context)
        BaseFactory.log.info(context,
                             "list of normal Back "
                             "port:%s" % str(normalPortbefore))
        BaseFactory.persist.setModule(context,
                                      ALL_NORMAL_BACK_PORT,
                                      normalPortbefore)
        BaseFactory.result.setResultPass(context)
        return
    # 更换后比对信息
    else:
        BaseFactory.log.info(context, "====Check Normal Back port==== begin")
        sasPortBefore = BaseFactory.persist.getModule(context,
                                                      ALL_NORMAL_BACK_PORT)
        BaseFactory.log.info(context,
                             "normal Back port before "
                             "is :%s" % str(sasPortBefore))
        if not sasPortBefore:
            BaseFactory.result.setResultPass(context)
            return

        abnormalPorts = []
        start_time = time.time()
        while (time.time() - start_time) <= LOOP_CHECK_PORTS_TIME_SECS:
            # 更换后端口信息
            normalPortCur = getCurrentBackPort(context)
            BaseFactory.log.info(context,
                                 "normal Back port after "
                                 "is :%s" % str(normalPortCur))

            # 检查一致性，如果一致直接通过。
            abnormalPorts = [portId for portId in sasPortBefore
                             if portId not in normalPortCur]
            if not abnormalPorts:
                BaseFactory.result.setResultPass(context)
                BaseFactory.log.info(context,
                                     "====Check sas port==== pass end")
                return
            # 否则睡眠5秒继续轮询端口信息
            time.sleep(5)

        # 轮询超时检查都不一致，则不通过
        BaseFactory.result.setResultFailByKey(
            context,
            FuncFactory.LangKey.SAS_PORT_NOT_LINKDOWN,
            ", ".join(abnormalPorts))
        BaseFactory.log.info(context, "====Check Back port==== fail end")
        return


def getCurrentBackPort(context):
    """获取后端断口（SAS PCIE ETH）
    IP框架的ETH口（RDMA）
    筛选logic_type=exp的端口为后端端口

    :param context:
    :return:
    """
    allBackPorts = []
    allSASPorts = FuncFactory.get_fru_list_info_with_not_support_type(
        context, restData.Enum.ObjEnum.SAS_PORT)
    allBackPorts.extend(getBackEndPort(
        allSASPorts, restData.Hardware.SasPort.LOGIC_TYPE))
    allEthPorts = FuncFactory.get_fru_list_info_with_not_support_type(
        context, restData.Enum.ObjEnum.ETH_PORT)

    allBackPorts.extend(getBackEndPort(
        allEthPorts, restData.Hardware.EthPort.LOGIC_TYPE))
    if not allBackPorts:
        return []
    return list(map(lambda x: restUtil.Tlv2Rest.getRecordValue(
        x, restData.PublicAttributes.LOCATION), allBackPorts))


def get_current_intf_linked_back_port(all_back_ports, sel_row):
    return [linked_port for linked_port in all_back_ports
            if str(linked_port).startswith(sel_row.get("location", ""))]


def getBackEndPort(ports, logicType):
    """筛选所有后端端口口

    :param ports: 端口列表
    :param logicType: 端口逻辑类型
    :return:
    """
    condition = restUtil.Tlv2Rest.getCondition(
        logicType,
        restData.Enum.ConditionTypeEnum.EQOR,
        [restData.Enum.PortLogicTypeEnum.EXP,
         restData.Enum.PortLogicTypeEnum.BACK_CONTAINER_CARD])
    condition1 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.EthPort.RUNNING_STATUS,
        restData.Enum.ConditionTypeEnum.EQ,
        restData.Enum.RunningStatusEnum.LINK_UP)
    conditionList = restUtil.Tlv2Rest.getConditionList(condition, condition1)
    ports = restUtil.Tlv2Rest.filter(ports, conditionList)
    return ports if ports else []
