# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import common

# 进度总剩余时间
LIMIT_TIME = 120


def execute(context, **kwargs):
    """系统业务压力检查
    检查系统业务压力是否满足更换要求。

    :param context(dict): python执行上下文
    :param kwargs(dict): 可变参数dict
    :return: dict: 检查结果 ,格式：{"succ":True,"errMsg":"","suggestion":""}
    """
    try:
        # 进度条
        common.threadUpProcess(context, LIMIT_TIME)
        BaseFactory.log.info(context, u"==========begin checkBusinessPress==========")

        # 调用公用模块检查CPU使用率和IO并发数
        FuncFactory.checkSysSrvPressure(context)
        return
    except Exception as ex:
        raise ex
    finally:
        # 进度条刷为完成状态
        common.finishProcess(context)
