﻿# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import LoopCheckFactory
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.frame.rest.restData import EnumStr

SAS_20_CARD_MODELS = ["2389"]
SAS_10_CARD_MODELS = ["518", "538"]


def execute(context, model_before, fru_id, is_scale_out=False):
    """检查更换后接口卡类型是否一致

    :param context: 上下文
    :param model_before: 更换前的接口卡model
    :param fru_id: 更换的接口卡ID
    :param is_scale_out: 是否是scaleout接口卡
    :return:
    """
    if not all([model_before, fru_id]):
        BaseFactory.log.info(context, "param invalid, check pass")
        BaseFactory.result.setResultPass(context)

    # 获取接口卡信息，scaleout接口卡调专用命令字查询
    if is_scale_out:
        intf_module = LoopCheckFactory.Loop.getIpScaleOutIntfInfo(context, fru_id)
    else:
        intf_module = FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.INTF_MODULE, fru_id)
    if not intf_module:
        return

    # 获取更换后接口卡model，如果该字段不存在，则直接通过，否则比较model枚举是否一致
    model = restUtil.Tlv2Rest.getRecordValue(intf_module, restData.Hardware.IntfModule.MODEL)
    if model and str(model_before) != str(model):
        BaseFactory.log.info(context, "current interface model:%s " % model)
        BaseFactory.log.info(context, "before interface model:%s " % model_before)
        # 场景更换前为SAS2.0更换为SAS1.0
        if not con_change_sas_interface_card(str(model), str(model_before)):
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.FRONTINTF_WORKING_MODEL_NOT_SAME)
            return
        # 兼容C、C+卡互换的情况。当卡model值不同的情况下，只要model值对应的卡名称相同，也通过。
        if EnumStr.StrIntfModelEnum.get(int(model)) != EnumStr.StrIntfModelEnum.get(int(model_before)):
            BaseFactory.result.setResultFailByKey(
                context, FuncFactory.LangKey.FRONTINTF_WORKING_MODEL_NOT_SAME)
            return

    BaseFactory.result.setResultPass(context)
    return


def con_change_sas_interface_card(model, model_before):
    """
    1、场景更换前为SAS2.0更换为SAS1.0防呆，不兼容
    2、场景SAS1.0更换为SAS2.0
    以上场景不可更换。

    @param model: 更换后的model
    @param model_before:更换前的model
    @return: 是否可以更换
    """
    # 场景更换前为SAS2.0更换为SAS1.0
    if model_before in SAS_20_CARD_MODELS and model in SAS_10_CARD_MODELS:
        return False
    # 场景SAS1.0更换为SAS2.0
    if model in SAS_20_CARD_MODELS and model_before in SAS_10_CARD_MODELS:
        return False
    return True
