# -*- coding: UTF-8 -*-
from cbb.frame.base import baseUtil
from cbb.business.operate.fru.common import common
from cbb.frame.context import contextUtil
import json


def update_items(context, select_id):
    """刷新多个硬盘的注意描述
    :param context: 上下文
    :param select_id:
    :return:
    """

    logger = baseUtil.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    try:

        items = []
        type_des = []
        disks = json.loads(context.get(select_id))
        for disk in disks:
            loc = disk.get("location")
            disk_type = disk.get("diskType")
            type_des.append(baseUtil.getRes(lang, "diskDes", (loc, disk_type)))

        items.append(baseUtil.getRes(lang, "diskTypeMulti",
                                     ",".join(type_des)))
        items.append(baseUtil.getRes(lang, "firmwareVersionNotice"))
        json_array = []
        for item in items:
            json_array.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(json_array)
        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        logger.error("get notice item error:%s" % str(exception))
        msg, sug = common.getMsg(lang, "execute.error")
        contextUtil.setResult(context, False, msg, sug)
        return
