# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2012-. All rights reserved.

from cbb.frame.cli import cliUtil


def get_vlan(cli, lang):
    """获取show vlan general返回信息

    :param cli: cli链接
    :param lang: 语言
    :return:
    """
    # 执行命令获取回显
    cmd = "show vlan general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return False, cli_ret, err_msg

    # 处理回显 获取回显字典列表
    vlan_info_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)

    return True, vlan_info_list, err_msg
