#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

import os
import sys
import traceback

from java.lang import Exception as JException
from com.huawei.ism.tool.sdk.unified.log.filter import LogFilterMark


def format_traceback():
    new_extracted_list = []
    etype, value, tb = sys.exc_info()
    extracted_list = traceback.extract_tb(tb)
    for item in extracted_list:
        filename, lineno, name, line = item
        filename = os.path.basename(filename)
        new_extracted_list.append((filename, lineno, name, line))

    return "".join(traceback.format_list(new_extracted_list) +
                   traceback.format_exception_only(etype, value))


class Logger(object):
    """ 日志类 """

    def __init__(self, logger_instance, py_file_name, is_ignore_sensitive=False):
        self.logger_instance = logger_instance
        self.py_file_name = py_file_name
        self.is_ignore_sensitive = is_ignore_sensitive

    def debug(self, msg):
        """
        调试信息输出
        :param msg: 调试信息
        """
        if msg is None:
            msg = "None"
        self.logger_instance.debug("%s{}" % msg, self.__get_last_replace_parameter())

    def info(self, msg):
        """
        调试信息输出
        :param msg: 调试信息
        """
        if msg is None:
            msg = "None"
        self.logger_instance.info("[ToolLog][%s][info][%s]{}" % (self.py_file_name, str(msg)),
                                  self.__get_last_replace_parameter())

    def error(self, msg):
        """
        检查异常时的输出
        :param msg: 异常消息
        """
        trace = format_traceback()
        self.logger_instance.error("[ToolLog][%s][error][%s][traceback:%s]{}" % (self.py_file_name, msg, trace),
                                   self.__get_last_replace_parameter())

    def logInfo(self, msg):
        """
        调试信息输出
        :param msg: 调试信息
        """
        if msg is None:
            msg = "None"
        self.logger_instance.info("[ToolLog][%s][info][%s]{}" % (self.py_file_name, str(msg)),
                                  self.__get_last_replace_parameter())

    def logPass(self):
        """检查通过时的输出 """
        self.logger_instance.info("[ToolLog][%s][pass]{}" % self.py_file_name, self.__get_last_replace_parameter())

    def logNoPass(self, err_msg):
        """
        检查不通过时的输出
        :param err_msg: 错误消息
        """
        if err_msg is None:
            err_msg = "None"
        self.logger_instance.info("[ToolLog][%s][no_pass][%s]{}" % (self.py_file_name, str(err_msg)),
                                  self.__get_last_replace_parameter())

    def logException(self, exception):
        """ 检查异常时的输出
        :param exception: 异常消息
        """
        try:
            trace = format_traceback()
            self.logger_instance.error("[ToolLog][%s][exception][arguements:%s]{}"
                                       % (self.py_file_name, unicode(exception.args)),
                                       self.__get_last_replace_parameter())
            self.logger_instance.error("[ToolLog][%s][exception][traceback:%s]{}"
                                       % (self.py_file_name, unicode(trace)), self.__get_last_replace_parameter())
        except (Exception, JException):
            pass

    def __get_last_replace_parameter(self):
        return LogFilterMark.INSENSITIVE if self.is_ignore_sensitive else ""
