# coding:utf-8
"""
@version: Toolkit V200R006C00
@time: 2019/10/23
@file: cli_with_cache.py
@function:
@modify:
"""
import cliUtil
from cbb.frame.context import contextUtil
from cbb.frame.context import sqlite_context
from cbb.frame.cli import sqlite_config as config
from cbb.frame.cli.cliResource import NO_LOG_CMD_LIST
import com.huawei.ism.tool.obase.db.SqliteManager as SqliteManager


def execute_cmd_in_cli_mode(context, cli, cmd, lang, sn, logger):
    """
    通用API, context需传入
    带数据库的查询，如果数据库中存在记录则直接查询数据库并返回数据，否则，
    先在阵列上查询，再存入数据库。
    :param context: java容器，支持Put,get操作。巡检中是objectForPy，存放于inspectContext中。
    :param cli:
    :param cmd:
    :param lang:
    :param sn:
    :param logger:
    :return:
    """

    sqlite_manager = SqliteManager()
    sqlite_conn = sqlite_context.get_sqlite_conn_from_context(context, sn,
                                                              logger)
    flag, cli_ret, err_msg = query_one_cmd(sqlite_manager, sqlite_conn,
                                           cmd, sn)
    logger.logInfo("query from db. sn:%s, cmd:%s, flag:%s" % (
        sn, cmd, str(flag)))
    # 首先从数据库中查询是否存在记录, None表示不存在记录
    if flag is None:
        # 数据库中不存在记录，使用连接查询。
        need_log = False
        if is_need_log(cmd, NO_LOG_CMD_LIST):
            need_log = True

        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd,
                                                            need_log, lang)
        sql = 'insert into table_array_info(sn,cmd,result_flag,' \
              'result_echo,result_error_msg) values ' \
              '(?,?,?,?,?)'

        sqlite_manager.updateWithParams(sqlite_conn, sql, sn, cmd, str(flag),
                                        cli_ret, err_msg)
        del sqlite_manager
        return flag, cli_ret, err_msg

    # 数据库中已存在则查询数据库。
    del sqlite_manager
    return flag, cli_ret, err_msg


def is_need_log(cmd_str, no_log_list):
    """
    检查是否需要打印日志，主要针对大规格命令不打印，防止冲日志。
    :param cmd_str:
    :param no_log_list:
    :return: True: 打印，False: 不打印
    """
    for reg_cmd in no_log_list:
        if reg_cmd in cmd_str:
            return False
    return True


def query_one_cmd(sqlite_manager, sqlite_conn, cmd, sn):
    """
    查询某个SN的某一条命令，数据库原子API
    :param sqlite_manager:管理类
    :param sqlite_conn:连接
    :param cmd:查询命令
    :param sn:序列号
    :return:查询结果，如果不存在记录需判断flag是否为None
    """
    sql = 'select * from table_array_info ' \
          'where cmd = ? and sn = ?'
    query_result = sqlite_manager.queryWithParams(sqlite_conn, sql, cmd, sn)
    if not query_result:
        return None, None, None

    for record in query_result:
        flag = record.get(config.DBConfig.Column.ARRAY_RES_FLAG)
        cli_ret = record.get(config.DBConfig.Column.ARRAY_RES_CLI_RET)
        err_msg = record.get(config.DBConfig.Column.ARRAY_RES_ERR_MSG)
        return convert_bool(flag), cli_ret, err_msg


def execute_cmd_in_cli_mode_with_cache(
        py_java_env, cli, cmd, logger, dev_sn=None):
    """
    为巡检工具封装的API
    带数据库的查询，如果数据库中存在记录则直接查询数据库并返回数据，否则，先在阵列上查询，再存入数据库。
    :param py_java_env:
    :param cli:
    :param cmd:
    :param logger:
    :param dev_sn:
    :return:
    """
    context = py_java_env.get("objectForPy")
    sn = py_java_env.get("devInfo").getDeviceSerialNumber()
    if dev_sn:
        sn = dev_sn
    lang = contextUtil.getLang(py_java_env)
    return execute_cmd_in_cli_mode(context, cli, cmd, lang, sn, logger)


def convert_bool(flag):
    """
    存入数据库中是string类型，如果本身是bool的需转换一次bool
    :param flag:
    :return:
    """
    if flag.lower() in ["true", "false"]:
        return True if flag.lower() == "true" else False

    return flag
