from cbb.frame.base import product
from cbb.frame.dsl import adapter


class EchoAdapter:
    def __init__(self, context):
        self.dev_type = adapter.get_dev_type(context)
        self.dev_version = adapter.get_dev_version(context)
        self.dev_patch_version = adapter.get_dev_patch_version(context)
        self.logger = adapter.get_logger(context)

    def get_fiber_module_power(self, data):
        tx_power = str_to_float(data.get("TxPower"))
        rx_power = str_to_float(data.get("RxPower"))
        if not tx_power or not rx_power:
            return None, None
        if self.is_dorado_v3():
            tx_power = tx_power / 10
            rx_power = rx_power / 10

        return tx_power, rx_power

    def is_dorado_v3(self):
        return product.is_dorado_v3(self.dev_type, self.dev_version)


def str_to_float(value):
    if not value:
        return None
    try:
        return float(value)
    except ValueError:
        return None


def get_value_by_keys(data, keys):
    for key in keys:
        if data.get(key):
            return data.get(key)
    return None
