# -*- coding: UTF-8 -*-
from com.huawei.ism.tool.arrayupgrade.logic.assistant import GZipAssistant
from com.huawei.ism.tool.obase.log import ToolLoggerFactory
from java.lang import Exception as JException

logger = ToolLoggerFactory.getLogger(GZipAssistant)


class GZipHandler():
    def __init__(self, zipFileName):
        self.zipFileName = zipFileName

    def openMemberFile(self, fileName):
        ga = GZipAssistant(self.zipFileName)
        br = ga.getFileBuffer(fileName)
        if br == None:
            logger.error("Get the file %s obj failed!" % fileName)
            return None
        return TgzFile(br)

    def getFileListByRe(self, patternStr):
        ga = GZipAssistant(self.zipFileName)
        fileList = ga.getFileListByRe(patternStr)
        return fileList

    def extractFile(self, fileName, destDir):
        '''解压文件到指定目录'''
        try:
            ga = GZipAssistant(self.zipFileName)
            return ga.extractFile(fileName, destDir)
        except JException, je:
            logger.error("Extrace file exception:%s ." % unicode(je))
        except Exception as e:
            logger.error("Extrace file exception:%s ." % unicode(e))
        return

    @staticmethod
    def compressToTgz(fileList, destPath, destFileName):
        '''
        @summary: 将多个文件压缩成tgz格式
        @param fileList: 需要打包的原始文件
        @param destPath: 打包后的文件保存路径
        @param destFileName: 打包后的文件名称
        '''
        compressFlag = GZipAssistant.compressToTgz(fileList, destPath, destFileName)
        return compressFlag


class TgzFile():
    def __init__(self, br):
        self.br = br

    def readFileline(self):
        '''按行读取文件内容'''
        line = self.br.readLine()
        if line != None:
            return line
        return None

    def closeFile(self):
        '''文件信息读取完成后，关闭数据流BufferReader'''
        GZipAssistant.closeBufferedReader(self.br)
