#!/bin/bash

source /OSM/script/product_net_base.sh

function checkIpEnclNum()
{
    result="False"
    diagsh --attach=*_12 --cmd="sys shownofcls" > "noftempfile"
    num=$(grep -E 'work|comm' noftempfile | awk '{print $4}' | sort | uniq | wc -l)
    OS_echo "CHECK_DUP_MESSAGE: ip encl num is $num."
    if [ $num -gt 12 ]; then
        result="False"
    else
        result="True"
    fi

    echo $result
    rm -f noftempfile
}

function checkIsMulEngine()
{
    diagsh --attach=*_12 --cmd="sys showcls" > "noftempfile"
    num=$(grep -E 'master|slave' noftempfile | awk '{print $5}' | sort | uniq | wc -l)
    OS_echo "CHECK_DUP_MESSAGE: engine num is $num."
    rm -f noftempfile
    if [ $num -gt 1 ]; then
        checkIpEnclNum
    else
        echo "True"
    fi
}

function checkIsScaleUpType()
{
    scaleUpType=$(cat /OSM/conf/bay_config.ini | grep "ScaleUpType" | awk -F= '{print $2}')
    OS_echo "CHECK_DUP_MESSAGE: scale up type is $scaleUpType."
    if [ "$scaleUpType" = "0" ]; then
        checkIsMulEngine
    else
        echo "True"
    fi
}

function checkDupMessage()
{
    G_IS_4U4C=`OS_IS_4U4C`
    if [ "$G_IS_4U4C" = "1" ]; then
        checkIsScaleUpType
    else
        echo "True"
    fi
}

checkDupMessage
