#!/bin/bash

##检查是否有迁移任务在同步中
if $(id -u admin > /dev/null 2>&1)
then
    adminName="admin"
else
    adminName=$(cat /etc/passwd | grep '/ISM/cli/ismcli' | grep ':0:root:')
    adminName=${adminName%%:*}
fi

if [ -z $adminName ]
then
    echo "FALSE"
    exit 1
fi

##查询fs migration##
touch /OSM/conf/checkFsMigrateSyncing
echo -e "show fs_migration general\n" | /ISM/cli/ismcli -u $adminName  > /OSM/conf/checkFsMigrateSyncing

##查询是否有同步中的迁移任务##
ans=$(grep -w 'SYNCING' /OSM/conf/checkFsMigrateSyncing)
if [ -z  "$ans" ]; then
    echo "TRUE"
else
    echo "FALSE"
fi
rm -f /OSM/conf/checkFsMigrateSyncing

exit 0