#!/bin/bash

UPGRADE_SH=isexistspecalarm.sh
OS_ExecDiagnose()
{
    local L_PID=$1
    local L_CMD=$2
    local L_FILE=$3

    if [ "$L_FILE" == "" ]; then
        diagsh --attach="$L_PID" --cmd="$L_CMD"
    else
        diagsh --attach="$L_PID" --cmd="$L_CMD" > ${L_FILE}
    fi
    return 0
}

#检查告警是否存在，存在则返回1，不存在则返回0
POOL_CHECK_ALARM_STATE()
{
    OS_echo "${UPGRADE_SH} : EXEC diagnose" >/dev/null

    OS_ExecDiagnose "*_666" "alarm querybyid $1 1 $2" poolalarmtmpinfo

    #检查告警是否存在，存在则返回1，不存在则返回0
    local L_ALARM_NUMBER=$(grep "Alarm Record Number is" poolalarmtmpinfo | grep -oE "[0-9]+")

    if [ -z "$L_ALARM_NUMBER" ];then
        OS_echo "${UPGRADE_SH} : Alarm $1 not exist !" >/dev/null
        return 0
    fi

    if [ "$L_ALARM_NUMBER" != "0" ];then
        OS_echo "${UPGRADE_SH} : Alarm $1 exist !" >/dev/null
        return 1
    fi

    OS_echo "${UPGRADE_SH} : Alarm $1 not exist !" >/dev/null

    return 0
}

result="FALSE"
#发送调试命令查询是否存在硬盘域失去框级冗余能力告警，存在则返回1，不存在则返回0
POOL_CHECK_ALARM_STATE "64441942124" "1"
if [ 1 == $? ];then
	result="TRUE"
fi

echo $result

## 删除临时文件
rm -f poolalarmtmpinfo
