#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging
import os
import sys
import yaml

logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')

RESULT_FILE_PATH = "/tmp/checkDdVersionTempResult"

# 直接执行diagnose命令的字符串格式：
# {0}表示attach的进程id,比如app_data为12，
# {1}表示需要执行的diagnose命令，
# {2}表示命令执行回显重定向文件，用于命令执行后的结果解析
DIAGNOSE_CHECK_CMD = "diagsh --attach=*_{0} --cmd='{1}' > '{2}'"

# 微存储618发布版本号
VER_MICRO_618 = 7610107000
# 开始支持san直通读的硬盘域版本号
DP_VERSION_SUPPORT_FAST_PATH = 74
# 版本信息文件（目标版本）
UPG_MANIFEST_PATH = '/startup_disk/image/pkg_upd/manifest.yml'
RETURN_TRUE = 0
RETURN_FALSE = -1
RETURN_NEED_CONTINUE_CHECK = 1
SYSTEM_NAME_IN_YML = "SYS"


# 获取目标版本信息
def get_upg_system_version_new():
    """
    获取系统版本号
    """
    if not os.path.exists(UPG_MANIFEST_PATH):
        logging.warning("sys file didnt exist.")
        return "", "", ""
    with open(UPG_MANIFEST_PATH) as file_handle:
        cfg_yml = yaml.safe_load(file_handle)
        try:
            target_version = str(cfg_yml.get(SYSTEM_NAME_IN_YML)["Version"])
            target_spc_version = str(cfg_yml.get(SYSTEM_NAME_IN_YML)["SpcVersion"])
            product = str(cfg_yml.get(SYSTEM_NAME_IN_YML)["Product"])
            return target_version, target_spc_version, product
        except Exception:
            logging.warning("CHECK_FUNC: Failed to get version.")
            return "", "", ""


# 检查产品类型及目标版本
def check_product_and_target_version():
    """
    检查产品类型及目标版本
    """
    target_version = get_upg_system_version_new()[0]
    product = get_upg_system_version_new()[2]
    # 非微存储忽略
    if "Micro" != product:
        return RETURN_TRUE
    # 有支持SAN直通读的硬盘域时，需确认目标版本不能低于618（1.3.x）
    if int(target_version) < VER_MICRO_618:
        return RETURN_FALSE
    return RETURN_TRUE


# 执行diag命令
def get_dia_cmd_result(diag_cmd_str):
    """
    执行diag命令
    """
    diag_cmd_str = DIAGNOSE_CHECK_CMD.format(12, diag_cmd_str, RESULT_FILE_PATH)
    ret = os.system(diag_cmd_str)
    if ret:
        logging.warning("diag exec result not exit, cmd: %s.", diag_cmd_str)
        return RETURN_FALSE
    return RETURN_TRUE


# 检查dd版本
def check_dd_version():
    """
    检查dd版本
    """
    with open(RESULT_FILE_PATH) as lines_of_file:
        lines_array = lines_of_file.readlines()
        for i in range(0, len(lines_array)):
            if "index  diskPoolID   localIndex   version   normalNidMap" in lines_array[i]:
                start = i + 2
            if "Minimum version for WholeDifChecksum is" in lines_array[i]:
                end = i
        for i in range(start, end):
            tmp_ret = lines_array[i].split()
            dd_version = int(tmp_ret[3])
            # 有支持SAN直通读的硬盘域时需进一步检查目标版本
            if dd_version >= DP_VERSION_SUPPORT_FAST_PATH:
                os.remove(RESULT_FILE_PATH)
                return RETURN_NEED_CONTINUE_CHECK
    os.remove(RESULT_FILE_PATH)
    return RETURN_TRUE


def main():
    """
    执行函数
    """
    try:
        diag_cmd_str = "pool baseinfo"
        ret = get_dia_cmd_result(diag_cmd_str)
        if ret == RETURN_FALSE:
            print("False")
            return 0
        ret = check_dd_version()
        if ret == RETURN_TRUE:
            print("True")
            return 0
        ret = check_product_and_target_version()
        if ret == RETURN_TRUE:
            print("True")
            return 0
        print("False")
        return 0

    except Exception as exp:
        logging.exception("downgrade_diskdomin_version_for_fast_path_check: %s", exp)
        print("False")
        return 1


if __name__ == '__main__':
    sys.exit(main())
