#!/bin/bash
source /OSM/script/os_load_base.sh

G_DIAGNOSE_OUTPUT_FILE="/OSM/update/diagnoseFsCopyTaskInfo"
G_PKG_YML_FILE=/startup_disk/image/pkg_upd/manifest.yml
FS_CHECK_TARGET_VERSION=7600510107

#=============================================================================
# Function Name: OS_ExecDiagnose_Usr
# Description  : 封装diagnose_usr命令
# Parameter    : cmd
# Returns      : 
#=============================================================================
OS_ExecDiagnose_Usr()
{
    local L_PID=$1
    local L_CMD=$2
    local L_FILE=$3

    if [ "$L_FILE" == "" ]; then
diagnose_usr --auto --attach=$L_PID <<EOF
$L_CMD
quit
EOF
    else
diagnose_usr --auto --attach=$L_PID <<EOF > "$L_FILE"
$L_CMD
quit
EOF
    fi
    return 0
}


# **************************************************************************** #
# Function Name: OS_CHECK_HAS_BGR_COPY_TASK
# Description: 使用 diagnose_usr命令检查是否存在后台拷贝任务
# Parameter:
# Return: 
# **************************************************************************** #
OS_CHECK_HAS_BGR_COPY_TASK()
{
    L_PKG_VERSION_STR=`cat $G_PKG_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}'`
	declare -i L_PKG_VERSION=0
    L_PKG_VERSION=`echo "$L_PKG_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`
	# 目标版本大于等于615 检查通过
	if [ $L_PKG_VERSION -ge $FS_CHECK_TARGET_VERSION ];then
		echo "False"
        return 0
    fi
    local FS_CMD="fs upgradecheck queryHasBgrTask"
    [ -f $G_DIAGNOSE_OUTPUT_FILE ] && rm -f $G_DIAGNOSE_OUTPUT_FILE
    OS_ExecDiagnose_Usr 12 "$FS_CMD" "$G_DIAGNOSE_OUTPUT_FILE"
    local CMD_RESULT=`cat $G_DIAGNOSE_OUTPUT_FILE |grep "False"`
	# 没有后台拷贝任务
	if [ -n "$CMD_RESULT" ];then
        echo "False"
        return 0
    fi
    echo "True"
    return 0
}

function CLEAR_AND_EXIT()
{
    ret=$1
    [ -f $G_DIAGNOSE_OUTPUT_FILE ] && rm -f $G_DIAGNOSE_OUTPUT_FILE
    exit $ret
}

# ---------------------  main  -----------------------#
#降级前文件系统是否存在后台拷贝任务

OS_CHECK_HAS_BGR_COPY_TASK
if [ $? != 0 ];then 
    CLEAR_AND_EXIT 1
fi
CLEAR_AND_EXIT 0