#!/bin/bash
source /OSM/script/os_load_base.sh

G_DIAGNOSE_OUTPUT_FILE="/OSM/update/diagnoseFsinfo"
G_PKG_YML_FILE=/startup_disk/image/pkg_upd/manifest.yml
FS_CHECK_TARGET_VERSION=7600512053

#=============================================================================
# Function Name: OS_ExecDiagnose_Usr
# Description  : 封装diagnose_usr命令
# Parameter    : cmd
# Returns      : 
#=============================================================================
OS_ExecDiagnose_Usr()
{
    local L_PID=$1
    local L_CMD=$2
    local L_FILE=$3

    if [ "$L_FILE" == "" ]; then
diagnose_usr --auto --attach=$L_PID <<EOF
$L_CMD
quit
EOF
    else
diagnose_usr --auto --attach=$L_PID <<EOF > "$L_FILE"
$L_CMD
quit
EOF
    fi
    return 0
}


# **************************************************************************** #
# Function Name: 
# Description: 使用 diagnose_usr命令检查是否有创建过迁移文件系统
# Parameter:
# Return: 
# **************************************************************************** #
OS_CHECK_HAS_CREATED_MIGRATION()
{
    L_PKG_VERSION_STR=`cat $G_PKG_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}'`
	declare -i L_PKG_VERSION=0
    L_PKG_VERSION=`echo "$L_PKG_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`
	# 目标版本大于等于616 检查通过
	if [ $L_PKG_VERSION -ge $FS_CHECK_TARGET_VERSION ];then
		echo "True"
        return 0
    fi
    local FS_CMD="gns degradeCheck"
    [ -f $G_DIAGNOSE_OUTPUT_FILE ] && rm -f $G_DIAGNOSE_OUTPUT_FILE
    OS_ExecDiagnose_Usr 12 "$FS_CMD" "$G_DIAGNOSE_OUTPUT_FILE"
    local CMD_RESULT=`cat $G_DIAGNOSE_OUTPUT_FILE |grep "result(0) cnt(0)"`
	# 当前没有创建过迁移文件系统
	if [ -n "$CMD_RESULT" ];then
        echo "True"
        return 0
    fi
    echo "False"
    return 0
}

function CLEAR_AND_EXIT()
{
    ret=$1
    [ -f $G_DIAGNOSE_OUTPUT_FILE ] && rm -f $G_DIAGNOSE_OUTPUT_FILE
    exit $ret
}

# ---------------------  main  -----------------------#
#降级前检查是否创建过迁移文件系统

OS_CHECK_HAS_CREATED_MIGRATION
if [ $? != 0 ];then 
    CLEAR_AND_EXIT 1
fi
CLEAR_AND_EXIT 0
