#!/bin/bash
source /OSM/script/os_load_base.sh
 
G_DIAGNOSE_OUTPUT_FILE="/OSM/update/diagnoseFsHasNewSmartMobilityInfo"
G_PKG_YML_FILE=/startup_disk/image/pkg_upd/manifest.yml
FS_CHECK_TARGET_VERSION=7600518051
 
#=============================================================================
# Function Name: OS_ExecDiagnose_Usr
# Description  : 封装diagnose_usr命令
# Parameter    : cmd
# Returns      :
#=============================================================================
OS_ExecDiagnose_Usr()
{
    local L_PID=$1
    local L_CMD=$2
    local L_FILE=$3
 
    if [ "$L_FILE" == "" ]; then
diagnose_usr --auto --attach=$L_PID <<EOF
$L_CMD
quit
EOF
    else
diagnose_usr --auto --attach=$L_PID <<EOF > "$L_FILE"
$L_CMD
quit
EOF
    fi
    return 0
}
 
# **************************************************************************** #
# Function Name: OS_CHECK_HAS_NEW_SMARTMOBILITY_FILE_SYSTEM
# Description: 使用 diagnose_usr命令检查是否存在配置了新版本的SmartMobility的文件系统
# Parameter:
# Return:
# **************************************************************************** #
OS_CHECK_HAS_NEW_SMARTMOBILITY_FILE_SYSTEM()
{
    L_PKG_VERSION_STR=`cat $G_PKG_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}'`
	declare -i L_PKG_VERSION=0
    L_PKG_VERSION=`echo "$L_PKG_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`
	# 目标版本大于等于618 检查通过
	if [ $L_PKG_VERSION -ge $FS_CHECK_TARGET_VERSION ];then
		echo "True"
        return 0
    fi
    local FS_CMD="fs upgradecheck hasNewVersionSmartMobilityFs"
    [ -f $G_DIAGNOSE_OUTPUT_FILE ] && rm -f $G_DIAGNOSE_OUTPUT_FILE
    OS_ExecDiagnose_Usr 12 "$FS_CMD" "$G_DIAGNOSE_OUTPUT_FILE"
    local CMD_RESULT=`cat $G_DIAGNOSE_OUTPUT_FILE |grep "False"`
	# 没有文件系统使用新版本的SmartMobility 检查通过
	if [ -n "$CMD_RESULT" ];then
        echo "True"
        return 0
    fi
    echo "False"
    return 0
}
 
function CLEAR_AND_EXIT()
{
    ret=$1
    [ -f $G_DIAGNOSE_OUTPUT_FILE ] && rm -f $G_DIAGNOSE_OUTPUT_FILE
    exit $ret
}
 
# ---------------------  main  -----------------------#
#降级前检查文件系统SmartMobility版本
 
OS_CHECK_HAS_NEW_SMARTMOBILITY_FILE_SYSTEM
if [ $? != 0 ];then
    CLEAR_AND_EXIT 1
fi
CLEAR_AND_EXIT 0