#!/bin/bash
# ********************************************** ***************************** #
# File Name: fdsa_tunefs_inspection.sh
# Description: fdsa日常巡检
# Input: none        
# Output: none
# Created: 2024-09-13
# Function List：
# History
# **************************************************************************** #

source /OSM/script/os_load_base.sh

manifest_file_path=/startup_disk/image/pkg_cur/manifest.yml
path_file_path=/OSM/conf/patch.yml
fdsa_diagnose_path=/OSM/script/fdsa_diagnose_op.sh

#目录检测列表：
CHECK_DIRECTORIES[0]="/startup_disk/conf/"
CHECK_DIRECTORIES[1]="/OSM/coffer_data/"
CHECK_DIRECTORIES[2]="/OSM/coffer_log/"
CHECK_DIRECTORIES[3]="/OSM/coffer_bin/"
CHECK_DIRECTORIES[4]="/OSM/coffer_runningdata/"

FAULT_COUNT=0
PATCH_VERSION="SPH0" # 默认为基线版本

if [ ! -f $manifest_file_path ]; then	# manifest文件不存在
    OS_echo "The manifest.yml path or file does not exist"
    echo "True"
    exit 0
fi
MainVer=`cat ${manifest_file_path}  | grep -w SpcVersion | awk '{print $(NF)}'`

if [ -f $path_file_path ]; then
    try_get_patchver=`cat ${path_file_path} | grep patch_version | head -1 | awk '{print $(NF)}'`
    if [ -z $try_get_patchver ]; then
        OS_echo "Cannot get patch version, check environment pls."
        echo "True"
        exit 0
    fi
    PATCH_VERSION=$try_get_patchver
fi

productRet=$( (diagsh --attach="app_data_12" --cmd="db show product type")) 2>/dev/null
case $productRet in
    *"Ocean protect."*)
        PRODUCT_TYPE="ocean_protect"
        ;;
    *"Ocean disk."*)
        PRODUCT_TYPE="ocean_disk"
        ;;
    *"Ocean micro."*)
        PRODUCT_TYPE="ocean_disk"
        ;;
    *)
        PRODUCT_TYPE=""
esac

version_arr=("6.1.2" "6.1.3" "6.1.5" "6.1.6" "6.1.7" "6.1.8")
problem_patch_arr=("SPH60" "SPH30" "SPH30" "SPH0" "SPH0" "SPH0")
fix_problem_patch_arr=("SPH67" "SPH33" "SPH38" "SPH20" "SPH8" "SPH2")

ocean_protect_arr=("1.2.0" "1.3.0" "1.5.0" "1.6.0")
ocean_protect_problem_patch_arr=("SPH30" "SPH0" "SPH0" "SPH0")
ocean_protect_fix_problem_patch_arr=("SPH38" "SPH20" "SPH8" "SPH2")

ocean_disk_arr=("1.1.0" "1.2.0" "1.3.0")
ocean_disk_problem_patch_arr=("SPH0" "SPH0" "SPH0")
ocean_disk_fix_problem_patch_arr=("SPH20" "SPH8" "SPH2")

arr_length=${#version_arr[@]}
ocean_proect_arr_length=${#ocean_protect_arr[@]}
ocean_disk_arr_length=${#ocean_disk_arr[@]}
i=0
j=0
k=0
IS_VERSION_WITH_PROBLEM()
{
    while [ $i -lt $arr_length ]
    do
        if [ "$MainVer" == ${version_arr[$i]} ]; then
            if [ `expr substr $PATCH_VERSION 4 4 \>= substr ${problem_patch_arr[$i]} 4 4` -eq 1 ] && [ `expr substr $PATCH_VERSION 4 4 \< substr ${fix_problem_patch_arr[$i]} 4 4` -eq 1 ] ;then
                return 1
            fi
        fi
        let i++
    done

    while [ $j -lt $ocean_proect_arr_length ]
    do
        if [ "${PRODUCT_TYPE}" == "ocean_protect" ] && [ "$MainVer" == ${ocean_protect_arr[$j]} ]; then
            if [ `expr substr $PATCH_VERSION 4 4 \>= substr ${ocean_protect_problem_patch_arr[$j]} 4 4` -eq 1 ] && [ `expr substr $PATCH_VERSION 4 4 \< substr ${ocean_protect_fix_problem_patch_arr[$j]} 4 4` -eq 1 ] ;then
                return 1
            fi
        fi
        let j++
    done

    while [ $k -lt $ocean_disk_arr_length ]
    do
        if [ "${PRODUCT_TYPE}" == "ocean_disk" ] && [ "$MainVer" == ${ocean_disk_arr[$k]} ]; then
            if [ `expr substr $PATCH_VERSION 4 4 \>= substr ${ocean_disk_problem_patch_arr[$k]} 4 4` -eq 1 ] && [ `expr substr $PATCH_VERSION 4 4 \< substr ${ocean_disk_fix_problem_patch_arr[$k]} 4 4` -eq 1 ] ;then
                return 1
            fi
        fi
        let k++
    done

    return 0
}

check_file_system_state()
{
	i=0
	while [ $i -lt ${#CHECK_DIRECTORIES[*]} ]
	do
        if [ -d ${CHECK_DIRECTORIES[$i]} ];then
            mount_dir=$(echo ${CHECK_DIRECTORIES[$i]} | sed 's/\/*$//')

            device_list=$(cat /proc/mounts | grep ${mount_dir} | awk '{print $1}')
		    if [ ! -n "$device_list" ]; then
			    let i++
			    continue
		    fi

		    for dev_name in $device_list; do
			    fs_state=`sudo tune2fs -l ${dev_name} | grep 'Filesystem state' | awk -F: '{print $2}' | sed 's/^[\t ]*//g'`
			    if [ "${fs_state}" != "" ] && [ "${fs_state}" != "clean" ]; then
				    OS_echo "[fdsa_check_sysdisk.sh]SYS_RAID:${mount_dir} filesystem state error."
				    let FAULT_COUNT++
			    fi
		    done
        fi
		let i++
	done

	return 0
}

#--------------------------------- main ----------------------
IS_VERSION_WITH_PROBLEM
if [ "$?" == 0 ] ;then
    echo "True"
    exit 0
fi

if [ ! -f $fdsa_diagnose_path ]; then
    OS_echo "The fdsa_diagnose_op.sh file does not exist"
    echo "True"
    exit 0
fi

tmp_result=`echo y | fdsa_diagnose_op.sh fdsa sysdiskmode show | grep "sysdisk mode is" | grep -o '[0-9]\+'`
if [ ${tmp_result} == 3 ]; then
    OS_echo "sysdisk mode is 3, inspection passed."
    echo "True"
    exit 0
fi

check_file_system_state

if [ 0 -ne $FAULT_COUNT ]; then
	OS_echo "Check file system state not clean, inspection failed."
    echo "False"
	exit 0
fi

echo "True"
exit 0