#!/usr/bin/python
# -*- coding: utf-8 -*-
import json
import logging
import os
import subprocess
import sys
import shlex

PYTHON_2 = '2.7' in sys.version
USER_EXIST = r'id -u admin > /dev/null 2>&1'
USER_CMD = r"cat /etc/passwd | grep '/ISM/cli/ismcli' | grep ':0:root:'"
USER_LOGIN_CMD = "/ISM/cli/ismcli -u {0}"
TIMEOUT = 5 * 60

logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')


def cli(command):
    sub_cmds = command.split(" | ")
    process = None
    for sub_cmd in sub_cmds:
        if process:
            process = subprocess.Popen(shlex.split(sub_cmd.strip()), stdin=process.stdout, stdout=subprocess.PIPE)
        else:
            process = subprocess.Popen(shlex.split(sub_cmd.strip()), stdout=subprocess.PIPE)
    timeout_para = {} if PYTHON_2 else {"timeout": TIMEOUT}
    out = process.communicate(**timeout_para)
    return out[0].decode("utf-8")


def get_user_name():
    ret = os.system(USER_EXIST)
    if not ret:
        return 'admin'
    else:
        output = cli(USER_CMD)
        if not output:
            logging.warning("Get user failed")
            return ''
        return output.strip().split(':')[0]


def net_check_bond_mtu():
    user_name = get_user_name()
    if not user_name:
        logging.warning("NET_CHECK_BOND_MTU: Get user failed.")
        print("False")
        return
    cli_login_str = USER_LOGIN_CMD.format(user_name)
    cmd_exec_dis_output_file_path = "/tmp/netcheckbondmtu"

    # 构造cli命令
    cli_cmd_str = "echo -e 'show bond_port' | " + cli_login_str + r"  > " + cmd_exec_dis_output_file_path

    ret = os.system(cli_cmd_str)
    if ret:
        logging.warning("NET_CHECK_BOND_MTU: Cmd(%s) exec failed, ret %d.", cli_cmd_str, ret)
        print("False")
        # 删除临时文件
        shell_cmd_str = "rm -f " + cmd_exec_dis_output_file_path
        os.system(shell_cmd_str)
        return

    with open(cmd_exec_dis_output_file_path) as lines:
        lines_array = lines.readlines()
        # 跳过前两行表头打印或是无bond记录时的回显
        lines_array = lines_array[4:]

        find = False
        # 解析每条bond记录，判断是否MTU是默认值，不是则报错
        for line in lines_array:
            index = 5
            record = line.lstrip().split()
            if record[4] != "Up":
                continue
            if int(record[index]) != 1500:
                logging.warning("NET_CHECK_BOND_MTU: Bond %s mtu is not default(1500), mtu %s.",
                                record[1], record[index])
                find = True
                break
        if find:
            print("False")
        else:
            print("True")

    # 删除临时文件
    shell_cmd_str = "rm -f " + cmd_exec_dis_output_file_path
    os.system(shell_cmd_str)
    return


def net_check_src_version():
    user_name = get_user_name()
    if not user_name:
        return False
    cli_login_str = USER_LOGIN_CMD.format(user_name)
    cmd = "echo -e 'show system general' | " + cli_login_str + r" | grep 'Product Version' | awk '{print $4}'"
    version = cli(cmd)
    version = version.rstrip('\r\n')
    # DORADO V6 TR5版本只能通过查询原版本号决定检查MTU
    if version == "6.0.RC1":
        return True
    else:
        return False


def net_check_version():
    version_file = "/tmp/check_extend_param"
    dst_version = ""
    dst_version_list = ["6.0.0", "6.0.1", "6.1.RC1"]

    onlyCheckSrcVersion = net_check_src_version()
    if onlyCheckSrcVersion:
        logging.info("NET_CHECK_BOND_MTU: only check source version")
        return 1

    with open(version_file, 'r') as f:
        read_str = str(f.read()).replace("'", '"')
        logging.info("NET_CHECK_BOND_MTU: Read str %s.", read_str)
        extend_param = json.loads(read_str)
        dst_version = str(extend_param.get('targetVersion', ''))
        logging.info("NET_CHECK_BOND_MTU: Dst version %s read from extend param file %s.", dst_version, version_file)

    if dst_version in dst_version_list:
        return 1

    print("True")
    return 0


def main():
    try:
        ret = net_check_version()
        if ret == 0:
            return 0
        net_check_bond_mtu()
        return 0

    except Exception as e:
        logging.exception("NET_CHECK_BOND_MTU: %s", e)
        print("False")
        return 1


if __name__ == '__main__':
    sys.exit(main())
