#!/usr/bin/python
# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import os
import re
import sys
import pwd
import logging
import subprocess
import shlex

# 直接执行CLI命令的字符串格式：
# {0}表示需要执行的CLI命令，
# {1}表示执行的CLI命令的用户名，
# {2}表示命令执行回显重定向文件，用于命令执行后的结果解析
USER_CMD = "cat /etc/passwd | grep '/ISM/cli/ismcli' | grep ':0:root:'"
CLI_CHECK_CMD = "sudo /ISM/cli/start.sh -u {0} -c '{1}' > '{2}'"

TMP_AUTID_LOG = "/tmp/swmcheckauditlog"
# 直接执行diagnose命令的字符串格式：
# {0}表示attach的进程id,比如app_data为12，
# {1}表示需要执行的diagnose命令，
# {2}表示命令执行回显重定向文件，用于命令执行后的结果解析
DIAGNOSE_CHECK_CMD = "diagsh --attach=*_{0} --cmd='{1}' > '{2}'"

# 系统盘audit日志最大值
AUDIT_LOG_RISK_LIFE_VALUE = 30

AUDIT_LOG_RISK_DEVICES = [
    "210305910710M1000022", "210305910710M1000021", "210305910710M4000004", "210305910710M4000003",
    "210305910710M4000002", "210305910710M4000001", "210305910710L7000010", "210305910710L7000009",
    "210305911110M2000007", "210305911110M2000008", "210305911110M2000005", "210305911110M2000006",
    "210305911110M3000001", "210305911110M3000002", "210305911110M5000032", "210305911110M5000031",
    "210305911110M6000003", "210305911110M6000002", "2103059111FSLC000010", "2103059111FSLC000009",
    "210305911110L3000015", "210305911110M1000002", "210305910310L2000020", "210305910310L2000019",
    "210305910310L2000024", "210305910310L2000023", "210305910310L2000039", "210305910310L2000040",
    "210305910310L5000049", "210305910310L5000052", "210305910310L5000050", "210305910310L5000051",
    "210305910310LA000005", "210305910310LA000006", "210305910310LA000019", "210305910310LA000018",
    "210305910310M2000002", "210305910310M2000001", "210305910310M3000001", "210305910310M3000002",
    "210305910310M3000004", "210305910310M3000003", "210305910310M3000006", "210305910310M3000005",
    "210305910310M3000047", "210305910310M3000048", "210305910310M3000052", "210305910310M3000063",
    "210305910310M3000051", "210305910310M3000053", "210305910310M3000050", "210305910310M3000049",
    "210305910310M3000055", "210305910310M3000065", "210305910310M3000107", "210305910310M3000119",
    "210305910310M3000122", "210305910310M3000121", "210305910310M3000120", "210305910310M3000111",
    "210305910310M3000106", "210305910310M3000076", "210305910310M3000090", "210305910310M3000098",
    "210305910310M3000091", "210305910310M3000092", "210305910310M3000086", "210305910310M3000085",
    "210305910310M3000087", "210305910310M3000088", "210305910310M3000095", "210305910310M3000096",
    "210305910310M3000077", "210305910310M3000078", "210305910310M3000116", "210305910310M3000115",
    "210305910310M3000126", "210305910310M3000125", "210305910310M3000082", "210305910310M3000081",
    "210305910310M3000113", "210305910310M3000114", "210305910310M3000128", "210305910310M3000127",
    "210305910310M3000140", "210305910310M3000139", "210305910310M3000134", "210305910310M3000133",
    "210305910310M3000138", "210305910310M3000137", "210305910310M3000145", "210305910310M3000150",
    "210305910310M3000151", "210305910310M3000152", "210305910310M3000131", "210305910310M3000146",
    "210305910310M3000163", "210305910310M3000164", "210305910310M3000167", "210305910310M3000166",
    "210305910310M3000162", "210305910310M3000171", "210305910310M3000159", "210305910310M3000170",
    "210305910310M3000153", "210305910310M3000158", "210305910310M3000181", "210305910310M3000182",
    "210305910310M3000189", "210305910310M3000184", "210305910310M3000177", "210305910310M3000180",
    "210305910310M3000185", "210305910310M3000187", "210305910310M3000192", "210305910310M3000186",
    "210305910310M3000200", "210305910310M3000199", "210305910310M3000210", "210305910310M3000193",
    "210305910310M3000204", "210305910310M3000205", "210305910310M3000195", "210305910310M3000201",
    "210305910310M3000207", "210305910310M3000196", "210305910310M3000222", "210305910310M3000229",
    "210305910310M3000226", "210305910310M3000228", "210305910310M3000215", "210305910310M3000225",
    "210305910310M3000218", "210305910310M3000217", "210305910310M3000231", "210305910310M3000232",
    "210305910310M3000251", "210305910310M3000237", "210305910310M3000239", "210305910310M3000250",
    "210305910310M3000244", "210305910310M3000248", "210305910310M3000233", "210305910310M3000247",
    "210305910310M3000245", "210305910310M3000249", "210305910310M3000260", "210305910310M3000259",
    "210305910310M3000253", "210305910310M3000270", "210305910310M3000271", "210305910310M3000266",
    "210305910310M3000256", "210305910310M3000267", "210305910310M3000272", "210305910310M3000263",
    "210305910310M3000282", "210305910310M3000277", "210305910310M3000281", "210305910310M3000280",
    "210305910310M3000275", "210305910310M3000286", "210305910310M3000288", "210305910310M3000284",
    "210305910310M3000291", "210305910310M3000292", "210305910310M3000296", "210305910310M3000297",
    "210305910310M3000308", "210305910310M3000307", "210305910310M3000302", "210305910310M3000306",
    "210305910310M3000300", "210305910310M3000303", "210305910310M3000293", "210305910310M3000305",
    "210305910310M3000319", "210305910310M3000325", "210305910310M3000320", "210305910310M3000315",
    "210305910310M3000322", "210305910310M3000330", "210305910310M3000324", "210305910310M3000328",
    "210305910310M3000326", "210305910310M3000314", "210305910310M3000337", "210305910310M3000338",
    "210305910310M3000346", "210305910310M3000344", "210305910310M3000334", "210305910310M3000333",
    "210305910310M3000342", "210305910310M3000348", "210305910310M3000351", "210305910310M3000352",
    "210305910310M3000365", "210305910310M3000370", "210305910310M3000400", "210305910310M3000401",
    "210305910310M3000395", "210305910310M3000408", "210305910310M3000359", "210305910310M3000360",
    "210305910310M3000399", "210305910310M3000402", "210305910310M3000386", "210305910310M3000388",
    "210305910310M3000377", "210305910310M3000392", "210305910310M3000375", "210305910310M3000373",
    "210305910310M3000387", "210305910310M3000380", "210305910310M3000389", "210305910310M3000382",
    "210305910310M3000383", "210305910310M3000378", "210305910310M3000371", "210305910310M3000364",
    "210305910310M3000369", "210305910310M3000372", "210305910310M3000405", "210305910310M3000393",
    "210305910310M3000404", "210305910310M3000403", "210305910310M3000355", "210305910310M3000353",
    "210305910310M3000429", "210305910310M3000432", "210305910310M3000414", "210305910310M3000420",
    "210305910310M3000415", "210305910310M3000418", "210305910310M3000424", "210305910310M3000427",
    "210305910310M3000413", "210305910310M3000417", "210305910310M3000433", "210305910310M3000434",
    "210305910310M3000436", "210305910310M3000435", "210305910310M3000440", "210305910310M3000444",
    "210305910310M3000442", "210305910310M3000441", "210305910310M3000443", "210305910310M3000439",
    "210305910310M3000437", "210305910310M3000438", "210305910310M3000461", "210305910310M3000462",
    "210305910310M4000046", "210305910310M4000047", "210305910310M4000048", "210305910310M4000049",
    "210305910310M8000003", "210305910310M8000004", "210305910310M8000001", "210305910310M8000002",
    "21030591039WM4800001", "21030591039WM4800002", "21030591039WM4800003", "21030591039WM4800004",
    "21030591039WM4800006", "21030591039WM4800005", "21030591039WM4800007", "21030591039WM4800008",
    "21030591039WM4800009", "21030591039WM4800010", "21030591039WM4800011", "21030591039WM4800012",
    "21030591039WM4800013", "21030591039WM4800014", "21030591039WM4800015", "21030591039WM4800016",
    "21030591039WM4800017", "21030591039WM4800018", "21030591039WM4800019", "21030591039WM4800020",
    "21030591039WM4800023", "21030591039WM4800024", "21030591039WM4800025", "21030591039WM4800026",
    "21030591039WM4800027", "21030591039WM4800028", "21030591039WM4800029", "21030591039WM4800030",
    "2103059103FSM6000006", "2103059103FSM6000005", "2103059103FSM6000076", "2103059103FSM6000075",
    "210305910310LB000040", "210305910310LB000028", "210305910310LB000039", "210305910310LB000029",
    "210305910310M1000014", "210305910310M1000011", "210305910310M3000041", "210305910310M1000013",
    "210305910310M3000013", "210305910310M3000023", "210305910310LB000043", "210305910310LB000057",
    "210305910310LB000055", "210305910310LB000058", "210305910310LB000053", "210305910310M1000004",
    "210305910310LB000054", "210305910310LB000056", "210305910310M1000002", "210305910310M1000003",
    "210305910310M4000004", "210305910310M4000008", "210305910310M4000007", "210305910310M4000011",
    "210305910310M4000005", "210305910310M4000006", "210305910210L3000002", "210305910210L3000003",
    "210305910210L5000050", "210305910210L5000051", "210305910210LC000022", "210305910210LC000021",
    "210305910210LC000037", "210305910210LC000038", "210305910210M1000008", "210305910210M1000009",
    "210305910210M1000036", "210305910210M1000035", "210305910210M2000025", "210305910210M2000027",
    "210305910210M2000028", "210305910210M2000026", "210305910210M2000033", "210305910210M2000034",
    "210305910210M2000035", "210305910210M2000036", "210305910210M2000037", "210305910210M2000038",
    "210305910210M3000007", "210305910210M3000008", "210305910210M3000026", "210305910210M3000027",
    "210305910210M3000029", "210305910210M3000028", "210305910210M3000031", "210305910210M3000030",
    "210305910210M4000001", "210305910210M4000002", "210305910210M5000020", "210305910210M5000019",
    "21030591029WM4800001", "21030591029WM4800002", "21030591029WM4800004", "21030591029WM4800003",
    "21030591029WM5800003", "21030591029WM5800004", "21030591029WM5800006", "21030591029WM5800005",
    "2103059102FSM5000002", "2103059102FSM5000001", "2103059102FSM6000003", "2103059102FSM6000004",
    "210305910210L6000056", "210305910210L6000055", "210305910210L6000057", "210305910210L6000058",
    "210305910210LA000008", "210305910210LA000009", "210305910210LB000087", "210305910210LB000091",
    "210305910210M1000056", "210305910210LB000062", "210305910210LA000045", "210305910210M1000055",
    "210305910210LB000072", "210305910210LB000063", "210305910210LB000053", "210305910210M1000003",
    "210305910210M3000005", "210305910210M3000004", "210305910210M3000002", "210305910210M3000001",
    "210305910210M3000006", "210305910210M3000003", "210305910210M3000041", "210305910210M3000042",
    "210305910210M3000037", "210305910210M3000039", "210305910210M3000035", "210305910210M3000036",
    "210305910210M3000040", "210305910210M3000038", "210305910210M4000008", "210305910210M4000007",
    "210305910210M4000010", "210305910210M4000009", "210305910210M4000003", "210305910210M4000012",
    "210305910210M4000006", "210305910210M4000005", "210305910210M4000019", "210305910210M4000018",
    "210305910210M4000021", "210305910210M4000015", "210305910210M5000006", "210305910210M5000002",
    "210305910210M5000009", "210305910210M5000010", "210305910210M5000004", "210305910210M5000005",
    "210305910910L4000021", "210305910910L4000024", "210305910910M3000001", "210305910910M3000002",
    "210305910910M3000008", "210305910910M3000007", "210305910910M4000009", "210305910910M4000010",
    "210305910910M4000012", "210305910910M4000011", "210305910910M5000006", "210305910910M5000005",
    "210305910910M7000007", "210305910910M7000008", "210305910510L9000012", "210305910510L9000011",
    "210305910510L9000027", "210305910510L9000028", "210305910510M2000010", "210305910510M2000009",
    "210305910510M3000012", "210305910510M3000010", "210305910510M3000009", "210305910510M3000008",
    "210305910510M3000011", "210305910510M3000013", "210305910510M3000019", "210305910510M3000016",
    "210305910510M3000014", "210305910510M3000015", "210305910510M3000037", "210305910510M3000036",
    "210305910510M3000033", "210305910510M3000031", "210305910510M3000032", "210305910510M3000030",
    "210305910510M3000035", "210305910510M3000034", "210305910510M3000043", "210305910510M3000042",
    "210305910510M3000045", "210305910510M3000044", "210305910510M3000047", "210305910510M3000046",
    "210305910510M3000048", "210305910510M3000049", "210305910510M4000004", "210305910510M4000006",
    "210305910510M4000007", "210305910510M4000005", "210305910510M4000015", "210305910510M4000014",
    "210305910510M4000013", "210305910510M4000012", "210305910510M4000009", "210305910510M4000008",
    "210305910510M4000023", "210305910510M4000022", "210305910510M4000034", "210305910510M4000033",
    "210305910510M5000042", "210305910510M5000043", "210305910510M5000045", "210305910510M5000044",
    "210305910510M5000048", "210305910510M5000051", "210305910510M5000050", "210305910510M5000047",
    "210305910510M5000049", "210305910510M5000046", "210305910510M7000019", "210305910510M7000020",
    "2103059105FSLB000044", "2103059105FSLB000034", "2103059105FSLC000042", "2103059105FSLC000041",
    "2103059105FSLC000039", "2103059105FSLC000040", "2103059105FSM6000022", "2103059105FSM6000021",
    "210305910510M1000013", "210305910510M1000014", "210305910510M1000011", "210305910510M1000012",
    "210305910510M5000027", "210305910510M5000026", "210305910510M5000029", "210305910510M5000028",
    "210305910510M1000004", "210305910510M1000006", "210305910510M1000003", "210305910510M1000005",
    "210305904610M2000008", "210305904610M2000006", "210305904610M2000005", "210305904610M2000007",
    "210305904610M2000009", "210305904610M2000011", "210305904610M2000010", "210305904610M2000012",
    "210305904610M4000005", "210305904610M4000007", "210305904610M4000008", "210305904610M4000006",
    "210305904610M4000011", "210305904610M4000009", "210305904610M4000010", "210305904610M4000012",
    "210305904610M4000020", "210305904610M4000019", "210305904610M4000018", "210305904610M4000017",
    "210305904610M4000030", "210305904610M4000029", "210305904610M4000031", "210305904610M4000032",
    "210305904610M4000036", "210305904610M4000033", "210305904610M4000035", "210305904610M4000034",
    "210305904610M6000008", "210305904610M6000004", "210305904610M6000003", "210305904610M6000007",
    "210305904610M6000006", "210305904610M6000001", "210305904610M6000005", "210305904610M6000002",
    "210305904610M7000051", "210305904610M7000050", "210305904610M7000049", "210305904610M7000052",
    "210305904610M8000005", "210305904610M8000006", "210305904610M8000004", "210305904610M8000007",
    "210305904710M3000001", "210305904710M3000004", "210305904710M3000002", "210305904710M3000003",
    "210305904710M3000005", "210305904710M3000006", "210305904710M3000008", "210305904710M3000007",
    "210305904710M3000009", "210305904710M3000012", "210305904710M3000010", "210305904710M3000011",
    "210305904710M3000013", "210305904710M3000014", "210305904710M3000015", "210305904710M3000016",
    "210305904710M3000020", "210305904710M3000018", "210305904710M3000019", "210305904710M3000017",
    "210305904710M3000022", "210305904710M3000024", "210305904710M3000023", "210305904710M3000021",
    "210305904710M3000028", "210305904710M3000025", "210305904710M3000027", "210305904710M3000026",
    "210305904710M3000032", "210305904710M3000030", "210305904710M3000029", "210305904710M3000031",
    "210305904710M3000033", "210305904710M3000035", "210305904710M3000034", "210305904710M3000036",
    "210305904710M3000039", "210305904710M3000037", "210305904710M3000038", "210305904710M3000040",
    "210305904710M3000043", "210305904710M3000041", "210305904710M3000042", "210305904710M3000044",
    "210305904710M3000045", "210305904710M3000048", "210305904710M3000046", "210305904710M3000047",
    "210305904710M3000051", "210305904710M3000049", "210305904710M3000052", "210305904710M3000050",
    "210305904710M3000054", "210305904710M3000055", "210305904710M3000056", "210305904710M3000053",
    "210305904710M3000058", "210305904710M3000059", "210305904710M3000057", "210305904710M3000060",
    "210305904710M3000062", "210305904710M3000061", "210305904710M3000064", "210305904710M3000063",
    "210305904710M3000067", "210305904710M3000066", "210305904710M3000065", "210305904710M3000068",
    "210305904710M3000071", "210305904710M3000070", "210305904710M3000072", "210305904710M3000069",
    "210305904710M3000074", "210305904710M3000073", "210305904710M3000076", "210305904710M3000075",
    "210305904710M3000079", "210305904710M3000077", "210305904710M3000080", "210305904710M3000078",
    "210305904710M3000082", "210305904710M3000081", "210305904710M3000084", "210305904710M3000083",
    "210305904710M3000086", "210305904710M3000087", "210305904710M3000085", "210305904710M3000088",
    "210305904710M3000092", "210305904710M3000091", "210305904710M3000089", "210305904710M3000090",
    "210305904710M3000093", "210305904710M3000095", "210305904710M3000094", "210305904710M3000096",
    "210305904710M4000001", "210305904710M4000002", "210305904710M4000003", "210305904710M4000004",
    "210305904710M4000008", "210305904710M4000006", "210305904710M4000005", "210305904710M4000007",
    "210305904710M4000012", "210305904710M4000011", "210305904710M4000010", "210305904710M4000009",
    "210305904710M6000003", "210305904710M6000006", "210305904710M6000004", "210305904710M6000005",
    "210305904710M6000009", "210305904710M6000010", "210305904710M6000008", "210305904710M6000007",
    "210305904710M6000013", "210305904710M6000012", "210305904710M6000014", "210305904710M6000011",
    "210305904710M6000015", "210305904710M6000018", "210305904710M6000017", "210305904710M6000016",
    "210305904710M6000022", "210305904710M6000020", "210305904710M6000021", "210305904710M6000019",
    "210305904710M6000023", "210305904710M6000026", "210305904710M6000025", "210305904710M6000024",
    "210305904710M6000028", "210305904710M6000030", "210305904710M6000027", "210305904710M6000029",
    "210305904710M6000031", "210305904710M6000032", "210305904710M6000033", "210305904710M6000034",
    "210305904610L9000009", "210305904610L9000010", "210305916810LB000001", "210305916810LB000003",
    "210305916810LB000002", "210305916810LB000008", "210305916810LB000007", "210305916810LB000004",
    "210305916810LB000005", "210305916810LB000006", "210305916810M4000002", "210305916810M4000004",
    "210305916810M4000003", "210305916810M4000001", "210305917010L1000010", "210305917010L1000009",
    "210305917010L1000011", "210305917010L1000012", "210305917010L1000012", "210305917010L1000009",
    "210305917010L1000011", "210305917010L1000010", "210305917010L1000008", "210305917010L1000006",
    "210305917010L1000005", "210305917010L1000007", "210305917010L1000007", "210305917010L1000008",
    "210305917010L1000006", "210305917010L1000005", "210305917010L7000030", "210305917010L7000033",
    "210305917010L7000031", "210305917010L7000032", "210305917010L8000021", "210305917010L8000022",
    "210305917010L8000023", "210305917010L8000024", "210305917010LB000046", "210305917010LB000048",
    "210305917010LB000049", "210305917010LB000047", "210305917010M2000016", "210305917010M2000015",
    "210305917010M2000014", "210305917010M2000013", "210305917010M2000018", "210305917010M2000017",
    "210305917010M2000019", "210305917010M2000020", "210305917010M3000005", "210305917010M3000011",
    "210305917010M3000010", "210305917010M3000012", "210305917010M7000020", "210305917010M7000022",
    "210305917010M7000021", "210305917010M7000019", "210305917010M7000018", "210305917010M7000015",
    "210305917010M7000017", "210305917010M7000016", "210305917010M8000001", "210305917010M8000002",
    "210305917010M8000004", "210305917010M8000003", "210305917010M8000007", "210305917010M8000006",
    "210305917010M8000005", "210305917010M8000008", "210305917110LC000014", "210305917110LC000015",
    "210305917110LC000016", "210305917110LC000013", "210305917110M2000033", "210305917110M2000034",
    "210305917110M2000035", "210305917110M2000021", "210305917110M2000022", "210305917110M2000028",
    "210305917110M2000036", "210305917110M2000027", "210305917110M2000024", "210305917110M2000031",
    "210305917110M2000023", "210305917110M2000032", "210305917110M2000030", "210305917110M2000029",
    "210305917110M2000025", "210305917110M2000026", "210305917110M2000037", "210305917110M2000044",
    "210305917110M2000043", "210305917110M2000042", "210305917110M2000041", "210305917110M2000039",
    "210305917110M2000038", "210305917110M2000040", "210305917110M3000011", "210305917110M3000013",
    "210305917110M3000014", "210305917110M3000012", "210305917110M3000010", "210305917110M3000007",
    "210305917110M3000008", "210305917110M3000009", "210305917110M3000022", "210305917110M3000020",
    "210305917110M3000015", "210305917110M3000019", "210305917110M3000018", "210305917110M3000016",
    "210305917110M3000017", "210305917110M3000021", "210305917110M3000024", "210305917110M3000026",
    "210305917110M3000025", "210305917110M3000030", "210305917110M5000036", "210305917110M5000035",
    "210305917110M5000034", "210305917110M5000033", "210305917010M7000013", "210305917010M7000014",
    "210305916810L1000002", "210305916810L1000001", "210305916810M3000002", "210305916810M3000001",
    "210305917010LC000040", "210305917010LC000039", "210305917010M1000063", "210305917010M1000062",
    "210305917010M3000004", "210305917010M3000003", "210305917010M3000030", "210305917010M3000031",
    "210305917010M4000005", "210305917010M4000006", "210305917010M4000003", "210305917010M4000004",
    "210305917010M4000012", "210305917010M4000013", "210305917010M4000017", "210305917010M4000016",
    "210305917010M4000014", "210305917010M4000015", "210305917010M7000002", "210305917010M7000001",
    "210305917010M7000003", "210305917010M7000004", "210305917010M7000028", "210305917010M7000027",
    "210305917010M7000029", "210305917010M7000030", "210305917110M3000001", "210305917110M3000002",
    "210305917110M3000003", "210305917110M3000004", "210305923310L3000109", "210305923310L3000102",
    "210305923610KC000003", "210305923610KC000004", "210305923610KC000006", "210305923610KC000005",
    "210305923610M2000046", "210305923610M2000045", "210305923610M2000044", "210305923610M2000043",
    "210305923610M2000049", "210305923610M2000050", "210305923610M3000004", "210305923610M3000003",
    "210305923610M3000005", "210305923610M3000006", "210305923610M3000008", "210305923610M3000007",
    "210305923610M3000025", "210305923610M3000024", "210305923610M5000050", "210305923610M5000051",
    "21030592369WL4800041", "21030592369WL4800042", "21030592369WL4800048", "21030592369WL4800047",
    "21030592369WL4800051", "21030592369WL4800052", "21030592369WL5800055", "21030592369WL5800056",
    "21030592369WL5800075", "21030592369WL5800076", "21030592369WL6800007", "21030592369WL6800008",
    "21030592369WLC800042", "21030592369WLC800041", "21030592369WLC800043", "21030592369WLC800044",
    "21030592369WM1800016", "21030592369WM1800015", "21030592369WM2800028", "21030592369WM2800027",
    "21030592369WM2800038", "21030592369WM2800037", "21030592369WM2800047", "21030592369WM2800048",
    "21030592369WM3800002", "21030592369WM3800001", "21030592369WM3800007", "21030592369WM3800008",
    "21030592369WM3800009", "21030592369WM3800010", "21030592369WM3800011", "21030592369WM3800012",
    "21030592369WM3800014", "21030592369WM3800013", "21030592369WM3800016", "21030592369WM3800015",
    "21030592369WM3800017", "21030592369WM3800018", "21030592369WM3800022", "21030592369WM3800021",
    "21030592369WM3800023", "21030592369WM3800024", "21030592369WM3800025", "21030592369WM3800026",
    "21030592369WM3800027", "21030592369WM3800028", "21030592369WM3800030", "21030592369WM3800029",
    "21030592369WM3800031", "21030592369WM3800032", "21030592369WM3800034", "21030592369WM3800033",
    "21030592369WM3800035", "21030592369WM3800036", "21030592369WM3800039", "21030592369WM3800040",
    "21030592369WM3800041", "21030592369WM3800042", "21030592369WM3800043", "21030592369WM3800044",
    "21030592369WM3800045", "21030592369WM3800046", "21030592369WM3800047", "21030592369WM3800048",
    "21030592369WM3800051", "21030592369WM3800052", "21030592369WM4800009", "21030592369WM4800010",
    "21030592369WM4800015", "21030592369WM4800016", "21030592369WM4800021", "21030592369WM4800022",
    "21030592369WM4800024", "21030592369WM4800023", "21030592369WM4800025", "21030592369WM4800026",
    "21030592369WM4800028", "21030592369WM4800027", "21030592369WM4800029", "21030592369WM4800030",
    "21030592369WM4800032", "21030592369WM4800031", "21030592369WM4800033", "21030592369WM4800034",
    "21030592369WM4800035", "21030592369WM4800036", "21030592369WM4800038", "21030592369WM4800037",
    "21030592369WM4800040", "21030592369WM4800039", "21030592369WM4800041", "21030592369WM4800042",
    "21030592369WM4800043", "21030592369WM4800044", "21030592369WM4800052", "21030592369WM4800051",
    "21030592369WM4800054", "21030592369WM4800053", "21030592369WM4800063", "21030592369WM4800064",
    "21030592369WM4800072", "21030592369WM4800071", "21030592369WM4800073", "21030592369WM4800074",
    "21030592369WM4800075", "21030592369WM4800076", "21030592369WM4800078", "21030592369WM4800077",
    "21030592369WM4800082", "21030592369WM4800081", "21030592369WM4800086", "21030592369WM4800085",
    "21030592369WM5800011", "21030592369WM5800012", "21030592369WM5800019", "21030592369WM5800020",
    "21030592369WM5800021", "21030592369WM5800022", "21030592369WM5800032", "21030592369WM5800031",
    "21030592369WM5800036", "21030592369WM5800035", "21030592369WM5800037", "21030592369WM5800038",
    "2103059236FSLB000053", "2103059236FSLB000054", "2103059236FSLC000086", "2103059236FSLC000084",
    "2103059236FSLC000085", "2103059236FSLC000083", "2103059236FSLC000110", "2103059236FSLC000113",
    "2103059236FSLC000130", "2103059236FSLC000129", "2103059236FSLC000131", "2103059236FSLC000132",
    "2103059236FSM6000037", "2103059236FSM6000038", "2103059236FSM6000048", "2103059236FSM6000047",
    "2103059236FSM6000046", "2103059236FSM6000045", "2103059236FSM6000049", "2103059236FSM6000050",
    "2103059236FSM6000056", "2103059236FSM6000055", "2103059236FSM6000067", "2103059236FSM6000068",
    "210305923610L2000001", "210305923610L3000088", "210305923610L3000089", "210305923610L2000002",
    "210305923610L8000075", "210305923610L8000095", "210305923610L9000036", "210305923610L9000033",
    "210305923610L8000031", "210305923610L8000032", "210305923610LA000050", "210305923610LA000052",
    "210305923610LA000051", "210305923610LA000063", "210305923610LA000053", "210305923610LA000062",
    "210305923610M1000069", "210305923610M1000059", "210305923610M1000179", "210305923610M1000183",
    "210305923610M1000176", "210305923610M1000181", "210305923610M1000177", "210305923610M1000057",
    "210305923610M1000182", "210305923610M1000180", "210305923610M1000178", "210305923610M1000194",
    "210305923610M1000185", "210305923610M1000175", "210305923610M1000157", "210305923610M1000173",
    "210305923610M1000172", "210305923610M1000005", "210305923610M1000097", "210305923610M1000195",
    "210305923610M1000158", "210305923610M1000159", "210305923610M1000199", "210305923610M1000193",
    "210305923610M1000192", "210305923610M1000202", "210305923610M1000197", "210305923610M1000198",
    "210305923610M1000206", "210305923610M1000200", "210305923610M1000205", "210305923610M1000204",
    "210305923610M1000104", "210305923610M1000110", "210305923610M1000106", "210305923610M1000113",
    "210305923610LC000010", "210305923610LC000013", "210305923610M1000190", "210305923610M1000015",
    "210305923610M1000007", "210305923610M1000006", "210305923610M1000012", "210305923610M1000023",
    "210305923610M1000066", "210305923610M1000026", "210305923610M1000036", "210305923610M1000014",
    "210305923610M1000030", "210305923610M1000009", "210305923610M1000008", "210305923610M1000011",
    "210305923610M1000032", "210305923610M1000019", "210305923610M1000010", "210305923610M1000017",
    "210305923610M1000094", "210305923610M1000085", "210305923610M1000076", "210305923610M1000084",
    "210305923610M5000032", "210305923610M5000008", "210305923610M4000010", "210305923610M4000008",
    "210305923610M7000002", "210305923610M7000001", "210305923610M7000021", "210305923610M7000023",
    "210305923610M7000020", "210305923610M7000022", "210305878310L1000003", "210305878310L1000002",
    "210305878310L6000057", "210305878310L6000059", "210305878310M4000004", "210305878310M4000003",
    "210305878310M5000008", "210305878310M5000009", "210305878310M5000007", "210305878310M5000006",
    "210305878310M8000002", "210305878310M8000001", "210305878310M8000005", "210305878310M8000006",
    "210305878310M8000003", "210305878310M8000004", "210305878310M8000007", "210305878310M8000008",
    "2103058783FSLC000012", "2103058783FSLC000011", "2103058783FSLC000010", "2103058783FSLC000009",
    "210305896310M2000008", "210305896310M2000007", "210305896310M4000001", "210305896310M4000002",
    "210305896310M4000003", "210305896310M4000004", "210305896310M5000015", "210305896310M5000016",
    "210305896310M7000038", "210305896310M7000039", "210305896310M7000041", "210305896310M7000040",
    "210305896310M7000043", "210305896310M7000042", "2103058963FSM6000006", "2103058963FSM6000005",
    "2103058963FSM6000017", "2103058963FSM6000018", "2103058963FSM6000020", "2103058963FSM6000019",
    "2103058963FSM6000021", "2103058963FSM6000024", "2103058963FSM6000022", "2103058963FSM6000023",
    "2103058963FSM6000025", "2103058963FSM6000026", "210305920810M1000008", "210305920810M1000007",
    "210305920810M3000005", "210305920810M3000006", "210305920810M3000009", "210305920810M3000010",
    "210305920810M4000002", "210305920810M4000001", "210305920810M4000004", "210305920810M4000003",
    "2103059208FSM6000005", "2103059208FSM6000006", "2103059208FSM6000003", "2103059208FSM6000004",
    "2103059208FSM6000012", "2103059208FSM6000011", "210305921110M7000002", "210305921110M7000001",
    "210305921110M7000006", "210305921110M7000005", "2103059211FSM6000002", "2103059211FSM6000001",
    "2103059211FSM6000004", "2103059211FSM6000003", "210305920910M3000005", "210305920910M3000006",
    "210305920910M3000004", "210305920910M3000003", "210305920910M4000001", "210305920910M4000002",
    "210305920910M4000003", "210305920910M4000004", "210305920910M7000002", "210305920910M7000001",
    "210305920910M7000004", "210305920910M7000005", "2103059209FSLB000002", "2103059209FSLB000001",
    "2103059209FSLC000003", "2103059209FSLC000004", "2103059209FSM6000002", "2103059209FSM6000001",
    "2103059209FSM8000006", "2103059209FSM8000005", "2103059209FSM8000010", "2103059209FSM8000007",
    "210305878410LA000005", "210305878410LA000004", "210305878410M7000001", "210305878410M7000002",
    "210305878410M7000006", "210305878410M7000005", "210305878410M7000008", "210305878410M7000007",
    "210305878410M7000009", "210305878410M7000012", "210305878410M7000013", "210305878410M7000010",
    "210305878410M7000014", "210305878410M7000011", "210305878410M7000015", "210305878410M7000016",
    "2103058784FSM6000003", "2103058784FSM6000004", "2103058784FSM6000001", "2103058784FSM6000002",
    "2103058784FSM6000006", "2103058784FSM6000005", "2103058784FSM6000012", "2103058784FSM6000011",
    "2103058784FSM8000003", "2103058784FSM8000004", "2103058784FSM8000007", "2103058784FSM8000008",
    "2103058784FSM8000005", "2103058784FSM8000006", "210305921510L6000006", "210305921510L6000005",
    "210305921510L6000011", "210305921510L6000012", "210305921510L6000007", "210305921510L6000004",
    "210305921210M2000004", "210305921210M2000003", "210305879110M3000004", "210305879110M3000005",
    "210305879110M4000003", "210305879110M4000004", "210305879110M7000008", "210305879110M7000007",
    "210305899710M7000005", "210305899710M7000006", "210305899710M7000007", "210305899710M7000008",
    "210305899710M8000003", "210305899710M8000004", "21030589979WM3800004", "21030589979WM3800003",
    "21030589979WM3800006", "21030589979WM3800005", "21030589979WM5800013", "21030589979WM5800014",
    "21030589979WM5800015", "21030589979WM5800016", "21030589979WM5800020", "21030589979WM5800019",
    "21030589979WM5800022", "21030589979WM5800021", "2103058997FSM6000030", "2103058997FSM6000031",
    "2103058997FSM6000066", "2103058997FSM6000067", "2103058997FSM6000064", "2103058997FSM6000065",
    "2103058997FSM8000001", "2103058997FSM8000002", "210305917210M5000033", "210305917210M5000034",
    "210305917210M5000036", "210305917210M5000035", "210305917210M7000003", "210305917210M7000001",
    "210305917210M7000004", "210305917210M7000002", "210305917410M5000012", "210305917410M5000011",
    "210305917410M5000009", "210305917410M5000010", "210305917410M6000002", "210305917410M6000001",
    "210305917510M7000003", "210305917510M7000001", "210305917510M7000004", "210305917510M7000002",
    "210305909710M6000121", "210305909710M6000122", "210305909710M7000027", "210305909710M7000028",
    "210305909710M7000025", "210305909710M7000026", "210305909710M7000036", "210305909710M7000035",
    "210305909710M7000031", "210305909710M7000032", "210305909710M7000034", "210305909710M7000033",
    "210305909510LC000027", "210305909510LC000028", "210305909510LC000029", "210305909510LC000030",
    "210305909810M7000002", "210305909810M7000001", "210305909510M3000014", "210305909510M3000013",
    "210305909510M3000015", "210305909510M3000016", "210305909710M6000101", "210305909710M6000104",
    "210305909710M6000102", "210305909710M6000103", "210305909710M6000093", "210305909710M6000095",
    "210305909710M6000094", "210305909710M6000096", "210305909710M6000097", "210305909710M6000100",
    "210305909710M6000099", "210305909710M6000098", "210305909710M6000111", "210305909710M6000112",
    "210305909710M6000110", "210305909710M6000109", "210305909710M7000039", "210305909710M7000040",
    "210305909710M7000037", "210305909710M7000038", "210305909710M7000042", "210305909710M7000043",
    "210305909710M7000041", "210305909710M7000044", "210305909710M8000005", "210305909710M8000007",
    "210305909710M8000008", "210305909710M8000006", "210305909710M8000002", "210305909710M8000004",
    "210305909710M8000003", "210305909710M8000001", "210305909510M5000012", "210305909510M5000009",
    "210305909510M5000010", "210305909510M5000011", "210305909510M5000016", "210305909510M5000015",
    "210305909510M5000014", "210305909510M5000013", "210305909710M2000039", "210305909710M2000038",
    "210305909710M2000037", "210305909710M2000040", "210305909710M5000036", "210305909710M5000035",
    "210305909710M5000037", "210305909710M5000038", "210305909710M5000042", "210305909710M5000041",
    "210305909710M5000040", "210305909710M5000039", "210305909710M5000071", "210305909710M5000072",
    "210305909710M5000074", "210305909710M5000073", "210305909710L5000041", "210305909710L5000042",
    "210305909710L5000040", "210305909710L5000039", "210305909710LC000060", "210305909710LC000062",
    "210305909710LC000059", "210305909710LC000058", "210305910210M4000014", "210305910210M4000013",
    "210305910210M8000007", "210305910210M8000008", "210305910310M3000464", "210305910310M3000463",
    "210305923610M5000049", "210305923610M5000048", "210305923610M6000011", "210305923610M6000010",
    "210305923610M6000012", "210305923610M6000013", "2103050AFA10M5000009", "2103050AFA10M5000010",
    "2103050AFA10M5000012", "2103050AFA10M5000011", "2103050AFA10M5000021", "2103050AFA10M5000022",
    "2103050AFA10M5000019", "2103050AFA10M5000020", "2103050AFH10M4000004", "2103050AFH10M4000001",
    "2103050AFH10M4000003", "2103050AFH10M4000002", "2103050AFH10M6000006", "2103050AFH10M6000004",
    "2103050AFH10M6000003", "2103050AFH10M6000005", "2103050AFH10M7000008", "2103050AFH10M7000003",
    "2103050AFH10M7000006", "2103050AFH10M7000005", "2103050AFH10M7000004", "2103050AFH10M7000002",
    "2103050AFH10M7000007", "2103050AFH10M7000001", "2103050AFH10M7000019", "2103050AFH10M7000020",
    "2103050AFH10M7000018", "2103050AFH10M7000017", "2103050AYR10M3000001", "2103050AYR10M3000002",
    "2103050AYR9WM4800001", "2103050AYR9WM4800002", "2103050AYR9WM4800003", "2103050AYR9WM4800004",
    "2103050AYRFSM6000008", "2103050AYRFSM6000007", "2103050AYRFSM6000006", "2103050AYRFSM6000005",
    "2103050AYJ10M3000001", "2103050AYJ10M3000002", "2103050AYJ10M3000019", "2103050AYJ10M3000020",
    "2103050AYJ10M3000023", "2103050AYJ10M3000024", "2103050AYJ10M3000021", "2103050AYJ10M3000022",
    "2103050AYJ10M3000025", "2103050AYJ10M3000026", "2103050AYJ10M4000002", "2103050AYJ10M4000001",
    "2103050AYJ10M4000005", "2103050AYJ10M4000006", "2103050AYJ10M4000003", "2103050AYJ10M4000004",
    "2103050AYJ10M4000010", "2103050AYJ10M4000009", "2103050AYJ10M4000020", "2103050AYJ10M4000021",
    "2103050AYJ10M7000004", "2103050AYJ10M7000001", "2103050AYJ10M7000005", "2103050AYJ10M7000002",
    "2103050AYJ10M7000003", "2103050AYJ10M7000006", "2103050AYJ10M7000010", "2103050AYJ10M7000011",
    "2103050AYJ10M7000008", "2103050AYJ10M7000009", "2103050AYJ10M7000007", "2103050AYJ10M7000012",
    "2103050AYJ10M7000014", "2103050AYJ10M7000013", "2103050AYJ10M7000015", "2103050AYJ10M7000016",
    "2103050AYJ10M7000021", "2103050AYJ10M7000022", "2103050AYJ10M7000018", "2103050AYJ10M7000017",
    "2103050AYJ10M7000019", "2103050AYJ10M7000020", "2103050AYJ10M7000026", "2103050AYJ10M7000025",
    "2103050AYJ10M7000027", "2103050AYJ10M7000028", "2103050AYJ10M7000029", "2103050AYJ10M7000030",
    "2103050AYJ9WM4800001", "2103050AYJ9WM4800002", "2103050AYJ9WM5800001", "2103050AYJ9WM5800002",
    "2103050AYJ9WM5800003", "2103050AYJ9WM5800004", "2103050AYJ9WM6800002", "2103050AYJ9WM6800001",
    "2103050AYJFSM6000001", "2103050AYJFSM6000002", "2103050AYJFSM6000004", "2103050AYJFSM6000003",
    "2103050AYJFSM6000005", "2103050AYJFSM6000006", "2103050AYJFSM6000008", "2103050AYJFSM6000007",
    "2103050AYJFSM6000011", "2103050AYJFSM6000009", "2103050AYJFSM6000012", "2103050AYJFSM6000010",
    "2103050AYJ10M3000008", "2103050AYJ10M3000007", "2103050AYL10M3000014", "2103050AYL10M3000011",
    "2103050AYL10M3000012", "2103050AYL10M3000013", "2103050AYL10M5000005", "2103050AYL10M5000006",
    "2103050AYL10M6000003", "2103050AYL10M6000004", "2103050AYL10M6000005", "2103050AYL10M6000006",
    "2103050AYL10M6000008", "2103050AYL10M6000009", "2103050AYL10M7000004", "2103050AYL10M7000009",
    "2103050AYL10M7000005", "2103050AYL10M7000008", "2103050AYL10M7000006", "2103050AYL10M7000007",
    "2103050AYL10M7000010", "2103050AYL10M7000011", "2103050AYL10M7000013", "2103050AYL10M7000012",
    "2103050AYL9WM4800001", "2103050AYL9WM4800002", "2103050AYL9WM5800001", "2103050AYL9WM5800002",
    "2103050AYL9WM5800004", "2103050AYL9WM5800003", "2103050AYL9WM5800006", "2103050AYL9WM5800005",
    "2103050AYLFSM6000001", "2103050AYLFSM6000002", "2103050AYLFSM6000003", "2103050AYLFSM6000004",
    "2103050AYLFSM6000007", "2103050AYLFSM6000008", "2103050AYLFSM6000010", "2103050AYLFSM6000011",
    "2103050AYLFSM6000012", "2103050AYLFSM6000009", "2103050AYLFSM6000017", "2103050AYLFSM6000018",
    "2103050AYLFSM6000016", "2103050AYLFSM6000014", "2103050AYLFSM6000015", "2103050AYLFSM6000013",
    "2103050AYLFSM6000020", "2103050AYLFSM6000019", "2103050AYL10M2000003", "2103050AYL10M2000004",
    "2103050AYL10M2000001", "2103050AYL10M2000002", "2103050AFF10M6000001", "2103050AFF10M6000003",
    "2103050AFF10M6000004", "2103050AFF10M6000002", "2103050AFF10M6000015", "2103050AFF10M6000013",
    "2103050AFF10M6000016", "2103050AFF10M6000014", "2103050AFA10L9000006", "2103050AFA10L9000005",
    "2103050AFA10L9000008", "2103050AFA10L9000007", "2103050AFA10M4000002", "2103050AFA10M4000001",
    "2103050AFA10M4000004", "2103050AFA10M4000003", "2103050AFA10M5000013", "2103050AFA10M5000014",
    "2103050AFA10M5000015", "2103050AFA10M5000016", "2103050AFA10M5000017", "2103050AFA10M5000018",
    "2103050AFA10M6000021", "2103050AFA10M6000022", "2103050AFA10M6000024", "2103050AFA10M6000023",
    "2103050AYL10M6000013", "2103050AYL10M6000014", "210305996110M5000001", "210305996110M5000002",
    "210305996110M7000003", "210305996110M7000004", "210305996110M7000007", "210305996110M7000008",
    "210305996110M7000006", "210305996110M7000005", "210305996110M7000001", "210305996110M7000002",
    "210305996110M7000009", "210305996110M7000010", "2103059961FSM6000003", "2103059961FSM6000002",
    "2103059961FSM6000004", "2103059961FSM6000001", "2103059961FSM6000005", "2103059961FSM6000006",
    "2103059961FSM6000007", "2103059961FSM6000008", "210305996710M7000001", "210305996710M7000002",
    "210305996710M7000003", "210305996710M7000004", "2103059967FSM6000002", "2103059967FSM6000001",
    "210305996010M8000001", "210305996010M8000002", "210305996610M3000004", "210305996610M3000006",
    "210305996610M3000003", "210305996610M3000005", "210305996610M7000004", "210305996610M7000003",
    "2103050AEW10M4000009", "2103050AEW10M4000010", "2103050AEW10M6000012", "2103050AEW10M6000011",
    "2103050AEW10M5000012", "2103050AEW10M5000009", "2103050AEW10M5000011", "2103050AEW10M5000010",
    "2103050AEW10M5000013", "2103050AEW10M5000014", "2103050AEW10M5000016", "2103050AEW10M5000015",
    "2103050AEW10M5000024", "2103050AEW10M5000021", "2103050AEW10M5000023", "2103050AEW10M5000022",
    "2103050AFC10M6000012", "2103050AFC10M6000011", "2103050AFC10M6000014", "2103050AFC10M6000013",
    "2103050AFC10M4000029", "2103050AFC10M4000028", "2103050AFC10M5000007", "2103050AFC10M5000006",
    "2103050AFD10M4000021", "2103050AFD10M4000022", "2103050AFD10M4000024", "2103050AFD10M4000023",
    "2103050AFD10M6000005", "2103050AFD10M6000011", "2103050AFD10M6000007", "2103050AFD10M6000009",
    "2103050AFD10M6000012", "2103050AFD10M6000006", "2103050AFD10M6000010", "2103050AFD10M6000008",
    "2103050AFD10M6000022", "2103050AFD10M6000021", "2103050AFD10M6000024", "2103050AFD10M6000023",
    "2103050AFD10M6000031", "2103050AFD10M6000032", "2103050AFD10M8000022", "2103050AFD10M8000021",
    "2103050AFD10M6000013", "2103050AFD10M6000014", "2103050AFD10M6000034", "2103050AFD10M6000033",
    "2103050AFD10M6000035", "2103050AFD10M6000036", "2103050AFD10M6000038", "2103050AFD10M6000037",
    "2103050AFD10M6000039", "2103050AFD10M6000040", "2103050AFD10M6000044", "2103050AFD10M6000043",
    "2103050AFD10M6000045", "2103050AFD10M6000046", "2103050AFD10M6000051", "2103050AFD10M6000052",
    "2103050AFD10M6000054", "2103050AFD10M6000053", "2103050AFD10M6000070", "2103050AFD10M6000069",
    "2103050AFD10M6000071", "2103050AFD10M6000072", "2103050AFD10M6000075", "2103050AFD10M6000076",
    "2103050AFD10M6000074", "2103050AFD10M6000073", "2103050AFD10M7000010", "2103050AFD10M7000009",
    "2103050AFD10M5000028", "2103050AFD10M5000027", "2103050AFD10M5000030", "2103050AFD10M5000029",
    "2103050AFD10M5000031", "2103050AFD10M5000032", "2103050AFD10M5000033", "2103050AFD10M5000034",
    "2103050AFD10M5000035", "2103050AFD10M5000036", "2103050AFD10M5000037", "2103050AFD10M5000038",
    "2103050AFD10M5000041", "2103050AFD10M5000042", "2103050AFD10M5000039", "2103050AFD10M5000040",
    "2103050AFD10M5000044", "2103050AFD10M5000045", "2103050AFD10M5000046", "2103050AFD10M5000043",
    "2103050AFD10M5000052", "2103050AFD10M5000047", "2103050AFD10M5000054", "2103050AFD10M5000048",
    "2103050AFD10M5000050", "2103050AFD10M5000049", "2103050AFD10M5000053", "2103050AFD10M5000051",
    "2103050AFD10M5000056", "2103050AFD10M5000057", "2103050AFD10M5000055", "2103050AFD10M5000058",
    "2103050AFD10M5000066", "2103050AFD10M5000063", "2103050AFD10M5000064", "2103050AFD10M5000065",
    "2103050AFD10M5000059", "2103050AFD10M5000061", "2103050AFD10M5000062", "2103050AFD10M5000060",
    "2103050AFD10M6000015", "2103050AFD10M6000016", "2103050AFD10M6000018", "2103050AFD10M6000017",
    "2103050AFD10M7000002", "2103050AFD10M7000004", "2103050AFD10M7000003", "2103050AFD10M7000001",
    "2103050AFE10M6000009", "2103050AFE10M6000007", "2103050AFE10M6000010", "2103050AFE10M6000008",
    "2103050AFE10M6000011", "2103050AFE10M6000014", "2103050AFE10M6000012", "2103050AFE10M6000013",
    "2103050AFE10M6000018", "2103050AFE10M6000017", "2103050AFE10M6000015", "2103050AFE10M6000016",
    "2103050AFE10M6000020", "2103050AFE10M6000019", "2103050AFE10M6000021", "2103050AFE10M6000022",
    "2103050AFE10M8000003", "2103050AFE10M8000001", "2103050AFE10M8000004", "2103050AFE10M8000002",
    "2103050AFD10M6000060", "2103050AFD10M6000057", "2103050AFD10M6000058", "2103050AFD10M6000059",
    "2103050AFD10M6000063", "2103050AFD10M6000061", "2103050AFD10M6000062", "2103050AFD10M6000064",
    "2103050AFD10M6000065", "2103050AFD10M6000067", "2103050AFD10M6000066", "2103050AFD10M6000068",
    "2103050BBV10M2000002", "2103050BBV10M2000003", "2103050BBV10M2000004", "2103050BBV10M2000001",
    "2103050BBV10M7000014", "2103050BBV10M7000013", "2103050BBV10M7000012", "2103050BBV10M7000011",
    "2103050BBV9WM3800001", "2103050BBV9WM3800002", "2103050BBVFSLB000003", "2103050BBVFSLB000004",
    "2103050BBVFSLB000001", "2103050BBVFSLB000002", "2103050BBVFSM8000001", "2103050BBVFSM8000002",
    "2103050BBV10M4000009", "2103050BBV10M4000008", "2103050BBV10M4000010", "2103050BBV10M4000007",
    "2103050BBV10M4000013", "2103050BBV10M4000012", "2103050BBV10M4000014", "2103050BBV10M4000011",
    "2103050BGN10M2000033", "2103050BGN10M2000034", "2103050BGN10M3000002", "2103050BGN10M3000001",
    "2103050BGN10M4000006", "2103050BGN10M4000005", "2103050BGN10M5000010", "2103050BGN10M5000011",
    "2103050BGN10M7000001", "2103050BGN10M7000002", "2103050BGN10M7000006", "2103050BGN10M7000005",
    "2103050BGN10M7000004", "2103050BGN10M7000003", "2103050BGN10M7000041", "2103050BGN10M7000040",
    "2103050BGN10M7000059", "2103050BGN10M7000058", "2103050BGN10M8000004", "2103050BGN10M8000003",
    "2103050BGN9WM3800001", "2103050BGN9WM3800002", "2103050BGN9WM3800004", "2103050BGN9WM3800003",
    "2103050BGN9WM4800001", "2103050BGN9WM4800002", "2103050BGN9WM4800003", "2103050BGN9WM4800004",
    "2103050BGN9WM4800006", "2103050BGN9WM4800005", "2103050BGN9WM4800007", "2103050BGN9WM4800008",
    "2103050BGN9WM5800001", "2103050BGN9WM5800002", "2103050BGN9WM5800003", "2103050BGN9WM5800004",
    "2103050BGN9WM5800006", "2103050BGN9WM5800005", "2103050BGN9WM5800007", "2103050BGN9WM5800008",
    "2103050BGNFSM5000002", "2103050BGNFSM5000001", "2103050BGNFSM5000004", "2103050BGNFSM5000005",
    "2103050BGNFSM5000006", "2103050BGNFSM5000003", "2103050BGNFSM5000008", "2103050BGNFSM5000007",
    "2103050BGNFSM6000002", "2103050BGNFSM6000001", "2103050BGNFSM6000004", "2103050BGNFSM6000003",
    "2103050BGNFSM6000006", "2103050BGNFSM6000005", "2103050BGN10M2000028", "2103050BGN10M2000030",
    "2103050BGN10M2000031", "2103050BGN10M2000032", "2103050BGN10M2000025", "2103050BGN10M2000029",
    "2103050BGN10M2000026", "2103050BGN10M2000027", "2103050BGN10M2000015", "2103050BGN10M2000014",
    "2103050BGN10M2000016", "2103050BGN10M2000009", "2103050BGN10M2000010", "2103050BGN10M2000011",
    "2103050BGN10M2000012", "2103050BGN10M2000013", "2103050BGN10M2000020", "2103050BGN10M2000024",
    "2103050BGN10M2000022", "2103050BGN10M2000017", "2103050BGN10M6000010", "2103050BGN10M6000009",
    "2103050BGN10M2000021", "2103050BGN10M2000018", "2103050BGN10M2000019", "2103050BGN10M2000023",
    "2103050BGN10M2000036", "2103050BGN10M2000041", "2103050BGN10M2000035", "2103050BGN10M2000037",
    "2103050BGN10M2000040", "2103050BGN10M2000042", "2103050BGN10M2000039", "2103050BGN10M2000038",
    "2103050BGN10M2000008", "2103050BGN10M2000001", "2103050BGN10M2000002", "2103050BGN10M2000006",
    "2103050BGN10M2000004", "2103050BGN10M2000005", "2103050BGN10M6000002", "2103050BGN10M2000007",
    "2103050BGN10M2000003", "2103050BGN10M6000004", "2103050BGN10M7000014", "2103050BGN10M7000013",
    "2103050BGN10M7000010", "2103050BGN10M7000012", "2103050BGN10M7000011", "2103050BGN10M7000007",
    "2103050BGN10M7000008", "2103050BGN10M7000009", "2103050BGN10M6000006", "2103050BGN10M6000001",
    "2103050BGN10M7000047", "2103050BGN10M6000003", "2103050BGN10M7000046", "2103050BGN10M7000043",
    "2103050BGN10M7000042", "2103050BGN10M7000044", "2103050AYR10M6000002", "2103050AYR10M6000001",
    "2103050AYR10M6000003", "2103050AYR10M6000004", "2103050AYR10M7000001", "2103050AYR10M7000002",
    "2103050AYT10M1000003", "2103050AYT10M1000004", "2103050CCJ10M2000003", "2103050CCJ10M2000004",
    "2103050CCJ10M3000019", "2103050CCJ10M3000018", "2103050CCJ10M3000020", "2103050CCJ10M3000017",
    "2103050CCJ10M3000022", "2103050CCJ10M3000021", "2103050CCJ10M3000028", "2103050CCJ10M3000027",
    "2103050CCJ10M3000038", "2103050CCJ10M3000037", "2103050CCJ10M3000041", "2103050CCJ10M3000042",
    "2103050CCJ10M3000039", "2103050CCJ10M3000040", "2103050CCJ10M4000020", "2103050CCJ10M4000019",
    "2103050CCJ10M4000026", "2103050CCJ10M4000025", "2103050CCJ10M4000021", "2103050CCJ10M4000022",
    "2103050CCJ10M4000023", "2103050CCJ10M4000024", "2103050CCJ10M4000027", "2103050CCJ10M4000028",
    "2103050CCJ10M5000001", "2103050CCJ10M5000002", "2103050CCJ10M5000011", "2103050CCJ10M5000012",
    "2103050CCJ10M5000014", "2103050CCJ10M5000015", "2103050CCJ10M6000014", "2103050CCJ10M6000013",
    "2103050CCJ10M7000010", "2103050CCJ10M7000007", "2103050CCJ10M7000008", "2103050CCJ10M7000012",
    "2103050CCJ10M7000022", "2103050CCJ10M7000021", "2103050CCJ10M7000033", "2103050CCJ10M7000034",
    "2103050CCJ10M7000043", "2103050CCJ10M7000044", "2103050CCJ10M7000065", "2103050CCJ10M7000066",
    "2103050CCJ10M7000071", "2103050CCJ10M7000072", "2103050CCJ10M7000070", "2103050CCJ10M7000069",
    "2103050CCJ10M7000067", "2103050CCJ10M7000068", "2103050CCJ10M7000079", "2103050CCJ10M7000074",
    "2103050CCJ10M7000075", "2103050CCJ10M7000077", "2103050CCJ10M7000073", "2103050CCJ10M7000078",
    "2103050CCJ10M7000076", "2103050CCJ10M7000080", "2103050CCJ10M7000081", "2103050CCJ10M7000086",
    "2103050CCJ10M7000087", "2103050CCJ10M7000088", "2103050CCJ10M7000085", "2103050CCJ10M7000082",
    "2103050CCJ10M7000084", "2103050CCJ10M7000083", "2103050CCJ10M7000097", "2103050CCJ10M7000098",
    "2103050CCJ10M7000143", "2103050CCJ10M7000142", "2103050CCJ10M7000145", "2103050CCJ10M7000141",
    "2103050CCJ10M7000144", "2103050CCJ10M7000140", "2103050CCJ10M7000170", "2103050CCJ10M7000171",
    "2103050CCJ10M7000172", "2103050CCJ10M7000173", "2103050CCJ10M7000198", "2103050CCJ10M7000199",
    "2103050CCJ10M7000203", "2103050CCJ10M7000202", "2103050CCJ10M8000006", "2103050CCJ10M8000007",
    "2103050CCJ10M8000008", "2103050CCJ10M8000009", "2103050CCJ10M8000036", "2103050CCJ10M8000037",
    "2103050CCJ10M8000039", "2103050CCJ10M8000038", "2103050CCJ10M8000034", "2103050CCJ10M8000035",
    "2103050CCJ9WM3800001", "2103050CCJ9WM3800002", "2103050CCJ9WM3800004", "2103050CCJ9WM3800003",
    "2103050CCJ9WM3800006", "2103050CCJ9WM3800005", "2103050CCJ9WM3800007", "2103050CCJ9WM3800008",
    "2103050CCJ9WM3800009", "2103050CCJ9WM3800010", "2103050CCJ9WM3800011", "2103050CCJ9WM3800012",
    "2103050CCJ9WM4800001", "2103050CCJ9WM4800002", "2103050CCJ9WM4800003", "2103050CCJ9WM4800004",
    "2103050CCJ9WM4800005", "2103050CCJ9WM4800006", "2103050CCJ9WM4800007", "2103050CCJ9WM4800008",
    "2103050CCJ9WM4800010", "2103050CCJ9WM4800009", "2103050CCJ9WM4800012", "2103050CCJ9WM4800011",
    "2103050CCJ9WM4800014", "2103050CCJ9WM4800013", "2103050CCJ9WM4800016", "2103050CCJ9WM4800015",
    "2103050CCJ9WM4800018", "2103050CCJ9WM4800017", "2103050CCJ9WM4800020", "2103050CCJ9WM4800019",
    "2103050CCJ9WM4800022", "2103050CCJ9WM4800021", "2103050CCJ9WM4800023", "2103050CCJ9WM4800024",
    "2103050CCJ9WM4800026", "2103050CCJ9WM4800025", "2103050CCJ9WM4800027", "2103050CCJ9WM4800028",
    "2103050CCJ9WM4800029", "2103050CCJ9WM4800030", "2103050CCJ9WM4800031", "2103050CCJ9WM4800032",
    "2103050CCJ9WM4800033", "2103050CCJ9WM4800034", "2103050CCJ9WM4800035", "2103050CCJ9WM4800036",
    "2103050CCJ9WM4800037", "2103050CCJ9WM4800038", "2103050CCJ9WM4800039", "2103050CCJ9WM4800040",
    "2103050CCJ9WM4800042", "2103050CCJ9WM4800041", "2103050CCJ9WM4800044", "2103050CCJ9WM4800043",
    "2103050CCJ9WM4800046", "2103050CCJ9WM4800045", "2103050CCJ9WM4800047", "2103050CCJ9WM4800048",
    "2103050CCJ9WM4800049", "2103050CCJ9WM4800050", "2103050CCJ9WM4800051", "2103050CCJ9WM4800052",
    "2103050CCJ9WM4800054", "2103050CCJ9WM4800053", "2103050CCJ9WM4800056", "2103050CCJ9WM4800055",
    "2103050CCJ9WM4800057", "2103050CCJ9WM4800058", "2103050CCJ9WM4800059", "2103050CCJ9WM4800060",
    "2103050CCJ9WM4800062", "2103050CCJ9WM4800061", "2103050CCJ9WM4800064", "2103050CCJ9WM4800063",
    "2103050CCJ9WM4800065", "2103050CCJ9WM4800066", "2103050CCJ9WM4800067", "2103050CCJ9WM4800068",
    "2103050CCJ9WM4800069", "2103050CCJ9WM4800070", "2103050CCJ9WM4800071", "2103050CCJ9WM4800072",
    "2103050CCJ9WM5800001", "2103050CCJ9WM5800002", "2103050CCJ9WM5800004", "2103050CCJ9WM5800003",
    "2103050CCJ9WM5800006", "2103050CCJ9WM5800005", "2103050CCJ9WM5800009", "2103050CCJ9WM5800010",
    "2103050CCJ9WM5800012", "2103050CCJ9WM5800011", "2103050CCJ9WM5800013", "2103050CCJ9WM5800014",
    "2103050CCJ9WM5800016", "2103050CCJ9WM5800015", "2103050CCJ9WM5800018", "2103050CCJ9WM5800017",
    "2103050CCJ9WM5800020", "2103050CCJ9WM5800019", "2103050CCJ9WM5800022", "2103050CCJ9WM5800021",
    "2103050CCJ9WM5800023", "2103050CCJ9WM5800024", "2103050CCJ9WM5800026", "2103050CCJ9WM5800025",
    "2103050CCJ9WM5800027", "2103050CCJ9WM5800028", "2103050CCJFSM6000001", "2103050CCJFSM6000002",
    "2103050CCJFSM6000003", "2103050CCJFSM6000006", "2103050CCJFSM6000005", "2103050CCJFSM6000004",
    "2103050CCJFSM6000007", "2103050CCJFSM6000008", "2103050CCJFSM6000010", "2103050CCJFSM6000009",
    "2103050CCJFSM6000015", "2103050CCJFSM6000014", "2103050CCJFSM6000012", "2103050CCJFSM6000013",
    "2103050CCJFSM6000011", "2103050CCJFSM6000018", "2103050CCJFSM6000017", "2103050CCJFSM6000016",
    "2103050CCJFSM6000019", "2103050CCJFSM6000020", "2103050CCJFSM6000021", "2103050CCJFSM6000022",
    "2103050CCJFSM6000025", "2103050CCJFSM6000026", "2103050CCJFSM6000024", "2103050CCJFSM6000023",
    "2103050CCJFSM6000027", "2103050CCJFSM6000028", "2103050CCJFSM6000030", "2103050CCJFSM6000031",
    "2103050CCJFSM6000029", "2103050CCJFSM6000032", "2103050CCJFSM6000033", "2103050CCJFSM6000034",
    "2103050CCJFSM6000036", "2103050CCJFSM6000035", "2103050CCJ10M1000001", "2103050CCJ10M1000002",
    "2103050CCJ10M3000003", "2103050CCJ10M3000004", "2103050CCJ10M3000005", "2103050CCJ10M3000006",
    "2103050CCJ10M3000007", "2103050CCJ10M3000002", "2103050CCJ10M3000001", "2103050CCJ10M3000008",
    "2103050CCJ10M3000014", "2103050CCJ10M3000013", "2103050CCJ10M3000012", "2103050CCJ10M3000011",
    "2103050CCJ10M3000032", "2103050CCJ10M3000031", "2103050CCJ10M3000033", "2103050CCJ10M3000029",
    "2103050CCJ10M3000036", "2103050CCJ10M3000030", "2103050CCJ10M3000024", "2103050CCJ10M3000015",
    "2103050CCJ10M3000025", "2103050CCJ10M3000016", "2103050CCJ10M3000026", "2103050CCJ10M3000023",
    "2103050CCJ10M4000005", "2103050CCJ10M4000007", "2103050CCJ10M4000008", "2103050CCJ10M4000011",
    "2103050CCJ10M4000010", "2103050CCJ10M4000014", "2103050CCJ10M4000013", "2103050CCJ10M4000006",
    "2103050CCJ10M4000012", "2103050CCJ10M4000004", "2103050CCJ10M3000035", "2103050CCJ10M3000034",
    "2103050CCJ10M5000016", "2103050CCJ10M5000018", "2103050CCJ10M6000007", "2103050CCJ10M5000019",
    "2103050CCJ10M6000005", "2103050CCJ10M6000006", "2103050CCJ10M6000004", "2103050CCJ10M6000008",
    "2103050CCJ10M6000012", "2103050CCJ10M6000002", "2103050CCJ10M6000003", "2103050CCJ10M6000025",
    "2103050CCJ10M6000001", "2103050CCJ10M6000015", "2103050CCJ10M6000031", "2103050CCJ10M6000011",
    "2103050CCJ10M6000029", "2103050CCJ10M6000030", "2103050CCJ10M6000063", "2103050CCJ10M6000032",
    "2103050CCJ10M6000026", "2103050CCJ10M6000021", "2103050CCJ10M6000010", "2103050CCJ10M6000020",
    "2103050CCJ10M6000061", "2103050CCJ10M6000065", "2103050CCJ10M6000062", "2103050CCJ10M6000068",
    "2103050CCJ10M6000027", "2103050CCJ10M6000058", "2103050CCJ10M6000018", "2103050CCJ10M6000009",
    "2103050CCJ10M6000017", "2103050CCJ10M6000022", "2103050CCJ10M6000028", "2103050CCJ10M6000019",
    "2103050CCJ10M6000060", "2103050CCJ10M6000059", "2103050CCJ10M6000067", "2103050CCJ10M6000066",
    "2103050CCJ10M6000057", "2103050CCJ10M6000064", "2103050CCJ10M6000073", "2103050CCJ10M6000074",
    "2103050CCJ10M7000003", "2103050CCJ10M7000013", "2103050CCJ10M7000004", "2103050CCJ10M7000014",
    "2103050CCJ10M6000091", "2103050CCJ10M7000002", "2103050CCJ10M7000001", "2103050CCJ10M6000090",
    "2103050CCJ10M6000016", "2103050CCJ10M6000092", "2103050CCJ10M6000070", "2103050CCJ10M6000093",
    "2103050CCJ10M6000034", "2103050CCJ10M6000037", "2103050CCJ10M6000038", "2103050CCJ10M6000036",
    "2103050CCJ10M6000033", "2103050CCJ10M6000041", "2103050CCJ10M6000035", "2103050CCJ10M6000043",
    "2103050CCJ10M7000015", "2103050CCJ10M6000039", "2103050CCJ10M7000019", "2103050CCJ10M6000069",
    "2103050CCJ10M7000017", "2103050CCJ10M6000044", "2103050CCJ10M6000042", "2103050CCJ10M6000040",
    "2103050CCJ10M7000018", "2103050CCJ10M7000016", "2103050CCJ10M7000036", "2103050CCJ10M7000026",
    "2103050CCJ10M7000042", "2103050CCJ10M7000027", "2103050CCJ10M7000045", "2103050CCJ10M7000041",
    "2103050CCJ10M7000038", "2103050CCJ10M7000030", "2103050CCJ10M7000040", "2103050CCJ10M7000037",
    "2103050CCJ10M7000035", "2103050CCJ10M7000028", "2103050CCJ10M7000029", "2103050CCJ10M7000025",
    "2103050CCJ10M7000023", "2103050CCJ10M7000046", "2103050CCJ10M6000050", "2103050CCJ10M6000047",
    "2103050CCJ10M6000046", "2103050CCJ10M6000045", "2103050CCJ10M6000048", "2103050CCJ10M6000049",
    "2103050CCJ10M7000056", "2103050CCJ10M7000055", "2103050CCJ10M7000054", "2103050CCJ10M7000052",
    "2103050CCJ10M7000057", "2103050CCJ10M7000053", "2103050CCJ10M7000039", "2103050CCJ10M7000020",
    "2103050CCJ10M7000092", "2103050CCJ10M7000093", "2103050CCJ10M7000089", "2103050CCJ10M7000115",
    "2103050CCJ10M7000094", "2103050CCJ10M7000110", "2103050CCJ10M7000062", "2103050CCJ10M7000047",
    "2103050CCJ10M7000059", "2103050CCJ10M7000111", "2103050CCJ10M7000095", "2103050CCJ10M7000096",
    "2103050CCJ10M7000058", "2103050CCJ10M7000112", "2103050CCJ10M7000061", "2103050CCJ10M7000048",
    "2103050CCJ10M7000060", "2103050CCJ10M7000024", "2103050CCJ10M6000080", "2103050CCJ10M6000081",
    "2103050CCJ10M6000077", "2103050CCJ10M6000079", "2103050CCJ10M6000078", "2103050CCJ10M6000076",
    "2103050CCJ10M7000184", "2103050CCJ10M7000181", "2103050CCJ10M7000194", "2103050CCJ10M7000109",
    "2103050CCJ10M7000165", "2103050CCJ10M7000160", "2103050CCJ10M7000091", "2103050CCJ10M7000051",
    "2103050CCJ10M7000196", "2103050CCJ10M7000178", "2103050CCJ10M7000193", "2103050CCJ10M7000158",
    "2103050CCJ10M7000192", "2103050CCJ10M7000177", "2103050BVJ10M6000001", "2103050BVJ10M6000002",
    "2103050BVJ10M6000004", "2103050BVJ10M6000003", "2103050BVJ10M6000006", "2103050BVJ10M6000005",
    "2103050BVJ10M7000002", "2103050BVJ10M7000001", "2103050BVJ10M7000003", "2103050BVJ10M7000004",
    "2103050BVJFSM6000002", "2103050BVJFSM6000001", "2103050BVJFSM6000003", "2103050BVJFSM6000004",
    "2103050BVJFSM6000005", "2103050BVJFSM6000006", "2103050BVJFSM6000008", "2103050BVJFSM6000007",
    "2103050CCK10M4000008", "2103050CCK10M4000007", "2103050CCK10M4000009", "2103050CCK10M4000011",
    "2103050CCK10M4000012", "2103050CCK10M4000010", "2103050CCK10M5000002", "2103050CCK10M5000003",
    "2103050CCK9WM3800001", "2103050CCK9WM3800002", "2103050CCK9WM4800002", "2103050CCK9WM4800001",
    "2103050CCK9WM4800003", "2103050CCK9WM4800004", "2103050CCK9WM4800006", "2103050CCK9WM4800005",
    "2103050CCK9WM4800008", "2103050CCK9WM4800007", "2103050CCK9WM4800009", "2103050CCK9WM4800010",
    "2103050CCK9WM4800011", "2103050CCK9WM4800012", "2103050CCK9WM4800014", "2103050CCK9WM4800013",
    "2103050CCK9WM4800016", "2103050CCK9WM4800015", "2103050CCK9WM4800018", "2103050CCK9WM4800017",
    "2103050CCK9WM4800019", "2103050CCK9WM4800020", "2103050CCK9WM5800002", "2103050CCK9WM5800001",
    "2103050CCK9WM5800003", "2103050CCK9WM5800004", "2103050CCKFSM6000002", "2103050CCKFSM6000001",
    "2103050CCKFSM6000003", "2103050CCKFSM6000005", "2103050CCKFSM6000007", "2103050CCKFSM6000008",
    "2103050CCKFSM6000006", "2103050CCKFSM6000004", "2103050CCKFSM6000010", "2103050CCKFSM6000009",
    "2103050CCKFSM6000011", "2103050CCKFSM6000012", "2103050CCKFSM6000013", "2103050CCKFSM6000014",
    "2103050CCK10M3000009", "2103050CCK10M3000007", "2103050CCK10M3000008", "2103050CCK10M3000010",
    "2103050CCK10M3000018", "2103050CCK10M3000011", "2103050CCK10M3000019", "2103050CCK10M3000017",
    "2103050CCK10M3000020", "2103050CCK10M3000005", "2103050CCK10M3000023", "2103050CCK10M3000012",
    "2103050CCK10M3000014", "2103050CCK10M3000013", "2103050CCK10M3000016", "2103050CCK10M3000021",
    "2103050CCK10M3000006", "2103050CCK10M3000022", "2103050BBV10M6000006", "2103050BBV10M6000012",
    "2103050BBV10M6000005", "2103050BBV10M6000007", "2103050BBV10M6000013", "2103050BBV10M6000014",
    "2103050BBV10M6000009", "2103050BBV10M6000010", "2103050BBV10M7000009", "2103050BBV10M7000010",
]

# 系统盘盘符为/dev/sda, 或者/dev/sda + /dev/sdb
SYS_DISK_LIST = ['/dev/sda', '/dev/sdb']

# 系统盘厂商列表及SMART解析项
VENDOR_MAP = {
    "GG51T032S3IN4SS": {"LIFE": "232", "POH": "9"},
    "MC619GXCFCD3S": {"LIFE": "231", "POH": "9"},
    "MC619GXCFCD4S": {"LIFE": "231", "POH": "9"},
    "MC659GXAFCD4T": {"LIFE": "231", "POH": "9"},
    "MC619GXAFCD4T": {"LIFE": "231", "POH": "9"},
    "MC659GXBFCD3T": {"LIFE": "231", "POH": "9"},
    "MC659GXBFCD4T": {"LIFE": "231", "POH": "9"},
    "ME619GXCFCD4T": {"LIFE": "231", "POH": "9"},
    "MD619GXBFCD4S": {"LIFE": "231", "POH": "9"},
    "ME619DXFMDE6TF": {"LIFE": "232", "POH": "9"},
    "MD619HXCHDE3TC": {"LIFE": "232", "POH": "9"}
}

NO_PASS_STANDARD = 16000
LIFERANGE = (0, 100)
THREHOLD = 4500
LIFEHOLD = 11

# Dorado产品
PRODUCT_DORADO_V6 = [
    "OceanStor Dorado 3000 V6", "OceanStor Dorado 5300 V6", "OceanStor Dorado 5500 V6",
    "OceanStor Dorado 5600 V6", "OceanStor Dorado 5000 V6", "OceanStor Dorado 6000 V6", "OceanStor Dorado 2020",
    "OceanStor Dorado 8000 V6", "OceanStor Dorado 18000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 2100",
    "OceanStor Dorado 6800 V6", "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6",
    "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000",
    "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500",
    "OceanStor Dorado 5600", "OceanStor Dorado 6800", "OceanStor Dorado 18500",
    "OceanStor Dorado 18800"
]

# 新融合
PRODUCT_HYBRID_V6 = [
    "OceanStor 5310", "OceanStor 5510", "OceanStor 5510S", "OceanStor 5610",
    "OceanStor 6810", "OceanStor 18510", "OceanStor 18500K", "OceanStor 5310 Capacity Flash",
    "OceanStor 18810", "OceanStor 5810-HS", "OceanStor 5320", "OceanStor 5510 Capacity Flash",
    "OceanStor 5300K", "OceanStor 5500K", "OceanStor 2200", "OceanStor 2220", "OceanStor 5120",
    "OceanStor 2600", "OceanStor 2620", "OceanStor 5210", "OceanStor 5220"
]

# 高端
PRODUCT_DORADO_V6_K = [
    "OceanStor Dorado 5600K V6", "OceanStor Dorado 18800K V6", "OceanStor Dorado 5600K", "OceanStor Dorado 18800K"
]


def execute_cmd(cmd):
    cmd_fd = os.popen(cmd)
    data = cmd_fd.read().strip()
    cmd_fd.close()
    return data


def cli(command):
    sub_cmds = command.split(" | ")
    process = None
    for sub_cmd in sub_cmds:
        if process:
            process = subprocess.Popen(shlex.split(sub_cmd.strip()), stdin=process.stdout, stdout=subprocess.PIPE)
        else:
            process = subprocess.Popen(shlex.split(sub_cmd.strip()), stdout=subprocess.PIPE)
    out = process.communicate()
    return out[0].decode("utf-8")


def get_user_name():
    try:
        pwd.getpwnam('admin')
        return 'admin'
    except Exception as exp:
        logging.warning("not find admin: %s", exp)
        output = cli(USER_CMD)
        if not output:
            logging.error('Get user failed')
            return ''
        return output.strip().split(':')[0]


def get_drive_smart(sys_letter, vendor):
    if not vendor:
        return 0
    poh_info = ""
    life_info = ""
    cmd_smart = "sudo sh /OSM/script/disk_repair.sh -f a {}".format(sys_letter)
    smart_result = execute_cmd(cmd_smart)
    smart_res = []
    for line in smart_result.splitlines():
        smart_res.append(line)
    for smart_info in smart_res:
        reg1 = r"^\s+{}\s+.*".format(VENDOR_MAP.get(vendor).get("POH"))
        poh_info = re.match(reg1, smart_info)
        if poh_info:
            break
    for smart_info in smart_res:
        reg2 = r"^{}\s+.*".format(VENDOR_MAP.get(vendor).get("LIFE"))
        life_info = re.match(reg2, smart_info)
        if life_info:
            break
    if poh_info and life_info:
        poh = int(poh_info.group().split()[-1])
        life = int(life_info.group().split()[-1])
        if life != LIFERANGE[1]:
            return judge_drive_smart(life, poh)
    return 0


def judge_drive_smart(life, poh):
    flag = 0
    if judge_drive_smart_exception(life):
        flag = 0
        return flag
    if poh > THREHOLD:
        all_life = int(poh + life * poh / (100 - life))
        if all_life < NO_PASS_STANDARD:
            flag = 1
    else:
        if 100 - life > LIFEHOLD:
            all_life = int(poh + life * poh / (100 - life - LIFEHOLD))
            if all_life < NO_PASS_STANDARD:
                flag = 1
    return flag


def judge_drive_smart_exception(life):
    if life >= AUDIT_LOG_RISK_LIFE_VALUE:
        return True
    return False


def get_drive_vendor(vendor_value):
    vendor_info = ""
    for vendor_key in VENDOR_MAP:
        if vendor_key == vendor_value:
            vendor_info = vendor_key
            break
    return vendor_info


def check_disk_smart():
    disk_cmd_str = "sudo sh /OSM/script/disk_repair.sh -s |grep -E '/dev/sda|/dev/sdb'"
    disk_info_list = execute_cmd(disk_cmd_str)
    # 没有则不查询 跳过
    if not disk_info_list:
        return 0
    disk_info = {}  # {"/dev/sda":"ME619DXFMDE6TF", "/dev/sdb":"ME619DXFMDE6TF"}
    for line in disk_info_list.splitlines():
        fields = " ".join(line.split()).split(" ")
        dict_key = fields[0].strip()
        dict_value = fields[-2].strip()
        disk_info[dict_key] = dict_value
    for sys_letter in SYS_DISK_LIST:
        for key, value in disk_info.items():
            if sys_letter == key:
                vendor = get_drive_vendor(value)
                return get_drive_smart(sys_letter, vendor)
    return 0


def get_ctrl_id_by_node_id(node_id, one_engine_ctrl_num):
    ctrl_trans_dict = {"0": "A", "1": "B", "2": "C", "3": "D"}
    node_id = int(node_id)
    ctrl_trans_index = node_id % one_engine_ctrl_num
    if ctrl_trans_index > 3:  # 引擎号最大值为3
        logging.error("get control id failed.")
        return None
    try:
        ctrl_id = str(int(node_id / one_engine_ctrl_num)) + ctrl_trans_dict[str(ctrl_trans_index)]
    except KeyError:
        return None
    return ctrl_id


def is_in_audit_log_risk_devices(node_id, node_num):
    ctrl_id = get_ctrl_id_by_node_id(node_id, node_num)
    if ctrl_id is None:
        logging.error("get control id failed.")
        return False
    cli_cmd = "show controller general controller={}".format(ctrl_id)
    cli_cmd_str = CLI_CHECK_CMD.format(get_user_name(), cli_cmd, TMP_AUTID_LOG)
    ctrl_info = os.system(cli_cmd_str)
    if ctrl_info:
        logging.error("Cmd(%s) exec failed.", cli_cmd_str)
        return False
    pattern = r'BarCode='
    ctrl_bar_code = ''
    with open(TMP_AUTID_LOG) as lines_of_file:
        lines_array = lines_of_file.readlines()
        for line in lines_array:
            if re.search(pattern, line):
                ctrl_bar_code = line.split("=")[-1]
    #  临时文件使用后删除
    shell_cmd_str = "rm " + TMP_AUTID_LOG
    os.system(shell_cmd_str)
    ctrl_bar_code = ctrl_bar_code.replace('\n', '').replace('\r', '')
    if ctrl_bar_code in AUDIT_LOG_RISK_DEVICES:
        return True
    return False


def get_product_model():
    cli_cmd_str = CLI_CHECK_CMD.format(get_user_name(), "show system general", TMP_AUTID_LOG)
    ctrl_info = os.system(cli_cmd_str)
    if ctrl_info:
        logging.error("DOWNGRADE_CHECK: Cmd(%s) exec failed.", cli_cmd_str)
        return ""
    pattern = r'Product Model'
    product_model = ''
    with open(TMP_AUTID_LOG) as lines_of_file:
        lines_array = lines_of_file.readlines()
        for line in lines_array:
            if re.search(pattern, line):
                product_model = line.split(":")[-1].strip()
                break
    #  临时文件使用后删除
    shell_cmd_str = "rm " + TMP_AUTID_LOG
    os.system(shell_cmd_str)
    return product_model


def get_engine_height_on_mini_system_model():
    bayconfig_result = execute_cmd("sudo sh /OSM/script/os_show_bay_cfg.sh")
    # 单引擎最大个数
    if not bayconfig_result:
        return 0
    line_list = bayconfig_result.splitlines()
    for line in line_list:
        if "CtrlNodeIdList" in line:
            nodes = line.split(")")[0].split(":")[-1].split(",")
            return len(nodes)
    return 0


def get_node_info():
    # 执行命令sys showcls
    diagnose_cmd_str = DIAGNOSE_CHECK_CMD.format(12, "sys showcls", TMP_AUTID_LOG)
    ret = os.system(diagnose_cmd_str)
    if ret:
        logging.error("DOWNGRADE_CHECK: Cmd(%s) exec failed.", diagnose_cmd_str)
        shell_cmd_str = "rm " + TMP_AUTID_LOG
        os.system(shell_cmd_str)
        return 0, 0
    local_node_id = ''
    node_max = ''
    group_max = ''
    with open(TMP_AUTID_LOG) as lines_of_file:
        lines_array = lines_of_file.readlines()
        for line in lines_array:
            if len(local_node_id) != 0 and len(node_max) != 0 and len(group_max) != 0:
                break
            fields = line.split(":")
            if len(fields) < 2:
                continue
            if 'local node id' == fields[0].strip():
                local_node_id = "".join(fields[1:len(fields)]).strip()
            if 'node max' == fields[0].strip():
                node_max = "".join(fields[1:len(fields)]).strip()
            if 'group max' == fields[0].strip():
                group_max = "".join(fields[1:len(fields)]).strip()
    #  临时文件使用后删除
    shell_cmd_str = "rm " + TMP_AUTID_LOG
    os.system(shell_cmd_str)
    return local_node_id, int(int(node_max) / int(group_max))


def check_disk_in_scope():
    """ 控制器的个数 """
    current_node_id, node_num = get_node_info()
    if node_num == 0:
        return False
    # 获取产品型号
    engine_height = node_num
    product_model = get_product_model()
    if product_model in (PRODUCT_DORADO_V6 + PRODUCT_HYBRID_V6 + PRODUCT_DORADO_V6_K):
        engine_height = get_engine_height_on_mini_system_model()
    if is_in_audit_log_risk_devices(current_node_id, engine_height):
        return True
    return False


def main():
    """
    不在检查范围则返回巡检通过
    """
    if not check_disk_in_scope():
        print("True")
        return 0
    if check_disk_smart():
        print("False")
        return 0
    print("True")
    return 0


if __name__ == '__main__':
    sys.exit(main())
