#!/bin/bash
# BMC主从切换

function bmc_master_slave_check()
{
    array=(2410 2c10 3510)
    # 查看当前设备是否为高端，高端直接返回，不做该巡检项
    ret=`ipmitool raw 0x32 0x09 0x00 0x02 0x00 0x00 0x00`
    if [ "$?" == 0 ];then
        ret=`echo $ret | sed s/[[:space:]]//g`
        if [[ "${array[@]}" =~ "$ret" ]]; then
            # 高端设备直接返回巡检成功，不做以下操作
            return 0
        else
            # 检查本控是否为主控，若为主控，直接返回
            ret=`ipmitool raw 0x32 0x1d 0x01 0x02 0x00 0x00 0x00`
            ret=`echo $ret | sed s/[[:space:]]//g`
            if [ "$ret" == "01" ]; then
                return 0
            else
                # 若为从控，延时5s，再做切主动作
                sleep 5
                ret=`ipmitool raw 0x32 0x1c 0x00 0x02 0x00 0x00 0x00 0x01`
                if [ "$?" == 0 ];then
                    sleep 5
                    # 切主后延时5s，查询主备状态
                    ret=`ipmitool raw 0x32 0x1d 0x00 0x02 0x00 0x00 0x00`
                    ret=`echo $ret | sed s/[[:space:]]//g`
                    if [ "$ret" == "01" ];then
                        return 0
                    else
                        return 1
                    fi
                fi
            fi
        fi
    fi
}

bmc_master_slave_check
if [ $? -ne 0 ]; then
	echo "False"
	exit 0
fi

echo "True"
exit 0
