#!/bin/bash
#!/bin/bash
# 检查当前中端环境; 板载SAS端口的数量是否为0，如果为0，则是问题，如果不是0，则不存在问题。 
# 避免升级后被线缆检测新策略直接生效, 错误拦截盘框接入.
# 先检查是否为V6 板载SAS硬件, 如果不是, 不需要检查, 默认返回TRUE.
# 再检查是否有.port info: portid:0x22002心跳口，如果有心跳口,判断此命令成功
# 最后检查板载SAS内存数量，如果数量为0，则为此问题，返回错误，判定线缆连接错误。

get_devm_pro_num()
{ 
#首先尝试获取devm的进程号
ret=$(pgrep "devm")
if [ -n "$ret" ];then
	devm_pro_num=21
else
#没有devm进程，则可能是进程融合版本，获取app_data的进程号
	devm_pro_num=12
fi
}

#获取进程号
get_devm_pro_num
if [[ "${devm_pro_num}" == "" ]]; then
    echo "Can not get process id of devm or app_data"
    exit 0
fi

function dmi_exec_diagu(){
diagnose_usr --auto <<EOF
attach ${devm_pro_num}
$*
exit
EOF
}

function dmi_check_sas_port()
{
local result="True"
local result_file="/tmp/dmichecksasportlog"

#软连接校验
if [ -L "$result_file" ];then
    echo "Soft Link exist"
    exit 1
fi

dmi_exec_diagu "dpl ls fru" > "$result_file"
hard_ware_middle=`cat "$result_file" | grep -w "0x1020" | wc -l`
rm -f "$result_file"
    OS_echo "pangea_sas_port_check.sh hard_ware_middle $hard_ware_middle."
if [ $hard_ware_middle -eq 0 ] ; then
    result="True"
else
    dmi_exec_diagu "msc showsnap port" > "$result_file"
    checkcmdsuccessful=`cat "$result_file" | grep -w "port info: portid:0x22002" | wc -l`
    checksasport=`cat "$result_file" | grep "port info: portid:0x1092200" | wc -l`
    OS_echo "pangea_sas_port_check.sh checkcmdsuccessful $checkcmdsuccessful checksasport $checksasport."
    if [ $checkcmdsuccessful -ne 0 ] ; then
        if [ $checksasport -eq 0 ] ; then
            result="False"
        else
            result="True"
        fi
    else
        result="True"
    fi
    rm -f "$result_file"
fi
echo $result
}
dmi_check_sas_port