#!/bin/bash
##pool后台均衡任务状态是Running,可能导致升级过程中数据不一致##
checkFlag=0
oneDpFlag=0
starttime=`date +'%Y-%m-%d %H:%M:%S'`
start_seconds=$(date --date="$starttime" +%s)
#check balance status
function checkTaskRunningStatus()
{
  flowIds=(40 64 65)
  for flowId in "${flowIds[@]}"
  do
    status=`diagsh --attach="app_data_12" --cmd="pool showflow $flowId" | grep CurStatus=|awk -F ',' '{print $3}'`
    if [ -n "$status" ];then
      if [ $status == 'CurStatus=Running' ];then
          checkFlag=1
          break
      else
          checkFlag=0
      fi
    fi
  done
}

function checkOneDpCondition()
{
    #如果非0,则检查1min,直到检查到为0才退出，否则检查不通过,超时时间80s
    for ((i=0;i<60;i++))
    do {
        checkTaskRunningStatus $1
        if [ $checkFlag -eq 0 ]; then
            break
        fi
        sleep 1s
        curtime=`date +'%Y-%m-%d %H:%M:%S'`
        curtime_seconds=$(date --date="$curtime" +%s)
        let costime=$curtime_seconds-$start_seconds
        if [ $costime -gt 80 ]; then
            echo "False"
            exit 0
        fi
    }
    done
}

checkOneDpCondition $1
if [ $checkFlag -eq 1 ]; then
	oneDpFlag=1
fi


if [ $oneDpFlag -eq 1 ]; then
    # check fail
    echo "False"
else
    # check pass
    echo "True"
fi

exit 0


