#!/bin/bash
# 内存分级检查
# 脚本检查存在风险输出 False，否则输出 True

version_615="7600511219"

# 检查升级目标版本存在问题
function check_target_version_exist_bug()
{
    if [ -f "/startup_disk/image/pkg_upd/manifest.yml" ]; then
        local dst_version=$(head /startup_disk/image/pkg_upd/manifest.yml | grep " Version:" | awk '{print $2}')

        if [ "$dst_version" -lt "$version_615" ]; then
            mu_value=$(cat /proc/osp/bsp | grep -o '\<mu:[01]\>' | awk -F ':' '{print $2}')
            if [ "$mu_value" = "1" ]; then
                echo "False"
                return 0
            fi
        fi
    fi

    echo "True"
    return 0
}

check_target_version_exist_bug

exit 0