#!/bin/sh 
GRAB_VERSION="1.0.1"
set_val()
{
    eval $1=\"$2\"
}
get_val()
{
    eval echo \"'$'$1\"
}

decode()
{
    str=$1
    str=`echo "$str" | sed -e 's/\\\\\*/*/g'`
    echo "$str"
}

call_single_cmd()
{
    cmd=$1
    outputitems=$2
    echo "$cmd"
    if [ "$G_isInteractive" = "true" ];then
        write_interactive_cmd "$cmd"
        return
    fi
    
    echo call cmd "$cmd" >>${LOG_FILE} 2>&1
    echo StartCmd:"$cmd" >>${ECHO_FILE} 2>&1
    cmdkey=`echo "$cmd" | awk '{print $1}'`
    
    if [ "$cmdkey" = "cd" ];then
        eval "$cmd"  >>${LOG_FILE} 2>&1
        if [ "$?" != "0" ];then
            mkdir "$basepath"/tmp >>${LOG_FILE} 2>&1
            cd "$basepath"/tmp >>${LOG_FILE} 2>&1
        fi
        G_cmdecho=`eval "$cmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
    elif [ "$cmdkey" = "ll" ];then
        tempcmd=`echo "$cmd" | sed 's/ll/ls -l/'`
        G_cmdecho=`eval "$tempcmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
        eval "$tempcmd"  >>${LOG_FILE} 2>&1
    elif [ "$cmdkey" = "parted" ];then
        G_cmdecho=`echo cancel | "$cmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
    elif [ "$cmdkey" = "/bin/ls" ];then
        G_cmdecho=`eval "$cmd" 2>>${ECHO_FILE}`
        echo $G_cmdecho >>${ECHO_FILE} 2>&1
    elif echo "$cmd" | grep 'format';then
        G_cmdecho=`eval "$cmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
    elif [ -n "$outputitems" ];then
        G_cmdecho=`eval "$cmd" 2>>${ECHO_FILE}`
        echo "$G_cmdecho" >>${ECHO_FILE} 2>&1
    else
        G_cmdecho=`eval "$cmd" >>${ECHO_FILE} 2>&1`
    fi
    
    if [ "$cmdkey" = "mpathadm" ];then
        echo "" >>${ECHO_FILE}
    fi
    if echo "$cmd" | grep 'qaucli'; then
        echo "" >>${ECHO_FILE}
    fi
    count=`tail -n 1 ${ECHO_FILE} | wc -l` 2>>${ECHO_FILE}
    if [ "$count" = "0" ];then
        echo "">>${ECHO_FILE} 2>&1
    fi
    echo EndCmd:"$cmd" >>${ECHO_FILE} 2>&1
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
}

write_interactive_cmd()
{
    cmd=$1
    echo "$cmd" >>$basepath/temp_data
}

call_interactive_cmd()
{
    echo StartCmd:interactivecmd >>${ECHO_FILE} 2>&1
    cat $INTERACT_FILE >>${ECHO_FILE} 2>&1
    echo "####InteractiveEcho####" >>${ECHO_FILE} 2>&1

    interactive_cmd=`cat $INTERACT_FILE | sed -n '1p'`
    sed -e '1d' $INTERACT_FILE >temp
    echo "$interactive_cmd"
    eval "$interactive_cmd" < temp >>${ECHO_FILE} 2>&1
    if [ "$interactive_cmd" = "qaucli" ];then
        echo "" >>${ECHO_FILE}
    fi
    echo EndCmd:interactivecmd >>${ECHO_FILE} 2>&1
    rm -f temp
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
}

get_full_cmd()
{   
    cmd=${1}
    params=${2}
    flowid=${3}
    
    for param in "${params}";do
        param=`echo "$param" | sed -e 's#/#\\\/#g'`
        cmd=`echo "$cmd" | sed -e 's/%s/'"${param}"'/'`
    done
    cmd=`echo "$cmd" | sed -e 's/#/$/g'`
    echo get_full_cmd: "$cmd" >>${LOG_FILE} 2>&1
    echo "$cmd"
}

get_tag_items()
{
    rootId=$1
    parentId=$2
    tag=$3
    ret=`get_val ${rootId}_${parentId}_${tag}items | sed -e 's/#/ /g'`
    echo $ret
}

get_tag_obj_name()
{
    rootId=$1
    parentId=$2
    elementId=$3
    tag=$4
    echo ${rootId}_${parentId}_${elementId}_${tag}obj
}

get_output()
{
    rootId=$1
    name=$2
    get_val ${rootId}_output_${name}
}

set_output()
{
    rootId=$1
    name=$2
    value=$3
    echo "setoutput name=${rootId}_output_${name}, value=${value}" >>${LOG_FILE} 2>&1
    set_val "${rootId}_output_${name}" "${value}"
}

get_attr_val()
{   
    objname=$1
    attr=$2
    ret=`get_val ${objname}_${attr}`
    ret=`decode "$ret"`
    echo "$ret"
}

save_output()
{
    flowid=$1
    operid=$2
    cmdecho=$3
    outputitems=`get_tag_items ${flowid} ${operid} output`
    
    if [ -n "outputitems" ];then
        for outputid in $outputitems;do
            outputobjname=`get_tag_obj_name $flowid $operid $outputid output`
            name=`get_attr_val ${outputobjname} name`
            value=`get_attr_val ${outputobjname} value`
            echo "save_output: name=${name}, value=${value}, cmdecho=${cmdecho}" >>${LOG_FILE} 2>&1
            if [ "${value}" = '#1' ];then
                value="$cmdecho"
            elif [ "$value" != "#1" ];then
                value=`echo $value |sed -e s/#1// | sed -e 's/#/$/g'`
                value='"$cmdecho"'"$value"
                value=`eval echo "$value"`
            fi
            set_output "$flowid" "$name" "$value"
        done
    fi
}

parse_operation_obj()
{
    flowid=$1
    innerflowid=$2
    operid=$3
    
    if [ -n "$nextoperation" ] && [ "$nextoperation" != "$operid" ];then
        echo "skip the operation:${operid}" >>${LOG_FILE} 2>&1
        return
    fi
    
    echo "operation begin====flowid=${flowid},innerflowid=${innerflowid},operid=${operid}" >>${LOG_FILE} 2>&1
    operationobjname=`get_tag_obj_name ${flowid} ${innerflowid} ${operid} operation`
    cmd=`get_attr_val ${operationobjname} cmd`
    params_var=`get_attr_val ${operationobjname} params`
    loopcmd=`get_attr_val ${operationobjname} loopcmd`
    breakWhenContains=`get_attr_val ${operationobjname} breakWhenContains`
    loop=`get_attr_val ${operationobjname} loop`
    nextoperation=`get_attr_val ${operationobjname} next`
    params=`get_output "$flowid" "$params_var"`
    outputitems=`get_tag_items ${flowid} ${operid} output`
    echo "operationobjname=${operationobjname}, cmd="${cmd}",params_var=${params_var},params=${params}" >>${LOG_FILE} 2>&1
    echo "loopcmd=${loopcmd},loop=${loop},nextoperation=${nextoperation}" >>${LOG_FILE} 2>&1
    if [ -n "$loopcmd" ];then
        if [ -n "$breakWhenContains" ];then
            for param in $params;do
                full_cmd=`get_full_cmd "$loopcmd" "$param" "$flowid"`
                call_single_cmd "$full_cmd" "$outputitems"
                save_output "$flowid" "$operid" "$G_cmdecho"
                if tail -10 ${ECHO_FILE} | grep -i "$breakWhenContains";then
                    break
                fi
            done
        else
            for param in $params;do
                full_cmd=`get_full_cmd "$loopcmd" "$param" "$flowid"`
                call_single_cmd "$full_cmd" "$outputitems"
                save_output "$flowid" "$operid" "$G_cmdecho" 
            done
        fi
    elif [ -n "$loop" ];then
        loop_var=`echo $loop | awk '{print $1}'`
        loop_data_key=`echo $loop | awk '{print $3}'`
        loop_datas=`get_output ${flowid} ${loop_data_key}`
        
        for data in $loop_datas; do
            set_output "${flowid}" "${loop_var}" "$data"
            full_cmd=`get_full_cmd "$cmd" "$params" "$flowid"`
            call_single_cmd "$full_cmd" "$outputitems"
            save_output "$flowid" "$operid" "$G_cmdecho"
        done
        
    else
        full_cmd=`get_full_cmd "$cmd" "$params" "$flowid"`
        call_single_cmd "$full_cmd" "$outputitems"
        save_output "$flowid" "$operid" "$G_cmdecho"
    fi
    echo "operation end" >>${LOG_FILE} 2>&1

}


parse_innerflow_obj()
{
    flowid=$1
    innerflowid=$2
    if [ -n "$nextinnerflow" ] && [ "$nextinnerflow" != "$innerflowid" ];then
        echo "skip the innerflow:${innerflowid}" >>${LOG_FILE} 2>&1
        return
    fi
    echo "innerflow begin====flowid=${flowid},innerflowid=${innerflowid}" >>${LOG_FILE} 2>&1
    innerflowobjname=`get_tag_obj_name ${flowid} ${flowid} ${innerflowid} innerflow`
    operation_items=`get_tag_items ${flowid} ${innerflowid} operation`
    loop=`get_attr_val ${innerflowobjname} loop`
    nextinnerflow=`get_attr_val ${innerflowobjname} next`
    type=`get_attr_val ${innerflowobjname} type`
    
    echo "innerflowobjname=${innerflowobjname}, loop=${loop},nextinnerflow=${nextinnerflow}, operation_items=${operation_items}" >>${LOG_FILE} 2>&1
    if [ -n "$loop" ]; then
        loop_var=`echo $loop | awk '{print $1}'`
        loop_data_key=`echo $loop | awk '{print $3}'`
        loop_datas=`get_output ${flowid} ${loop_data_key}`
        
        for data in $loop_datas; do
            if [ "$type" = "interactive" ];then
                G_isInteractive="true"
                rm -f $INTERACT_FILE
            fi
            for operid in ${operation_items} ;do
                set_output "${flowid}" "${loop_var}" "${data}"
                parse_operation_obj "${flowid}" "${innerflowid}" "${operid}"
            done
            if [ "$type" = "interactive" ];then
                call_interactive_cmd
                G_isInteractive="false"
                rm -f $INTERACT_FILE
            fi
        done
    else
        if [ "$type" = "interactive" ];then
            G_isInteractive="true"
            rm -f $INTERACT_FILE
        fi
        for operid in ${operation_items};do
            parse_operation_obj "${flowid}" "${innerflowid}" "${operid}"
        done

        if [ "$type" = "interactive" ];then
            call_interactive_cmd
            G_isInteractive="false"
            rm -f $INTERACT_FILE
        fi
    fi
    
    echo "innerflow end" >>${LOG_FILE} 2>&1
}


Linux_adapter()
{
    export LC_ALL=en_US.UTF-8
    deviceIP="127.0.0.1"
    fileName="Linux_data.sh"
}

AIX_adapter()
{
    export LC_ALL=en_US
    deviceIP="127.0.0.1"
    fileName="AIX_data.sh"
}

HPUX_adapter()
{
    export LANG=en_US.utf8
    deviceIP="127.0.0.1"
    fileName="HP-UX_data.sh"
    hostType="HP-UX"
}

Solaris_adapter()
{
    deviceIP="127.0.0.1"
    fileName="Solaris_data.sh"
}

VMware_adapter()
{
    deviceIP="127.0.0.1"
    fileName="VMware_data.sh"
}

get_hostBaseInfo()
{
    dateTmp=`date "+%Y%m%d%H%M"`
    cd `dirname $0`
    basepath=`pwd`

    hostType="UNKnown"
    fileName="Linux_data.sh"
    deviceIP="127.0.0.1"
    cmdRet=`uname -a`
    releaseRet=`cat /etc/*release`
    if echo $cmdRet | grep -i "vmkernel"; then
        hostType="VMware"
    elif echo $cmdRet | grep -i "linux"; then
        hostType="Linux"
    elif echo ${releaseRet} | grep -i "solaris"; then
        hostType="Solaris"
    elif echo $cmdRet | grep -i "aix"; then
        hostType="AIX"
    elif echo $cmdRet | grep -i "hp-ux"; then
        hostType="HPUX"
    else
        echo "Process Error:" $cmdRet
    fi

    if [ -n "$G_type" ];then
        hostType="$G_type"
        eval "${hostType}_adapter"
    else
        eval "${hostType}_adapter"
    fi
    
    if [ -z "${deviceIP}" ]; then
        deviceIP="127.0.0.1"
    fi
    
    collectCmdFilePath="$basepath/command/${fileName}"
    chmod u+x ${collectCmdFilePath}
    . ${collectCmdFilePath}

    collectFileName="${hostType}_${deviceIP}_${dateTmp}.data"
    collectLogFile="CollectLog_${deviceIP}_${dateTmp}.txt"
    ECHO_FILE=$basepath/${collectFileName}
    LOG_FILE=$basepath/${collectLogFile}
    INTERACT_FILE=$basepath/temp_data
    
    username=`echo $USER`
    if [ "$username" != "" ] && [ "$username" != "root" ];then
        while :
        do
            echo "The current user is not root, some commands may fail to execute, do you continue?[Y|N]:"
            read inputVal
            if [ "$inputVal" = "Y" ] || [ "$inputVal" = "y" ]; then
                echo username=$username inputVal=$inputVal >>${LOG_FILE} 2>&1
                break
            elif [ "$inputVal" = "N" ] || [ "$inputVal" = "n" ]; then
                exit 1
            fi
        done
    fi
}

write_basicinfo()
{
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
    os=${hostType}
    ip=${deviceIP}
    echo "StartCmd:self_define_cmd_basicinfo" >>${ECHO_FILE} 2>&1
    echo "${os}" >>${ECHO_FILE} 2>&1
    echo "${ip}" >>${ECHO_FILE} 2>&1
    echo "EndCmd:self_define_cmd_basicinfo" >>${ECHO_FILE} 2>&1
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
}

write_checkinfo()
{
    echo "StartCmd:self_define_cmd_checkinfo" >>${ECHO_FILE} 2>&1
    echo "version:${GRAB_VERSION}" >>${ECHO_FILE} 2>&1
    echo "EndCmd:self_define_cmd_checkinfo" >>${ECHO_FILE} 2>&1
    echo "###########################################################################" >>${ECHO_FILE} 2>&1
}

usage()
{
    echo "Usage:|sh main.sh [-type AIX|HP-UX|Linux|Solaris|VMware]"
    echo "|-help  |: Displays this help screen"
    echo "|-type  |: - Specify grab host information."
    echo "|  |: AIX|HP-UX|Linux|Solaris|VMware - Grab host information, which is not required. and the program can automatically identify the host type"
}

verify()
{
    valide="false"
    for type in `echo "AIX|HP-UX|Linux|Solaris|VMware" | sed -e 's/|/ /g'`; do
        if [ "$type" = "$G_type" ]; then
            valide="true"
        fi
    done
    if [ "$G_type" != "" ] && [ "$valide" = "false" ]; then
        echo not support type: $G_type
        usage; exit 1;
    fi
    for scene in `echo "migration" | sed -e 's/|/ /g'`; do
        if [ "$scene" = "$G_scene" ]; then
            valide="true"
        fi
    done
    if [ "$valide" = "false" ]; then
        echo not support scene: $G_scene; usage; exit 1;
    fi
}

nextinnerflow=""
nextoperation=""
G_cmdecho=""
G_isInteractive="false"
G_type=""
G_scene=migration
extra_collect=""

para="para: ";
while [ $# -ge 1 ] ; do
        case "$1" in
                -type)  para="${para} argument $1 = $2"; G_type=$2; shift 2;;
                -scene) para="${para} argument $1 = $2"; G_scene=$2; shift 2;;
                *) usage; exit 1 ; break;;
        esac
done

umask 0027
verify

get_hostBaseInfo

write_basicinfo


echo $para >>${LOG_FILE} 2>&1
echo "[Note] Begin to collect information."
echo "This operation will take 3 to 5 minutes, please wait..."
sceneflowitems=`get_val root_flowitems_${G_scene}`
flowitems=`echo ${sceneflowitems} | sed -e 's/#/ /g'`
for flowid in $flowitems; do
    echo "flow begin=====flowid=$flowid" >>${LOG_FILE} 2>&1
    innerflow_items=`get_tag_items "${flowid}" "${flowid}" "innerflow"`
    for innerflowid in ${innerflow_items};do
        parse_innerflow_obj "${flowid}" "${innerflowid}"
    done 
    echo "flow end" >>${LOG_FILE} 2>&1
done

if [ -n "$extra_collect" ];then
    eval "$extra_collect"
fi
write_checkinfo
echo "[Note] The operation succeed."
echo "(1) The infomation collection file is: "$ECHO_FILE
echo "(2) The log file is: "$LOG_FILE
