# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus

from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

pass_version_dic = {
    "6.1.2": "SPH8",
    "6.1.2RC1": "SPH8",     # 没有补丁，必须升级
    "6.1.2RC2": "SPH8"      # 没有补丁，必须升级
}


class CheckItem(BaseCheckItem):
    def execute(self):

        # 获取基本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        base_version = version_info.get("base_version").get("Current Version")
        if base_version not in pass_version_dic:
            return CheckStatus.PASS, ""
        elif compare_patch_version(patch_version, pass_version_dic.get(base_version)) >= 0:
            return CheckStatus.PASS, ""
        result_info = self.dsl("exec_diagnose 'nas_proto_pum -m nfs -c show_nfs4_activelease_count' | vertical_parser")
        for result_msg in result_info:
            if int(result_msg.get("Active lease count", 0)) > 0:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""
