# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.util import json_util
from psdk.platform.protocol.rest import rest_service
from psdk.platform.protocol.rest.rest_common_service import RestCommonService
from psdk.platform.protocol.rest import rest_constant
from psdk.platform.base.exception import RestExecuteException
from psdk.platform.entity.base_context import DevNode
from psdk.platform.adapter import java_connector_factory as connector

import com.huawei.ism.tool.framework.pubservice.entity.DevNode as DevNode
import com.huawei.ism.tool.framework.pubservice.entity.User as User


def exec_tlv_cmd_by_dev_node(tlv_cmd, param_dict, dev_node):
    uri = rest_constant.TLV_COMMUNICATION
    rest_cmd = {'cmd': tlv_cmd, 'timeout': rest_constant.REST_TIMEOUT}
    rest_param_dict = RestCommonService.tlv_to_rest_param(param_dict)
    rest_cmd.update({"params": rest_param_dict})
    con = connector.get_rest_con(dev_node)
    url = con.getBaseUrl() + uri
    param_json = json_util.covert_dict_to_json(rest_cmd)
    response_str = con.execPost(url, param_json).getContent()
    response = json_util.covert_json_to_dict(response_str)
    err_code = str(response.get("error", {}).get("code", "0"))
    if err_code != "0":
        return None
    return response.get("data", [])
