# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import re
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.execute_env import UpgradeExecuteEnv, ExpansionExecuteEnv
from psdk.platform.util.product_util import compare_patch_version

product_version_tuple = ("V500R007C10", "V300R001C21SPC100")
v5r7c10_bios_flag_tuple = ("BiosFlag", "V500R007C10SPH033BiosFlag")


class CheckItem(BaseCheckItem):

    @staticmethod
    def v5r7c10_patch_bios_flag_match(sph_version, bios_flag):
        if not sph_version or sph_version == '--' or compare_patch_version(sph_version, "V500R007C10SPH039") >= 0:
            return True
        if bios_flag in v5r7c10_bios_flag_tuple:
            return False
        return True

    def execute(self):
        # 检查方法: 步骤1：查询当前阵列产品版本
        version_info = get_version_info(self.dsl)
        # 获取产品版本和补丁版本,获取不到产品版本和补丁版本返回不通过
        pro_version = version_info.get("base_version").get("Current Version")
        sph_version = version_info.get("patch_version").get("Current Version")
        # 查看步骤1的产品型号是否为V500R007C10 V300R001C21SPC100版本，不为该版本则通过检查
        if pro_version not in product_version_tuple:
            self.logger.info("no product version in given product version map. check pass")
            return CheckStatus.PASS, ""
        # 步骤3  在minisystem下键入命令ls -l /startup_disk/conf/conf_local 查看是否有Flag文件
        ctrl_flag_files = self.dsl("exec_on_all {}", self.query_flag_file)
        for _, ctrl_files in ctrl_flag_files.items():
            # 如果该环境上面所有控没有flag文件，则返回通过，否则继续检查版本配套关系
            if not ctrl_files:
                continue
            for bios_flag in ctrl_files:
                # 判断产品版本是否是V300R001C21SPC100以及对应的bios文件名是否是BiosFlag，如果是则返回检查不通过
                if any([pro_version == "V300R001C21SPC100" and bios_flag == "BiosFlag",
                        pro_version == "V500R007C10" and not self.v5r7c10_patch_bios_flag_match(sph_version,
                                                                                                bios_flag)]):
                    return CheckStatus.NOT_PASS, \
                           self.get_msg("check.not.pass.bios.flag", pro_version, sph_version, bios_flag)
        return CheckStatus.PASS, ""

    def query_flag_file(self):
        bios_flag_list = self.dsl("exec_mini_system 'ls -l /startup_disk/conf/conf_local' | splitlines")
        file_names = [line.split()[-1] for line in bios_flag_list if "BiosFlag" in line.split()[-1]]
        return file_names
