# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):
        """
        检查方法步骤1：使用dsl执行命令获取系统所有DNS zone的名称
        """
        dns_zone_name_info = self.dsl(
            "exec_cli 'show dns_zone general' | horizontal_parser",
            return_if={ft.CmdNoSupport: "notSupport", },
        )
        if dns_zone_name_info == "notSupport" or not dns_zone_name_info:
            return CheckStatus.PASS, ""
        """
        检查方法步骤2：获取每个DNS zone里面的成员端口
        """
        logical_port_not_pass = list()
        for zone_info in dns_zone_name_info:
            name = zone_info.get("Zone Name")
            logical_port_info = self.dsl(
                "exec_cli 'show logical_port general dns_zone_name={}' | "
                "horizontal_parser".format(name)
            )
            if not logical_port_info:
                continue
            self.get_exception_logical_port(logical_port_info, logical_port_not_pass)
        if logical_port_not_pass:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", ",".join(logical_port_not_pass))
        return CheckStatus.PASS, ""

    def get_exception_logical_port(self, logical_port_info, logical_port_not_pass):
        """
        检查方法步骤3：获取每个DNS zone里面的成员端口
        """
        error_logical_port_list = [
            logical_port.get("Logical Port Name")
            for logical_port in logical_port_info
            if (
                (logical_port.get("Running Status") != "Link Up")
                and (logical_port.get("Running Status") != "Standby")
            )
        ]
        for logical_port_name in error_logical_port_list:
            port_info = self.dsl(
                "exec_cli 'show logical_port general logical_port_name={}' | vertical_parser".format(
                    logical_port_name)
            )
            if not port_info:
                continue
            """
            检查步骤4：逻辑端口是激活的，但是逻辑端口的运行状态不是Link Up或者Standby,则需要排查物理端口的状态
            """
            if port_info[0].get("Activation Status") == "Yes":
                logical_port_not_pass.append(logical_port_name)
