# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version


pass_version_dict = {
    "6.0.1": "SPH21",
    "6.1.0": "SPH9",
    "V500R007C60SPC300": "V500R007C60SPH322",
    "V500R007C71SPC100": "V500R007C71SPH107",
    "6.0.0": "",
    "V500R007C70": "",
    "V500R007C70SPC200": ""
}


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取基本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        base_version = version_info.get("base_version").get("Current Version")

        # 执行检查
        if base_version not in pass_version_dict:
            return CheckStatus.PASS, ""

        if (pass_version_dict.get(base_version)) and compare_patch_version(patch_version, pass_version_dict[base_version]) >= 0:
            return CheckStatus.PASS, ""

        result_info = self.dsl("exec_developer 'show port general physical_type=FC' | horizontal_parser")
        if result_info:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
        else:
            return CheckStatus.PASS, ""
